<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
if($SKIP_WHMCS === false) {
    try {
        $license_check = crm_v2_license_919::validate();
        $_SESSION["errorMessageLicense"] = NULL;
    } catch (Exception $ex) {
        $_SESSION["errorMessageLicense"] = $exc->getMessage();
    }
}
if(!defined("DS")) {
    define("DS", DIRECTORY_SEPARATOR);
    if(!function_exists("r") && file_exists(ROOTDIR . "/includes/hooks/php-ref-debug.php")) {
        require_once ROOTDIR . "/includes/hooks/php-ref-debug.php";
    }
    require_once "app/vendor/autoload.php";
    require "app/app.php";
}
class crm_v2_license_919PDOWrapper
{
    private static $pdoConnection;
    private static function getDbConnection()
    {
        if(class_exists("Illuminate\\Database\\Capsule\\Manager")) {
            return Illuminate\Database\Capsule\Manager::connection()->getPdo();
        }
        if(self::$pdoConnection === NULL) {
            self::$pdoConnection = self::setNewConnection();
        }
        return self::$pdoConnection;
    }
    private static function setNewConnection()
    {
        try {
            $includePath = ROOTDIR . DIRECTORY_SEPARATOR . "configuration.php";
            if(file_exists($includePath)) {
                require $includePath;
                $connection = new PDO(sprintf("mysql:host=%s;dbname=%s;port=%s;charset=utf8", $db_host, $db_name, $db_port ? $db_port : 3360), $db_username, $db_password);
                $connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                return $connection;
            }
            throw new Exception("No configuration file found");
        } catch (PDOException $ex) {
        }
    }
    public static function query($query, $params = [])
    {
        $statement = self::getDbConnection()->prepare($query);
        $statement->execute($params);
        return $statement;
    }
    public static function real_escape_string($string)
    {
        return substr(self::getDbConnection()->quote($string), 1, -1);
    }
    public static function fetch_assoc($query)
    {
        return $query->fetch(PDO::FETCH_ASSOC);
    }
    public static function fetch_array($query)
    {
        return $query->fetch(PDO::FETCH_BOTH);
    }
    public static function fetch_object($query)
    {
        return $query->fetch(PDO::FETCH_OBJ);
    }
    public static function num_rows($query)
    {
        $query->fetch(PDO::FETCH_BOTH);
        return $query->rowCount();
    }
    public static function insert_id()
    {
        return self::getDbConnection()->lastInsertId();
    }
    public static function errorInfo()
    {
        $tmpErr = self::getDbConnection()->errorInfo();
        if($tmpErr[0] && $tmpErr[0] !== "00000") {
            return $tmpErr;
        }
        return false;
    }
    public static function mysql_get_array($query, $params = [])
    {
        $qRes = self::query($query, $params);
        $arr = [];
        while ($row = self::fetch_assoc($qRes)) {
            $arr[] = $row;
        }
        return $arr;
    }
    public static function mysql_get_row($query, $params = [])
    {
        $qRes = self::query($query, $params);
        return self::fetch_assoc($qRes);
    }
}
final class crm_v2_license_919
{
    /**
     * @var array
     */
    private $servers = ["https://www.modulesgarden.com/client-area/"];
    private $db = "crm_v2_license_919PDOWrapper";
    private $verifyPath = "modules/servers/licensing/verify2.php";
    private $moduleName;
    private $secret = "";
    private $dir;
    private $licenseKey = "";
    private $cert = "-----BEGIN CERTIFICATE-----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\r\nxw==\r\n-----END CERTIFICATE-----";
    const STATUS_ACTIVE = 1;
    const STATUS_INVALID = 2;
    const STATUS_INVALID_IP = 3;
    const STATUS_INVALID_DOMAIN = 4;
    const STATUS_INVALID_DIRECTORY = 5;
    const STATUS_EXPIRED = 6;
    const STATUS_NO_CONNECTION = 7;
    const STATUS_WRONG_RESPONSE = 8;
    const INVALID_LICENSE_CONTENT = 9;
    const ERRORS = ["1" => "Your module license is active", "2" => "Your module license is invalid", "3" => "Your module license is invalid", "4" => "Your module license is invalid", "5" => "Your module license is invalid", "6" => "Your module license has expired", "7" => "Connection cannot be established. Please report your server's IP address to support@modulesgarden.com", "8" => "Connection cannot be established. Please report your server's IP address to support@modulesgarden.com", "9" => "Invalid license content. Please check license.php file"];
    private function __construct()
    {
        $this->moduleName = "crm_v2";
        $this->dir = $this->getModuleDir();
        $this->secret = "ce30393a7068ca6e2b97724c074963aa";
        $this->buildKey = "664f42a103b5e";
        if(!function_exists("curl_exec")) {
            throw new Exception("Please install curl library");
        }
    }
    protected function __clone()
    {
    }
    public static function validate()
    {
        $checker = new self();
        try {
            return $checker->readLicenseKey()->validateKey();
        } catch (Exception $ex) {
            throw new Exception($checker->getErrorMessage($ex->getCode(), $ex->getMessage()));
        }
    }
    public static function getLicenseData($force = false)
    {
        $checker = new self();
        try {
            if($force) {
                $checker->readLicenseKey();
                $checker->getLicenseFromServerAndStore();
            }
            return $checker->getLocalKey();
        } catch (Exception $ex) {
            throw new Exception($checker->getErrorMessage($ex->getCode(), $ex->getMessage()));
        }
    }
    private function readLicenseKey()
    {
        $file = $this->dir . "/license.php";
        $fileRename = $this->dir . "/license_RENAME.php";
        if(!file_exists($file) && file_exists($fileRename)) {
            throw new Exception($this->moduleName . ": Unable to find " . $file . " file. Please rename file license_RENAME.php to license.php");
        }
        if(!file_exists($file)) {
            throw new Exception("Unable to find " . $file . " file.");
        }
        $keyName = $this->moduleName . "_licensekey";
        $content = file_get_contents($file);
        $matches = [];
        preg_match("/" . $keyName . "\\s?=\\s?\\\"([A-Za-z0-9_]+)\\\"/", $content, $matches);
        $key = $matches[1];
        if(!$key) {
            throw new Exception("Invalid license content", 9);
        }
        $this->licenseKey = $key;
        return $this;
    }
    // @ioncube.dynamickey encoding key: crm_v2_license_919_hash('crm_v2')
    // Encryption type: 1
    private function validateKey()
    {
        $localKey = [];
        try {
            $localKey = $this->getLocalKey();
            $this->validateKeyData($localKey);
        } catch (Exception $ex) {
            try {
                $remoteKey = $this->getLicenseFromServerAndStore();
                $this->validateKeyData($remoteKey);
                return true;
            } catch (Exception $ex) {
                try {
                    $this->validateTimeHard($localKey);
                    return true;
                } catch (Exception $ex) {
                }
                throw $ex;
            }
            throw $ex;
        }
        return true;
    }
    // @ioncube.dynamickey encoding key: crm_v2_license_919_hash('crm_v2')
    // Encryption type: 1
    private function getLicenseFromServerAndStore()
    {
        $data = ["licensekey" => $this->licenseKey, "domain" => $this->getWhmcsDomain(), "ip" => $this->getIp(), "dir" => $this->dir, "whmcs" => $this->getWhmcsVersion(), "module" => $this->getModuleVersion(), "php" => phpversion()];
        $data = array_merge($this->getLicenseUsage(), $data);
        $license = NULL;
        $lastException = NULL;
        foreach ($this->servers as $server) {
            try {
                $response = $this->callServer($server, $data);
                $license = $this->decode($response);
                $this->storeLicense($response);
                return $license;
            } catch (Exception $ex) {
                $lastException = $ex;
            }
        }
        throw $lastException;
    }
    protected function getLicenseUsage()
    {
        $file = pathinfo($this->dir)["filename"];
        $func = "\\" . $file . "_LicenseUsage";
        if(!function_exists($func)) {
            return [];
        }
        return (array) $func();
    }
    // @ioncube.dynamickey encoding key: crm_v2_license_919_hash('crm_v2')
    // Encryption type: 1
    private function storeLicense($license)
    {
        $query_result = call_user_func($this->db . "::query")("SELECT value FROM tblconfiguration WHERE setting = '" . $this->moduleName . "_localkey'");
        $query_row = call_user_func($this->db . "::fetch_assoc")($query_result);
        if(isset($query_row["value"])) {
            call_user_func($this->db . "::query")("UPDATE tblconfiguration SET value = '" . call_user_func($this->db . "::real_escape_string")($license) . "' WHERE setting = '" . $this->moduleName . "_localkey'");
        } else {
            call_user_func($this->db . "::query")("INSERT INTO tblconfiguration (setting,value) VALUES ('" . $this->moduleName . "_localkey','" . call_user_func($this->db . "::real_escape_string")($license) . "')");
        }
        return true;
    }
    private function callServer($url, $data)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url . $this->verifyPath);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_TIMEOUT, 15);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        if($httpCode !== 200) {
            throw new Exception("No Connection", 7);
        }
        return $response;
    }
    private function parseServeResponse($response)
    {
        preg_match_all("/<(.*?)>([^<]+)<\\/\\1>/i", $response, $matches);
        $results = [];
        foreach ($matches[1] as $k => $v) {
            $results[$v] = $matches[2][$k];
        }
        if(!is_array($results)) {
            throw new Exception("Wrong response from server", 8);
        }
        return $results;
    }
    // @ioncube.dynamickey encoding key: crm_v2_license_919_hash('crm_v2')
    // Encryption type: 1
    private function decode($data)
    {
        if(!$data) {
            throw new Exception("No data to decode", 2);
        }
        $key = openssl_pkey_get_public($this->cert);
        $info = openssl_pkey_get_details($key);
        $chunks = str_split(base64_decode($data), $info["bits"] / 8);
        $out = "";
        foreach ($chunks as $chunk) {
            openssl_public_decrypt($chunk, $decrypted, $key, OPENSSL_PKCS1_PADDING);
            $out .= $decrypted;
        }
        if(!$out) {
            throw new Exception("Cannot decrypt data", 2);
        }
        $decoded = json_decode($out, true);
        if(!$decoded) {
            throw new Exception("Cannot decode decrypted data", 2);
        }
        return $decoded;
    }
    // @ioncube.dynamickey encoding key: crm_v2_license_919_hash('crm_v2')
    // Encryption type: 1
    private function getLocalKey()
    {
        $key = WHMCS\Database\Capsule::table("tblconfiguration")->where("setting", $this->moduleName . "_localkey")->first();
        if(!$key) {
            return [];
        }
        return $this->decode($key->value);
    }
    private function validateKeyData($key, $checkDate = true)
    {
        $this->validateFormat($key);
        $this->validateStatus($key);
        $this->validateTimeSoft($key);
        $this->validateDomain($key);
        $this->validateIp($key);
        $this->validateDirectory($key);
        return true;
    }
    private function validateFormat($key)
    {
        if(empty($key) || !is_array($key)) {
            throw new Exception("invalid data", 2);
        }
    }
    private function validateStatus($key)
    {
        switch ($key["status"]) {
            case "Active":
                return true;
                break;
            case "Invalid":
                throw new Exception($key["message"], 2);
                break;
            default:
                throw new Exception("invalid status: " . $key["status"], 6);
        }
    }
    private function validateTimeSoft($key)
    {
        if(empty($key["valid_until_soft"]) || $key["valid_until_soft"] < time()) {
            throw new Exception("validity time (soft)", 6);
        }
    }
    private function validateTimeHard($key)
    {
        if(empty($key["valid_until_hard"]) || $key["valid_until_hard"] < time()) {
            throw new Exception("validity time (hard)", 6);
        }
    }
    private function validateDirectory($key)
    {
        $validDirectory = explode(",", $key["validdirectory"], 5);
        if(!in_array($this->dir, $validDirectory)) {
            throw new Exception("invalid directory: " . $this->dir);
        }
    }
    private function validateIp($key)
    {
        $validips = explode(",", $key["validip"]);
        $usersip = $this->getIp();
        if(!empty($usersip) && !in_array($usersip, $validips) && $validips) {
            throw new Exception("invalid ip: " . $usersip, 3);
        }
    }
    private function validateDomain($key)
    {
        $validDomains = explode(",", $key["validdomain"]);
        if($this->getWhmcsDomain() && !in_array($this->getWhmcsDomain(), $validDomains)) {
            throw new Exception("invalid domain: " . $this->getWhmcsDomain(), 4);
        }
    }
    private function getWhmcsVersion()
    {
        global $CONFIG;
        return $CONFIG["Version"];
    }
    private function getWhmcsDomain()
    {
        if(!empty($_SERVER["SERVER_NAME"])) {
            return $_SERVER["SERVER_NAME"];
        }
        global $CONFIG;
        return parse_url($CONFIG["SystemURL"], PHP_URL_HOST);
    }
    private function getModuleVersion()
    {
        $moduleVersionFile = $this->dir . "/moduleVersion.php";
        $moduleVersion = "";
        if(file_exists($moduleVersionFile)) {
            $content = file_get_contents($moduleVersionFile);
            preg_match("/\\\$moduleVersion\\s?=\\s?'([A-Za-z0-9_\\.\\-]+)'/", $content, $matches);
            $moduleVersion = trim($matches[1]);
            if(!$moduleVersion) {
                throw new Exception("Invalid module version");
            }
        }
        return $moduleVersion ? $moduleVersion : NULL;
    }
    private function getModuleDir()
    {
        return __DIR__;
    }
    private function fileExists($file, $elements)
    {
        $path = is_array($elements) ? implode(DIRECTORY_SEPARATOR, $elements) : $elements;
        return file_exists($path . DIRECTORY_SEPARATOR . $file);
    }
    private function getErrorMessage($code, $message)
    {
        return !empty(["1" => "Your module license is active", "2" => "Your module license is invalid", "3" => "Your module license is invalid", "4" => "Your module license is invalid", "5" => "Your module license is invalid", "6" => "Your module license has expired", "7" => "Connection cannot be established. Please report your server's IP address to support@modulesgarden.com", "8" => "Connection cannot be established. Please report your server's IP address to support@modulesgarden.com", "9" => "Invalid license content. Please check license.php file"][$code]) ? ["1" => "Your module license is active", "2" => "Your module license is invalid", "3" => "Your module license is invalid", "4" => "Your module license is invalid", "5" => "Your module license is invalid", "6" => "Your module license has expired", "7" => "Connection cannot be established. Please report your server's IP address to support@modulesgarden.com", "8" => "Connection cannot be established. Please report your server's IP address to support@modulesgarden.com", "9" => "Invalid license content. Please check license.php file"][$code] . " (" . $message . ")" : $message;
    }
    private function getIp()
    {
        return isset($_SERVER["SERVER_ADDR"]) ? $_SERVER["SERVER_ADDR"] : $_SERVER["LOCAL_ADDR"];
    }
}
function crm_v2_license_919_hash($val)
{
    if($val != "crm_v2") {
        throw new Exception("Invalid value");
    }
    return "664f42a103b5e";
}

?>