<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
defined("WHMCS");
defined("WHMCS") or exit("This file cannot be accessed directly");
defined("WHMCS");
if(!defined("DS")) {
    define("DS", DIRECTORY_SEPARATOR);
    require_once ROOTDIR . "/modules/addons/mgCRM2/app/database/" . "PDOWrapper.php";
}
function mgCRM2_config($vars = [])
{
    $file = dirname(__FILE__) . DS . "moduleVersion.php";
    if(file_exists($file)) {
        include $file;
    }
    $moduleWikiUrl = isset($moduleWikiUrl) ? $moduleWikiUrl : "";
    $moduleName = basename(__FILE__, ".php");
    $moduleFriendlyName = "CRMv2";
    $moduleNamePrefix = !isset($moduleVersion) ? "<span class=\"label terminated\" style=\"float: right;\"><b>THIS IS DEVELOPMENT VERSION !!!!!!!!!!</b></span>" : "";
    $moduleDescription = "Use Customer Relationship Manager to control and mange any relations among your clients and contacts on an advanced level.";
    $moduleDescription .= !empty($moduleWikiUrl) ? "<br/>For more info please visit our <a title='ModulesGarden Wiki' style='color: #4169E1;' href='" . $moduleWikiUrl . "'>Wiki</a>" : "";
    $moduleVersion = isset($moduleVersion) ? $moduleVersion : "2.9.0";
    $adminGroups = [];
    $moduleAccess = mgCRM2\Database\PDOWrapper::fetch_assoc(mgCRM2\Database\PDOWrapper::query("SELECT value FROM `tbladdonmodules` WHERE module = '" . $moduleName . "' AND setting = 'access';"));
    if(is_array($moduleAccess) && !empty($moduleAccess["value"])) {
        $query = mgCRM2\Database\PDOWrapper::query("SELECT id, name  FROM `tbladminroles` WHERE id IN (" . $moduleAccess["value"] . ") order by name asc");
        while ($row = mgCRM2\Database\PDOWrapper::fetch_object($query)) {
            $adminGroups[] = $row;
        }
        $moduleAccess = array_shift($moduleAccess);
        $moduleAccess = explode(",", $moduleAccess);
    } else {
        $moduleAccess = [];
    }
    if(0 < count($adminGroups)) {
        $groupAccessed = "Choose the admin role groups that will have Full access to module " . $moduleFriendlyName . ":<br />";
        foreach ($adminGroups as $group) {
            $groupAccessed .= "<label class=\"checkbox-inline\"><input type='checkbox' name='admincheck[]' value='" . $group->id . "' />" . $group->name . "</label>";
        }
    } else {
        $groupAccessed = "<b>Currently there is no admin role group that can access module.</b>";
    }
    $script = "        <script type=\"text/javascript\">\n            \$(document).ready(function(){\n                var fulladminsgrouppr = \$(\"input[name='fields[" . $moduleName . "][fullaccessadmins]']\").hide().val().split(\",\");\n                \$.each(fulladminsgrouppr,function(k,v){\n                    \$(\"input[name='fields[" . $moduleName . "][fullaccessadmins]']\").closest('td').find(\"input[name^=admincheck][value='\"+v+\"']\").attr(\"checked\",true);\n                });\n\n                \$(\"input[name^=admincheck]\").on(\"click\",function(){\n                    roles = []\n                    \$.each(\$(this).closest('td').find('input[name^=admincheck]:checked'),function(k,v){\n                        roles.push(\$(v).val());\n                    });\n                    \$(this).closest('td').find('input[name^=fields]').attr('value', roles.join(','));\n                });\n\n                \$('td > a[name=mgCRM2').prepend('<img src=\"../modules/addons/mgCRM2/templates/ModulesGarden/assets/img/favicon.png\" />');\n\n            });\n        </script>";
    return ["name" => $moduleFriendlyName, "description" => $moduleNamePrefix . $moduleDescription, "version" => $moduleVersion, "author" => "<a href=\"http://www.modulesgarden.com\" targer=\"_blank\">ModulesGarden</a>", "fields" => ["renderStandalone" => ["FriendlyName" => "CRM as standalone page", "Type" => "yesno", "Size" => "25", "Default" => 0, "Description" => "If Enabled, CRM module page will be renderred independently, regardless WHMCS adminarea template."], "fullaccessadmins" => ["FriendlyName" => "Full Access Admins", "Type" => "text", "Size" => "25", "Description" => $groupAccessed . $script]]];
}
function mgCRM2_output($vars)
{
    if(empty($_REQUEST["error"]) || $_REQUEST["error"] === "") {
        header("Location: crm.php");
        exit;
    }
    $error = $_REQUEST["error"];
    $refresh = "<br><a href='" . $_SERVER["PHP_SELF"] . "?module=mgCRM2'><span>Refresh</span></a>";
    if(is_numeric($error)) {
        require_once __DIR__ . DS . "app" . DS . "errorMessages.php";
        echo "<div class='alert alert-danger'>" . $errors[$error] . $refresh . "</div>";
    }
    echo "<div class='alert alert-danger'>" . $error . $refresh . "</div>";
}
function mgCRM2_clientarea($vars)
{
}
function mgCRM2_activate()
{
    try {
        if(version_compare(phpversion(), "5.3.7", "<")) {
            throw new Exception(sprintf("(1/4): Minimum required PHP version is 5.3.7. You are running on %s version. Please update PHP version first.", phpversion()));
        }
        global $customadminpath;
        if(!file_exists(ROOTDIR . "/" . $customadminpath . "/crm.php")) {
            throw new Exception(sprintf("(2/4): Module Was not uploaded correctly. File %s does not exists.", ROOTDIR . "/" . $customadminpath . "/crm.php"));
        }
        $path = __DIR__ . "/app/Storage";
        $old = umask(0);
        if(!file_exists($path) || !is_dir($path)) {
            mkdir($path, 493, true);
        }
        $path = __DIR__ . "/app/Storage/files";
        if(!file_exists($path) || !is_dir($path)) {
            mkdir($path, 493, true);
        }
        $path = __DIR__ . "/app/Storage/logs";
        if(!file_exists($path) || !is_dir($path)) {
            mkdir($path, 493, true);
        }
        umask($old);
        $collation = mgCRM2\Database\PDOWrapper::fetch_object(mgCRM2\Database\PDOWrapper::query("show variables like 'collation_database'"))->Value;
        $dBcharset = mgCRM2\Database\PDOWrapper::fetch_object(mgCRM2\Database\PDOWrapper::query("show variables like 'character_set_database'"))->Value;
        $path = __DIR__ . "/app/Storage/db";
        if(!file_exists($path) || !is_dir($path)) {
            mkdir($path, 493, true);
        }
        $fullPathConfigCSV = $path . "/config.csv";
        if(file_exists($fullPathConfigCSV)) {
            unlink($fullPathConfigCSV);
        }
        $file = fopen($fullPathConfigCSV, "w");
        if($file) {
            fputcsv($file, [$collation, $dBcharset]);
            fclose($file);
        }
        if(!is_writable(__DIR__ . "/app/Storage")) {
            throw new Exception(sprintf("(3/4): Directory %s is NOT Writable. Unable to continue.", __DIR__ . "/app/Storage"));
        }
        if(!is_dir(__DIR__ . "/app/vendor") || !is_dir(__DIR__ . "/app/vendor/composer") || !is_dir(__DIR__ . "/app/vendor/slim") || !is_dir(__DIR__ . "/app/vendor/illuminate") || !file_exists(__DIR__ . "/app/vendor/autoload.php")) {
            throw new Exception(sprintf("(4/4): Module dependiences was not been installed correctly. Run '%s' in directory %s.", "composer install", __DIR__ . "/app"));
        }
        $errors = mgCRM2_perQueryFromFile("/app/database/2.0.0/schema.sql");
        if(!empty($errors)) {
            throw new Exception(implode(";", $errors));
        }
        $errors = mgCRM2_perQueryFromFile("/app/database/2.0.0/relations.sql");
        mgCRM2_perQueryFromFile("/app/database/2.0.0/data.sql");
        mgCRM2_runUpgradeQueries("2.1.0");
        mgCRM2_runUpgradeQueries("2.2.0");
        mgCRM2_runUpgradeQueries("2.3.0");
        mgCRM2_runUpgradeQueries("2.4.0");
        mgCRM2_runUpgradeQueries("2.5.0");
        mgCRM2_runUpgradeQueries("2.6.0");
        mgCRM2_runUpgradeQueries("2.6.3");
        mgCRM2_runUpgradeQueries("2.7.0");
        mgCRM2_runUpgradeQueries("2.8.1");
        mgCRM2_runUpgradeQueries("2.9.0");
        mgCRM2_runUpgradeQueries("2.10.0");
    } catch (Exception $e) {
        return ["status" => "error", "description" => "Error: " . $e->getMessage()];
    }
}
function mgCRM2_runUpgradeQueries($version)
{
    if(file_exists(__DIR__ . sprintf("/app/database/updates/%s_schema.sql", $version))) {
        $errors = mgCRM2_perQueryFromFile(sprintf("/app/database/updates/%s_schema.sql", $version));
        if(!empty($errors)) {
            throw new Exception(implode(";", $errors));
        }
    }
    if(file_exists(__DIR__ . sprintf("/app/database/updates/%s_relations.sql", $version))) {
        mgCRM2_perQueryFromFile(sprintf("/app/database/updates/%s_relations.sql", $version));
    }
    if(file_exists(__DIR__ . sprintf("/app/database/updates/%s_data.sql", $version))) {
        mgCRM2_perQueryFromFile(sprintf("/app/database/updates/%s_data.sql", $version));
    }
}
function mgCRM2_upgrade($vars)
{
    try {
        if(isset($vars["version"])) {
            $version = $vars["version"];
        } elseif(isset($vars["mgCRM2"]) && is_array($vars["mgCRM2"])) {
            $version = $vars["mgCRM2"]["version"];
        }
        if(version_compare($version, "2.1.0", "<")) {
            mgcrm2_runupgradequeries("2.1.0");
        }
        if(version_compare($version, "2.2.0", "<")) {
            mgcrm2_runupgradequeries("2.2.0");
        }
        if(version_compare($version, "2.3.0", "<")) {
            mgcrm2_runupgradequeries("2.3.0");
        }
        if(version_compare($version, "2.4.0", "<")) {
            mgcrm2_runupgradequeries("2.4.0");
        }
        if(version_compare($version, "2.5.0", "<")) {
            mgcrm2_runupgradequeries("2.5.0");
        }
        if(version_compare($version, "2.6.0", "<")) {
            mgcrm2_runupgradequeries("2.6.0");
        }
        if(version_compare($version, "2.6.3", "<")) {
            mgcrm2_runupgradequeries("2.6.3");
        }
        if(version_compare($version, "2.7.0", "<")) {
            mgcrm2_runupgradequeries("2.7.0");
        }
        if(version_compare($version, "2.8.1", "<")) {
            mgcrm2_runupgradequeries("2.8.1");
        }
        if(version_compare($version, "2.9.0", "<")) {
            mgcrm2_runupgradequeries("2.9.0");
        }
        if(version_compare($version, "2.10.0", "<")) {
            mgcrm2_runupgradequeries("2.10.0");
        }
    } catch (Exception $e) {
        return ["status" => "error", "description" => "Error: " . $e->getMessage()];
    }
}
function mgCRM2_deactivate()
{
    try {
    } catch (Exception $e) {
        return ["status" => "error", "description" => "Error: " . $e->getMessage()];
    }
}
function mgCRM2_perQueryFromFile($file = "")
{
    $query = file_get_contents(__DIR__ . $file);
    $queries = explode(";", $query);
    $results = [];
    foreach ($queries as $i => $query) {
        try {
            if(!empty($query)) {
                mgCRM2\Database\PDOWrapper::query($query);
            }
        } catch (PDOException $ex) {
            $results[] = sprintf("Query (%s/%s) in file `%s`, error: %s", $i + 1, count($queries), $file, $ex->getMessage());
        }
    }
    return $results;
}

?>