<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
$relid = (int) $_GET["crm_resource"];
if(is_numeric($relid) && !empty($relid)) {
    try {
        $mappedValues = [];
        ob_clean();
        $mapperRaw = WHMCS\Database\Capsule::table("crm_settings")->select("value")->where("name", "fields_map")->first();
        $mapper = json_decode($mapperRaw->value);
        $resourceRaw = WHMCS\Database\Capsule::table("crm_resources")->where("id", $relid)->first();
        if($resourceRaw->id) {
            $standardFields = (array) $mapper->static;
            foreach ($standardFields as $clientField => $fieldname) {
                $mappedValues[$clientField] = hook_mgcrm2_getmappervalue($resourceRaw, $fieldname);
            }
            $customFields = (array) $mapper->custom;
            foreach ($customFields as $clientCustomFieldID => $crmCustomFieldID) {
                $mappedValues["customfield[" . $clientCustomFieldID . "]"][] = hook_mgcrm2_getmappervalue($resourceRaw, $crmCustomFieldID);
            }
        }
        $json = json_encode($mappedValues);
        $output = "        <script type=\"text/javascript\">\n            var crmfieldsvalues = " . $json . ";\n            \$(document).ready(function(){\n                \$(\"#frmAddUser\").attr(\"action\",\$(\"#frmAddUser\").attr(\"action\")+\"&crm_resource=" . $relid . "\")\n                \$(\"#frmAddUser\").prepend(\"<input type='hidden' name='crm_resource' value='" . $relid . "' />\");\n                \$.each(crmfieldsvalues,function(field,value){\n                    \$(\"#frmAddUser\").find(\"[name='\"+field+\"']\").val(value);\n                });\n            });\n        </script>";
    } catch (Exception $e) {
        logModuleCall("CRM", "hook_mgCRM_AdminAreaClientAddForm", array_merge($vars, $_GET), "Exception: " . $e->getMessage());
    }
}
function hook_mgCRM2_getMapperValue($resourceRaw, $fieldname)
{
    $val = "";
    if($fieldname[["id" => true, "name" => true, "lastname" => true, "email" => true, "phone" => true, "country" => true]]) {
        $val = $resourceRaw->{$fieldname};
    } elseif($fieldname == "client" && is_numeric($resourceRaw->client_id)) {
        $q = WHMCS\Database\Capsule::table("tblclients")->selectRaw("CONCAT(firstname, ' ', lastname) as fullname")->where("id", $resourceRaw->client_id)->first();
        if($q && !empty($q->fullname)) {
            $val = $q->fullname;
        }
    } elseif($fieldname == "admin" && is_numeric($resourceRaw->admin_id)) {
        $q = WHMCS\Database\Capsule::table("tbladmins")->selectRaw("concat(firstname, \" \", lastname) as fullname")->where("id", $resourceRaw->admin_id)->first();
        if($q && !empty($q->fullname)) {
            $val = $q->fullname;
        }
    } elseif($fieldname == "status" && is_numeric($resourceRaw->status_id)) {
        $q = WHMCS\Database\Capsule::table("crm_resources_statuses")->select("name")->where("id", $resourceRaw->status_id)->first();
        if($q && !empty($q->name)) {
            $val = $q->name;
        }
    } elseif($fieldname == "ticket" && is_numeric($resourceRaw->ticket_id)) {
        $q = WHMCS\Database\Capsule::table("tbltickets")->select("title")->where("id", $resourceRaw->status_id)->first();
        if($q && !empty($q->title)) {
            $val = $q->title;
        }
    } elseif($fieldname == "priority") {
        $priorities = ["2" => "Medium", "3" => "important", "4" => "Urgent"];
        if(in_array($resourceRaw->priority, $priorities)) {
            $val = $priorities[$resourceRaw->priority];
        } else {
            $val = "Low";
        }
    } elseif(is_numeric($fieldname)) {
        $resourceClass = WHMCS\Database\Capsule::table("crm_fields_data as f")->leftJoin("crm_fields_data_options as d", "d.field_data_id", "=", "f.id")->leftJoin("crm_fields_options as o", "d.option_id", "=", "o.id")->select("f.id as field_data_id", "f.data as field_data", "f.field_type", "o.id as option_id", "o.value as option_value")->where("f.resource_id", $resourceRaw->id)->where("f.field_id", $fieldname)->first();
        $q = json_decode(json_encode($resourceClass), true);
        if($q && $q["field_data_id"]) {
            if($q["field_type"][["text" => true, "textarea" => true]]) {
                $val = $q["field_data"];
            } else {
                $val = $q["option_value"];
            }
        }
    }
    return $val;
}

?>