<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
Slim\Route::setDefaultConditions(["id" => "\\d+", "responseFormat" => "(html|json)"]);
$app->get("/", "mgCRM2\\Controllers\\Home:index");
$app->group("/api", function () use($app) {
    $app->get("/", "mgCRM2\\Controllers\\Api\\Home:index");
    $app->get("/test(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Home:test");
    $app->get("/debug(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Home:debug");
    $app->get("/test/logs", "mgCRM2\\Controllers\\Api\\Home:generateTestLogs");
    $app->group("/samplePage", function () use($app) {
        $app->get("/test", "mgCRM2\\Controllers\\Api\\SamplePages:test");
        $app->get("/page/:template", "mgCRM2\\Controllers\\Api\\SamplePages:page");
    });
    $app->group("/lead", function () use($app) {
        $app->get("/:id/getLeadHeaderData(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Lead:getLeadHeaderData");
        $app->get("/:id/getLeadSummaryData(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Lead:getLeadSummaryData");
    });
    $app->group("/dashboard", function () use($app) {
        $app->post("/followups/get(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Dashboard\\DashboardFollowups:getForTable")->name("followups/getFor");
        $app->get("/followups/get(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Dashboard\\DashboardFollowups:getForTable");
        $app->post("/logs/get(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Dashboard\\DashboardLogs:getForTable");
        $app->get("/logs/get(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Dashboard\\DashboardLogs:getForTable");
        $app->post("/emails(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Dashboard\\DashboardEmail:getForTable");
        $app->get("/emails(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Dashboard\\DashboardEmail:getForTable");
        $app->post("/calendar(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Dashboard\\DashboardCalendar:getCounters");
        $app->get("/background(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Helpers\\DashboardHelper:backgroundData");
    });
    $app->group("/contacts", function () use($app) {
        $app->get("/table/query(/:query)", "mgCRM2\\Controllers\\Api\\Resources\\ContactrsList:queryTable")->name("contacts/get");
        $app->post("/table/query(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ContactrsList:queryTable");
        $app->get("/list(/:query)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesList:query");
        $app->post("/create/getParams(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesList:getCreateParams");
        $app->post("/getCountres(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesList:getCountryList");
        $app->post("/create(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesList:createLead")->name("contacts/add");
        $app->get("/create(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesList:createLead");
        $app->post("/archive/query(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ContactrsList:queryArchiveTable");
        $app->get("/archive/query(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ContactrsList:queryArchiveTable");
        $app->post("/change/priority(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ContactrsList:changePriority");
        $app->post("/change/type(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ContactrsList:changeType");
        $app->post("/change/status(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ContactrsList:changeStatus");
        $app->post("/assign/admin(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ContactrsList:assignAdmin");
        $app->post("/change/date(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ContactrsList:changeDateFollowups");
        $app->post("/reschedule(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ContactrsList:rescheduleReminders");
        $app->post("/reschedule/on/admin(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ContactrsList:rescheduleOnAdminReminders");
        $app->post("/reassign/labels(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ContactrsList:reassignLabels");
    });
    $app->group("/leads", function () {
    });
    $app->group("/potentials", function () use($app) {
        $app->post("/table/query(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesList:PotentialsTableQuery");
        $app->get("/table/query(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesList:PotentialsTableQuery");
    });
    $app->group("/board", function () use($app) {
        $app->get("/label(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Board\\Labels:getLabels");
        $app->post("/label(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Board\\Labels:updateOrder");
        $app->post("/label/:id/add(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Board\\Labels:addLabel");
        $app->post("/label/:id/delete(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Board\\Labels:removeLabel");
    });
    $app->group("/lead", function () use($app) {
        $app->get("/:id/getMainDetails(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceSingle:getMainDetails")->name("contacts/getSingle");
        $app->get("/:id/getTypeDetails(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceSingle:getTypeDetails")->name("contacts/getTypeDetails");
        $app->post("/:id/updateSingleParam(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceSingle:updateSingleParam");
        $app->post("/:id/sync/campaigns(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceSingle:syncAssignedCampaigns")->name("contacts/syncCampaigns");
        $app->post("/:id/updatefield(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesFields:updatefield");
        $app->post("/:id/softDelete(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceSingle:softDelete");
        $app->post("/:id/forceDelete/delete(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceSingle:forceDelete");
        $app->post("/forceDelete(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceSingle:forceMassActionDelete");
        $app->post("/moveToArchiveClients(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceSingle:moveToArchiveClients");
        $app->post("/restoreFromArchiveClients(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceSingle:restoreFromArchiveClients");
        $app->post("/:id/restore(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceSingle:restoreSoftDeleted");
        $app->post("/:id/forceDelete(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceSingle:forceDelete");
        $app->post("/:id/reassign/ticket(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceSingle:reassignTicket");
        $app->post("/:id/reassign/client(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceSingle:reassignClient");
        $app->post("/:id/reassign/country(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceSingle:reassignCountry");
        $app->post("/:id/reassign/labels(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceSingle:reassignLabels");
        $app->get("/:id/notes/get(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceNotes:get")->name("contacts/getNotes");
        $app->get("/:id/notes/get/:limit(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceNotes:getLimited");
        $app->get("/:id/notes/getAdmins(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceNotes:getAdmins");
        $app->get("/:id/notes/getWithDeleted(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceNotes:getWithDeleted");
        $app->get("/:id/notes/getWithDeleted/:limit(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceNotes:getWithDeletedLimited");
        $app->post("/:id/notes/add(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceNotes:addNote")->name("contacts/addNote");
        $app->post("/:id/notes/:noteID/edit(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceNotes:editNote");
        $app->post("/:id/notes/:noteID/delete(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceNotes:softDelete");
        $app->post("/:id/notes/:noteID/force/delete(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceNotes:forceDelete");
        $app->post("/:id/notes/:noteID/resotre(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourceNotes:restoreDeleted");
        $app->get("/:id/logs(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesLogs:get");
        $app->post("/:id/logs(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesLogs:parseForTable");
        $app->get("/:id/quotes(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesQuotes:get");
        $app->get("/:id/quotes/sync(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesQuotes:sync");
        $app->post("/:id/quotes(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesQuotes:parseForTable");
        $app->get("/:id/orders(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesOrders:parseForTable");
        $app->post("/:id/orders(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesOrders:parseForTable");
        $app->get("/:id/logs/emails(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesLogEmails:get");
        $app->post("/:id/logs/emails(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesLogEmails:parseForTable");
        $app->post("/:id/emails/notifications/create(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Notifications\\NotificationsHelpers:checkForEmailNotifications");
        $app->post("/:id/emails/send(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesLogEmails:sendEmail");
        $app->post("/:id/sms/send/forcewhmcs(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesLogSms:send");
        $app->post("/:id/files/upload(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Files\\Manage:uploadFile");
        $app->post("/:id/files(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Files\\Manage:parseForTable");
        $app->get("/info/file(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Files\\Manage:getMaximumFileSize");
        $app->get("/:id/files(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Files\\Manage:parseForTable");
        $app->get("/:id/files/:fileId", "mgCRM2\\Controllers\\Api\\Files\\Manage:getFile");
        $app->post("/:id/files/:fileId/delete(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Files\\Manage:deleteFile");
        $app->get("/:id/field/getAll(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesFields:getAll");
        $app->post("/:id/followups/getForTable(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesFollowups:getForTable")->name("contacts/getFollowups");
        $app->post("/:id/followups/addWithReminders(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesFollowups:addWithReminders");
        $app->post("/:id/followups/addWithoutReminders(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesFollowups:addWithoutReminders")->name("contacts/addFollowup");
        $app->get("/:id/followups/:followupID(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesFollowups:getSingleFollowup");
        $app->get("/:id/followups/getSingle/:followupID(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesFollowups:getSingleFollowupWithReminders");
        $app->post("/:id/followups/getSingle/:followupID/update(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesFollowups:updateSingleFollowup");
        $app->post("/:id/followups/:followupID/delete(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesFollowups:deleteSingleFollowup");
        $app->post("/:id/followups/:followupID/reschedue(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesFollowups:reschedueFollowup");
        $app->get("/:id/followups/:followupID/reminders(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesFollowupReminders:get");
        $app->post("/:id/followups/:followupID/reminders/list(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesFollowupReminders:post");
        $app->get("/:id/followups/:followupID/reminders/:reminderID(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesFollowupReminders:getSingle");
        $app->post("/:id/followups/:followupID/reminders(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesFollowupReminders:createSingle")->name("contacts/followups/addReminder");
        $app->post("/:id/followups/:followupID/reminders/:reminderID(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesFollowupReminders:updateSingle");
        $app->post("/:id/followups/:followupID/reminders/:reminderID/delete(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesFollowupReminders:deleteSingle");
        $app->get("/:id/tickets(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesTicket:get");
        $app->get("/:id/tickets/sync(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesTicket:sync");
        $app->post("/:id/tickets(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesTicket:parseForTable");
        $app->post("/ticket/:id/respond/forcewhmcs(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesTicket:sendTicketResponse");
    });
    $app->group("/helpers", function () use($app) {
        $app->post("/select/clients(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Helpers\\SelectInput:findClients");
        $app->post("/select/client/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Helpers\\SelectInput:findClient");
        $app->post("/select/resources(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Helpers\\SelectInput:findResources");
        $app->post("/select/country(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Helpers\\SelectInput:findCountry");
        $app->post("/select/tickets(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Helpers\\SelectInput:findTicket");
        $app->get("/select/adminToReassign(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Helpers\\SelectInput:findAdminsToReassign");
        $app->get("/lead/backgroundFormData(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Helpers\\SelectInput:backgroundFormData");
        $app->post("/lead/backgroundFormData(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Helpers\\SelectInput:backgroundFormData");
        $app->get("/get/whmcs/customfields(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Helpers\\Whmcs:getCustomFields");
        $app->get("/lead/background/followups(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Helpers\\SelectInput:backgroundForFollowups");
        $app->get("/lead/background/all(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Helpers\\Data:getLeadUsefull");
        $app->get("/popup/summary/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Helpers\\Popups:resourceSummary");
        $app->get("/resources/table(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Helpers\\Data:getResourcesTableHelpers");
        $app->get("/massmessages/get(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Helpers\\Data:getMassMessagesHelpers");
    });
    $app->group("/whmcs", function () use($app) {
        $app->get("/getVersion", "mgCRM2\\Controllers\\Api\\Whmcs\\Api:getVersion")->name("whmcs/getVersion");
    });
    $app->group("/calendar", function () use($app) {
        $app->get("/followups/my(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Followups\\ListCalendar:getMine");
        $app->get("/followups/admin/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Followups\\ListCalendar:getForAdmin")->name("followups/getForAdmin");
        $app->get("/followups/admins(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Followups\\ListCalendar:getForAllAdmins");
        $app->get("/followups/:id/reminders(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Followups\\ListCalendar:getFollowupReminders")->name("followups/getReminders");
    });
    $app->group("/statistics", function () use($app) {
        $app->post("/last/per/status(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Statistics\\LastPerStatus:getForPieChart");
        $app->post("/last/ten(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Statistics\\LastTenRecords:get");
        $app->post("/total/per/admin(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Statistics\\TotalPerAdmin:get");
        $app->post("/total/per/month(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Statistics\\TotalPerMonth:get");
        $app->post("/new/yearly(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Statistics\\TotalInYear:get");
    });
    $app->group("/migration", function () use($app) {
        $app->get("/overview(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Migrator\\MigrationOverview:getOverview");
        $app->post("/perform(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Migrator\\MigrationOverview:startMigration");
        $app->get("/actual/getFields(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Migrator\\MigrationOverview:getNewVersionFields");
        $app->get("/actual/getStatuses(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Migrator\\MigrationOverview:getNewVersionStatuses");
        $app->get("/old/getStatuses(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Migrator\\MigrationOverview:getOldVersionStatuses");
        $app->get("/old/getFields(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Migrator\\MigrationOverview:getOldVersionFields");
    });
    $app->group("/settings", function () use($app) {
        $app->get("/statuses(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldStatuses:query")->name("settings/getContactStatuses");
        $app->get("/statuses/dashboard/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldStatuses:queryDashboard");
        $app->post("/statuses/dashboard(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldStatuses:generateSummary");
        $app->post("/statuses/add(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldStatuses:add");
        $app->post("/statuses/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldStatuses:delete");
        $app->post("/statuses(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldStatuses:massUpdate");
        $app->post("/statuses/reorder(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldStatuses:reorder");
        $app->get("/statuses/importmail/general(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Mailbox\\ReceiveMessage:generalData");
        $app->post("/statuses/importmail/get(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Mailbox\\ReceiveMessage:get");
        $app->post("/statuses/importmail/send(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Mailbox\\ReceiveMessage:sendMessage");
        $app->post("/statuses/importmail/remove/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Mailbox\\ReceiveMessage:removeMessage");
        $app->get("/statuses/importmail/attachment/:id/download", "mgCRM2\\Controllers\\Api\\Mailbox\\Attachment:download");
        $app->get("/fieldgroups(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldGroups:query")->name("settings/getFieldGroups");
        $app->post("/fieldgroups/add(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldGroups:addGroup");
        $app->post("/fieldgroups/reorder(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldGroups:reorder");
        $app->post("/fieldgroups/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldGroups:updateGroup");
        $app->post("/fieldgroups/:id/delete(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldGroups:deleteGroup");
        $app->get("/permissions/adminroles(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\PermissionGroups:getWhmcsAdminRoles");
        $app->get("/permissions/groups(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\PermissionGroups:getRoles");
        $app->get("/permissions/groups/providers(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\PermissionGroups:getProviders");
        $app->post("/permissions/groups/add(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\PermissionGroups:addRole");
        $app->post("/permissions/groups/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\PermissionGroups:updateRole");
        $app->post("/permissions/groups/:id/delete(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\PermissionGroups:deleteRole");
        $app->get("/permissions/mine(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\PermissionGroups:getMinePermissions");
        $app->get("/permissions/rules/config(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\PermissionGroups:getRulesConfig");
        $app->get("/permissions/rules/parsed(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\PermissionGroups:getParsedRules");
        $app->get("/fields(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldsManage:query")->name("settings/getFields");
        $app->post("/fields/add(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldsManage:addField");
        $app->post("/fields/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldsManage:updateField");
        $app->get("/fields/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldsManage:getField");
        $app->post("/fields/:id/delete(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldsManage:deleteField");
        $app->post("/fields/reorder(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldsManage:reorder");
        $app->get("/fields/:id/validators(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldsManage:getValidatorFor");
        $app->post("/fields/:id/validators/add(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldsManage:addValidator");
        $app->post("/fields/:id/validators/:validatorID/delete(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldsManage:deleteValidator");
        $app->get("/fields/:id/options(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldsManage:getFieldOption");
        $app->post("/fields/:id/options/add(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldsManage:addFieldOption");
        $app->post("/fields/:id/options/:optionsID/delete(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldsManage:deleteFieldOption");
        $app->post("/fields/:id/options/:optionsID(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldsManage:updateOption");
        $app->get("/fields/withgroups(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldGroups:queryFields")->name("settings/getFieldsWithGroups");
        $app->get("/fields/views(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldView:allColumns");
        $app->get("/fields/views/forme(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldView:getForAdmin");
        $app->get("/fields/views/for/:type(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldView:getTopeForAdmin");
        $app->post("/fields/views/store(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\FieldView:updateForAdmin");
        $app->get("/fields/map/get(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\ManageSettings:getFieldsMap");
        $app->post("/fields/map/update(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\ManageSettings:updateFieldsMap");
        $app->get("/general/followupType(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\TypeFollowups:get")->name("followups/getTypes");
        $app->post("/general/followupType/add(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\TypeFollowups:addType");
        $app->post("/general/followupType/reorder(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\TypeFollowups:reorder");
        $app->post("/general/followupType/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\TypeFollowups:updateType");
        $app->post("/general/followupType/:id/delete(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\TypeFollowups:deleteType");
        $app->get("/general/followupStatus(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\StatusFollowups:get")->name("followups/getStatuses");
        $app->post("/general/followupStatus/add(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\StatusFollowups:addStatus");
        $app->post("/general/followupStatus/reorder(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\StatusFollowups:reorder");
        $app->post("/general/followupStatus/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\StatusFollowups:updateStatus");
        $app->post("/general/followupStatus/:id/delete(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\StatusFollowups:deleteStatus");
        $app->get("/general/auth/google(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\GeneralSettings:returnAuth")->name("auth/google");
        $app->post("/general/auth/google(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\GeneralSettings:authGoogle");
        $app->post("/general/label(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\GeneralSettings:getTableLabels");
        $app->get("/general/label/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\GeneralSettings:getSingleLabel")->name("label/single");
        $app->post("/general/label/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\GeneralSettings:updateLabel");
        $app->post("/general/label/add(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\GeneralSettings:createLabel")->name("label/create");
        $app->post("/general/label/:id/delete(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\GeneralSettings:removeLabel");
        $app->post("/general/label/order(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\GeneralSettings:reorderLabels");
        $app->get("/personal(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\PersonalSettings:get");
        $app->post("/personal(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\PersonalSettings:update");
        $app->get("/general(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\GeneralSettings:get");
        $app->get("/generalWithStatus(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\GeneralSettings:getWithStatus");
        $app->post("/general(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\GeneralSettings:update");
        $app->get("/webforms/:id/details(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\WebForms:getWebFromDetails");
        $app->get("/webforms/:id/html(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\WebForms:getWebFromHtml");
        $app->post("/webforms/table(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\WebForms:getWebFormsList");
        $app->post("/webforms/create(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\WebForms:createWebForm");
        $app->get("/webforms/create/getParams(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\WebForms:getCreateParams");
        $app->post("/webforms/edit(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\WebForms:updateWebForm");
        $app->post("/webforms/delete/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\WebForms:deleteWebForm");
        $app->post("/webforms/contact/create", "mgCRM2\\Controllers\\Api\\Settings\\WebForms:createContact")->name("webforms/add");
        $app->get("/types/table(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesTypes:get")->name("settings/getContactTypes");
        $app->post("/types/update/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesTypes:updateSingleParameter");
        $app->post("/types/reorder(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesTypes:reorder");
        $app->post("/types/new(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesTypes:addType");
        $app->post("/types/delete(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Resources\\ResourcesTypes:delete");
        $app->post("/automations/table(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\Automations:getList");
        $app->post("/automations/create(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\Automations:createAutomation")->name("automations/create");
        $app->post("/automations/update/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\Automations:updateParam");
        $app->post("/automations/delete/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\Automations:deleteAutomation");
        $app->get("/automations/get/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\Automations:getAutomation");
        $app->post("/automations/create/:id/rule(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\Automations:addRule");
        $app->post("/automations/update/:id/rule/:ruleId(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\Automations:editRule");
        $app->post("/automations/update/:id/rulesort(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\Automations:sortRule");
        $app->post("/automations/delete/:id/rule/:ruleId(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\Automations:deleteRule");
        $app->get("/automations/get/:id/ruleGeneralData(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Settings\\Automations:generalData");
    });
    $app->group("/campaigns", function () use($app) {
        $app->get("/filters(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Campaigns\\CampaignsHelpers:getAllColumnsForFilters");
        $app->post("/resources/query(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Campaigns\\CampaignsHelpers:ResourcesTableQueryByFilters");
        $app->get("/resources/query(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Campaigns\\CampaignsHelpers:ResourcesTableQueryByFilters");
        $app->get("/list(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Campaigns\\CampaignsHelpers:getCampaignList")->name("campaigns/getList");
        $app->post("/list(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Campaigns\\CampaignsHelpers:getCampaignList");
        $app->post("/create(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Campaigns\\CampaignsHelpers:createCampaign");
        $app->get("/refresh/:id/filters(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Campaigns\\CampaignsHelpers:refreshCampaignAssignments");
        $app->get("/get/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Campaigns\\CampaignsHelpers:getCampaign");
        $app->post("/update/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Campaigns\\CampaignsHelpers:updateCampaign");
        $app->post("/delete/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Campaigns\\CampaignsHelpers:deleteCampaign");
        $app->get("/filteredCampaign(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Campaigns\\CampaignsHelpers:getFilteredCampaign");
    });
    $app->group("/mailbox", function () use($app) {
        $app->post("/resources/query(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Mailbox\\MailboxHelpers:ResourcesTableQueryByFilters");
        $app->get("/resources/query(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Mailbox\\MailboxHelpers:ResourcesTableQueryByFilters");
        $app->post("/get/params(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Mailbox\\MailboxHelpers:getParams");
        $app->get("/list(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Mailbox\\MailboxHelpers:getMailboxList")->name("mailbox/getList");
        $app->get("/listbyadmin(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Mailbox\\MailboxHelpers:getMailboxListByAdmin")->name("mailbox/getListByAdmin");
        $app->post("/list(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Mailbox\\MailboxHelpers:getMailboxList");
        $app->post("/listbyadmin(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Mailbox\\MailboxHelpers:getMailboxListByAdmin");
        $app->post("/create(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Mailbox\\MailboxHelpers:createMailbox");
        $app->get("/refresh/:id/filters(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Mailbox\\MailboxHelpers:refreshMailboxAssignments");
        $app->get("/get/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Mailbox\\MailboxHelpers:getMailbox");
        $app->post("/update/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Mailbox\\MailboxHelpers:updateMailbox");
        $app->post("/delete/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Mailbox\\MailboxHelpers:deleteMailbox");
        $app->post("/testSend/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Mailbox\\MailboxHelpers:testSend");
    });
    $app->group("/notifications", function () use($app) {
        $app->get("/list(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Notifications\\NotificationsHelpers:getNotificationList");
        $app->post("/list(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Notifications\\NotificationsHelpers:getNotificationList");
        $app->post("/create(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Notifications\\NotificationsHelpers:createNotification");
        $app->get("/mine(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Notifications\\NotificationsHelpers:getMineNotification")->name("notifications/get");
        $app->get("/get/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Notifications\\NotificationsHelpers:getNotification");
        $app->post("/delete/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Notifications\\NotificationsHelpers:deleteNotification");
        $app->post("/update/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Notifications\\NotificationsHelpers:updateNotification");
        $app->post("/accept(/:responseFormat)", "mgCRM2\\Controllers\\Api\\Notifications\\NotificationsHelpers:acceptNotification");
    });
    $app->group("/massmessages", function () use($app) {
        $app->get("/list(/:responseFormat)", "mgCRM2\\Controllers\\Api\\MassMessages\\MassMessagesActions:getForTable");
        $app->post("/list(/:responseFormat)", "mgCRM2\\Controllers\\Api\\MassMessages\\MassMessagesActions:getForTable");
        $app->get("/get/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\MassMessages\\MassMessagesActions:getSingle");
        $app->post("/create(/:responseFormat)", "mgCRM2\\Controllers\\Api\\MassMessages\\MassMessagesActions:addConfig");
        $app->post("/update/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\MassMessages\\MassMessagesActions:updateConfig");
        $app->post("/delete/:id(/:responseFormat)", "mgCRM2\\Controllers\\Api\\MassMessages\\MassMessagesActions:deleteConfig");
    });
    $app->group("/importexport", function () use($app) {
        $app->post("/import/upload(/:responseFormat)", "mgCRM2\\Controllers\\Api\\ImportExport\\Import:uploadFile");
        $app->get("/import/summary(/:responseFormat)", "mgCRM2\\Controllers\\Api\\ImportExport\\Import:getFileSummaryFile");
        $app->post("/import/start(/:responseFormat)", "mgCRM2\\Controllers\\Api\\ImportExport\\Import:importContacts");
        $app->get("/import/start(/:responseFormat)", "mgCRM2\\Controllers\\Api\\ImportExport\\Import:importContacts");
        $app->get("/export/:type", "mgCRM2\\Controllers\\Api\\ImportExport\\Export:exportContacts");
        $app->get("/export/iszip(/:responseFormat)", "mgCRM2\\Controllers\\Api\\ImportExport\\Export:isZip");
    });
});
$app->get("/email/show/:id/table/:table", "mgCRM2\\Controllers\\Home:emailPreview");
$app->get("/test(/:responseFormat)", "mgCRM2\\Controllers\\Home:test");

?>