<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Database;

class PDOWrapper
{
    public static function query($query)
    {
        $statement = \Illuminate\Database\Capsule\Manager::connection()->getPdo()->prepare($query);
        $statement->execute();
        return $statement;
    }
    public static function real_escape_string($string)
    {
        return substr(\Illuminate\Database\Capsule\Manager::connection()->getPdo()->quote($string), 1, -1);
    }
    public static function fetch_assoc($query)
    {
        return $query->fetch(\PDO::FETCH_ASSOC);
    }
    public static function fetch_array($query)
    {
        return $query->fetch(\PDO::FETCH_BOTH);
    }
    public static function fetch_object($query)
    {
        return $query->fetch(\PDO::FETCH_OBJ);
    }
    public static function num_rows($query)
    {
        $query->fetch(\PDO::FETCH_BOTH);
        return $query->rowCount();
    }
    public static function insert_id()
    {
        return \Illuminate\Database\Capsule\Manager::connection()->getPdo()->lastInsertId();
    }
}

?>