<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgcrm2;

define("CRM_APP_PATH", __DIR__ . DS);
define("DOMPDF_ENABLE_AUTOLOAD", false);
$mainConfig = (require_once CRM_APP_PATH . "Config" . "/app.php");
$navigation = (require_once CRM_APP_PATH . "Config" . "/navigation.php");
$permissions = (require_once CRM_APP_PATH . "Config" . "/permissions.php");
$config = array_merge($mainConfig, $navigation, $permissions);
$appConfig = new \Illuminate\Config\Repository($config);
set_error_handler(function ($errno, $errstr, $errfile, $errline, array $errcontext) {
    if(0 === error_reporting()) {
        return false;
    }
    throw new \ErrorException($errstr, 0, $errno, $errfile, $errline);
});
try {
    $logpath = CRM_APP_PATH . "Storage/logs";
    $logfile = $logpath . "/" . @date("Y-m-d") . ".log";
    $old = umask(0);
    if(!is_dir($logpath)) {
        mkdir($logpath, 493, true);
    }
    if(!is_writable($logpath)) {
        @chmod($logpath, 493);
    }
    if(!file_exists($logfile)) {
        file_put_contents($logfile, "");
    }
    umask($old);
    unset($old);
    $logWriter = new Integration\Slim\CustomLogWriter(fopen($logfile, "a"));
} catch (\ErrorException $ex) {
    $error = urlencode($e->getMessage());
    header("Location: addonmodules.php?module=mgCRM2&error=" . $error);
    exit;
}
restore_error_handler();
error_reporting(0);
ini_set("display_errors", 0);
if($CRON === true) {
    $debugMode = false;
} else {
    $debugMode = $appConfig->get("app.debug", false);
}
$file = CRM_APP_PATH . "../moduleVersion.php";
if(file_exists($file)) {
    include $file;
}
if(!isset($renderStandalone)) {
    $renderStandalone = NULL;
}
$app = new Integration\Slim\SlimApp(["debug" => $debugMode === true ? true : false, "mode" => in_array($appConfig->get("app.mode"), ["development", "production"]) ? $appConfig->get("app.mode") : ($appConfig->get("app.debug", false) ? "development" : "production"), "appFilename" => $appFilename, "appAdminDir" => substr($_SERVER["REQUEST_URI"], 0, strpos($_SERVER["REQUEST_URI"], $appFilename)), "appAdminDirName" => basename(substr($_SERVER["REQUEST_URI"], 0, strpos($_SERVER["REQUEST_URI"], $appFilename))), "appAdminUrl" => substr($_SERVER["REQUEST_URI"], 0, strpos($_SERVER["REQUEST_URI"], $appFilename)) . $appFilename, "appDir" => substr($_SERVER["REQUEST_URI"], 0, strpos($_SERVER["REQUEST_URI"], basename(substr($_SERVER["REQUEST_URI"], 0, strpos($_SERVER["REQUEST_URI"], $appFilename))) . "/" . $appFilename)) . "modules/addons/" . basename(dirname(__DIR__)) . "/", "whmcsDir" => substr($_SERVER["REQUEST_URI"], 0, strpos($_SERVER["REQUEST_URI"], strpos($_SERVER["REQUEST_URI"], basename(substr($_SERVER["REQUEST_URI"], 0, strpos($_SERVER["REQUEST_URI"], $appFilename))) ? basename(substr($_SERVER["REQUEST_URI"], 0, strpos($_SERVER["REQUEST_URI"], $appFilename))) : "/"))), "storage.path" => CRM_APP_PATH . "Storage", "storage.files" => "files", "appInternalFile" => __FILE__, "appInternalAppDir" => dirname(__FILE__) . "/", "appInternalModuleDir" => dirname(dirname(__FILE__)) . "/", "log.level" => $appConfig->get("app.log.level", \Slim\Log::ERROR), "log.enabled" => $appConfig->get("app.log.enabled", true), "log.writer" => $logWriter, "skipWHMCS" => $SKIP_WHMCS, "view" => new \Slim\Views\Twig(), "templates.path" => dirname(CRM_APP_PATH) . "/templates/" . $appConfig->get("app.templates.template", "ModulesGarden"), "templates.theme" => $appConfig->get("app.templates.template", "ModulesGarden"), "templates.renderStandalone" => $appConfig->get("app.templates.renderStandalone", $renderStandalone), "moduleVersion" => isset($moduleVersion) ? $moduleVersion : "2.4.1", "moduleRevision" => isset($moduleRevision) ? $moduleRevision : "master", "moduleWikiUrl" => isset($moduleWikiUrl) ? $moduleWikiUrl : "http://www.docs.modulesgarden.com/CRM_For_WHMCS"]);
if($CRON === true) {
    $argv = $GLOBALS["argv"] ?: [];
    array_shift($GLOBALS["argv"]);
    $pathInfo = "/" . implode("/", $argv);
    $app->environment = \Slim\Environment::mock(["PATH_INFO" => $pathInfo]);
    $app->notFound(function () use($app) {
        $url = $app->environment["PATH_INFO"];
        echo "Error: Cannot route to " . $url;
        $app->stop();
    });
    $app->error(function (\Exception $e) {
        echo $e;
        $app->stop();
    });
}
unset($debugMode);
$app->view->parserOptions = ["debug" => $appConfig->get("app.debug", false), "cache" => CRM_APP_PATH . "Storage/Cache"];
$app->view->getEnvironment()->enableAutoReload();
$app->view->parserExtensions = [new \Slim\Views\TwigExtension()];
$app->view->getInstance()->addExtension(new \Twig_Extension_StringLoader());
$app->view->getInstance()->addFunction(new \Twig_SimpleFunction("debug", function ($key, $type = "print_r") {
    switch ($type) {
        case "print_r":
            print_r($key);
            break;
        case "var_dump":
            var_dump($key);
            break;
        case "r":
            if(function_exists("\\r")) {
                r($key);
            } else {
                print_r($key);
            }
            break;
        default:
            print_r($key);
    }
}));
$app->container->set("configFile", function () {
    return $appConfig;
});
$app->container->set("whmcs", function () {
    return new Integration\WHMCSVersioning\Handler();
});
$collation = "utf8_unicode_ci";
$dBcharset = $app->container->get("whmcs")->getDBcharset();
$isLoadDbJson = false;
$countryFile = ROOTDIR . "/modules/addons/mgCRM2/configDB.json";
if(file_exists($countryFile)) {
    $data = json_decode(file_get_contents($countryFile), true);
    $collation = isset($data["collation"]) ? $data["collation"] : $collation;
    $dBcharset = isset($data["charset"]) ? $data["charset"] : $dBcharset;
    $isLoadDbJson = true;
}
if(!$isLoadDbJson && ($file = fopen(__DIR__ . "/Storage/db/config.csv", "r")) !== false) {
    while (($data = fgetcsv($file, 1000, ",")) !== false) {
        list($collation, $dBcharset) = $data;
    }
    fclose($file);
}
$dbConnectionData = ["driver" => "mysql", "host" => $app->container->get("whmcs")->getDBhost(), "database" => $app->container->get("whmcs")->getDBname(), "username" => $app->container->get("whmcs")->getDBusername(), "password" => $app->container->get("whmcs")->getDBpassword(), "charset" => $dBcharset, "collation" => $collation, "prefix" => ""];
if($port = $app->container->get("whmcs")->getDBport()) {
    $dbConnectionData["port"] = $port;
}
$db = new \Illuminate\Database\Capsule\Manager();
$db->addConnection($dbConnectionData);
$db->setAsGlobal();
try {
    $db->connection()->statement("SET sql_mode = '' ");
} catch (\mysql_xdevapi\Exception $ex) {
    throw new \mysql_xdevapi\Exception($ex->getMessage());
}
$db->bootEloquent();
$app->container->set("db", $db);
if($CRON !== true) {
    $app->container->get("whmcs")->setUpCorrectSession();
    $app->add(new Middleware\TemplateVariables());
    $app->add(new Middleware\ParseResponse());
}
if($CRON !== true) {
    if($appConfig->get("app.debug", false) === true && $appConfig->get("app.debugbar", false) === true) {
        $app->config("debugbar.storage", new \DebugBar\Storage\FileStorage(CRM_APP_PATH . "Storage"));
        $debugbar = new Middleware\DebugBar();
        $pdo = new \DebugBar\DataCollector\PDO\TraceablePDO($app->container->get("db")->getConnection()->getPdo());
        $debugbar->getDebugBar()->addCollector(new \DebugBar\DataCollector\PDO\PDOCollector($pdo));
        $debugbar->getDebugBar()->addCollector(new \DebugBar\DataCollector\ExceptionsCollector());
        $app->add($debugbar);
    }
    $app->container->singleton("currentAdmin", function () use($app) {
        return Models\Whmcs\Admin::where("id", "=", $app->container->get("whmcs")->getAdminID())->first(["id", "roleid", "username", "firstname", "lastname", "email", "signature", "language"]);
    });
}
if($CRON !== true) {
    $app->container->singleton("lang", function () {
        return new Services\Language();
    });
    $app->container->set("acl", Services\ACL::getInstance());
}
if($CRON === true) {
    $app->get("/test(/:sth)", function ($sth) {
        echo "Cron Test OK " . $sth . "\n";
    });
    $app->get("/", "mgCRM2\\Controllers\\" . $CONTROLLER . ":run");
} else {
    require CRM_APP_PATH . "routes.php";
}
if(!(isset($WHMCSAPI_REQUEST) && $WHMCSAPI_REQUEST === true)) {
    $app->run();
}

?>