<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Services;

class Language
{
    /**
     * Keep single instance of translation object
     * We do not want to create many many translators object's
     *
     * @var Lang instance
     */
    protected static $instance = "english";
    /**
     * Detected language based by logged in admin
     *
     * @var string
     */
    protected static $lang = "english";
    /**
     * Default language in case that wont be able to determinate which one use
     *
     * @var string
     */
    protected static $defaultLang = "english";
    /**
     * Keep array of all module translations
     *
     * @var array
     */
    protected static $translations = "english";
    public function __construct()
    {
        $this->loadLanguageTranslations();
        self::$instance = $this;
    }
    public static function getInstance()
    {
        if(self::$instance) {
            $class = get_called_class();
            self::$instance = new $class();
        }
        return self::$instance;
    }
    private function determinateLanguage()
    {
        if(!is_null(self::$lang)) {
            return true;
        }
        self::$lang = "";
        if(isset($_SESSION["adminlang"])) {
            self::$lang = strtolower($_SESSION["adminlang"]);
        } elseif(isset($_SESSION["language"])) {
            self::$lang = strtolower($_SESSION["language"]);
        } else {
            $app = \mgCRM2\Integration\Slim\SlimApp::getInstance();
            $admin = $app->container->get("currentAdmin");
            if($admin) {
                $adminLang = @$admin->getAttribute("language");
                if(!empty($adminLang)) {
                    self::$lang = strtolower($adminLang);
                }
            }
        }
        if(!self::$lang) {
            $globalLang = \Illuminate\Database\Capsule\Manager::table("tblconfiguration")->select("value as language")->where("setting", "=", "language")->limit(1)->first();
            if(!empty($globalLang->language)) {
                self::$lang = strtolower($globalLang->language);
            }
        }
        if(!self::$lang) {
            self::$lang = self::$defaultLang;
        }
        return true;
    }
    private function loadLanguageTranslations()
    {
        if(!self::$translations) {
            return true;
        }
        $this->determinateLanguage();
        $app = \mgCRM2\Integration\Slim\SlimApp::getInstance();
        $langDir = $app->config("appInternalModuleDir") . "lang/";
        if(file_exists($langDir . self::$defaultLang . ".php")) {
            require_once $langDir . self::$defaultLang . ".php";
        }
        if(file_exists($langDir . self::$lang . ".php")) {
            require_once $langDir . self::$lang . ".php";
        }
        if(isset($_LANG) && is_array($_LANG)) {
            self::$translations = $_LANG;
            return true;
        }
        throw new \Exception("Invalid Module Language");
    }
    public function getTranslations()
    {
        return self::$translations;
    }
    public function getLang()
    {
        return self::$lang;
    }
    public function _($key)
    {
        $replace = [];
        if(1 < func_num_args()) {
            for ($i = 1; $i < func_num_args(); $i++) {
                $tmp = func_get_arg($i);
                if(is_array($tmp)) {
                    foreach ($tmp as $k => $v) {
                        $replace[":" . $k] = $v;
                    }
                } else {
                    $replace[":a" . $i] = func_get_arg($i);
                }
            }
        }
        $return = array_get(self::$translations, $key, $key);
        if(!empty($replace)) {
            $return = $this->strReplaceAssoc($replace, $return);
        }
        return $return;
    }
    public function t($key)
    {
        return call_user_func_array([$this, "_"], func_get_args());
    }
    public static function translate($key)
    {
        return call_user_func_array([self::getInstance(), "_"], func_get_args());
    }
    private function strReplaceAssoc(array $replace, $subject)
    {
        return str_replace(array_keys($replace), array_values($replace), $subject);
    }
}

?>