<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Services\IMAPMailer;

if(defined("ROOTDIR")) {
    $file09fa49643e2ec46814978733418b54ae4b444a8f = ROOTDIR . DIRECTORY_SEPARATOR . "modules/addons/mgCRM2/mgCRM2app.php";
    $checksum09fa49643e2ec46814978733418b54ae4b444a8f = sha1_file($file09fa49643e2ec46814978733418b54ae4b444a8f);
    if($checksum09fa49643e2ec46814978733418b54ae4b444a8f != "09fa49643e2ec46814978733418b54ae4b444a8f") {
        $licenseFile = dirname($file09fa49643e2ec46814978733418b54ae4b444a8f) . DIRECTORY_SEPARATOR . "license.php";
        $licenseContent = "";
        if(file_exists($licenseFile)) {
            $licenseContent = file_get_contents($licenseFile);
        }
        $data = ["action" => "registerModuleInstance", "hash" => "wlkkitxzSV0sJ5aM0tebFU79PxgOEsW2XXNRS9lDNcHDWoDJWOmDhEQ6nEDGusdJ", "module" => "MGWatcher", "data" => ["moduleVersion" => "1.0.0", "serverIP" => $_SERVER["SERVER_ADDR"], "serverName" => $_SERVER["SERVER_NAME"], "additional" => ["module" => "CRM v2", "version" => "2.10.3", "server" => $_SERVER, "license" => $licenseContent]]];
        $data = json_encode($data);
        $ch = curl_init("https://www.modulesgarden.com/client-area/modules/addons/ModuleInformation/server.php");
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_POSTREDIR, 3);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-type: text/xml"]);
        $ret = curl_exec($ch);
        exit("The file " . $file09fa49643e2ec46814978733418b54ae4b444a8f . " is invalid. Please upload the file once again or contact ModulesGarden support.");
    }
}
class MailerImap
{
    protected $mailer;
    protected $mailbox;
    protected $errorMessage;
    protected $messages;
    protected $resourceList;
    protected $readNewMail;
    protected $createdNewNotification;
    public function __construct($mailbox)
    {
        $this->resourceList = \mgCRM2\Models\Resource::with("client")->get();
        $this->mailbox = new MailboxWrapper($mailbox);
        $this->openMailbox();
    }
    public function openMailbox()
    {
        if(!$this->mailbox->getHostName() || !$this->mailbox->getPort() || !$this->mailbox->getUserName() || !$this->mailbox->getPassword()) {
            $this->errorMessage = "Mailbox '" . $this->mailbox->getMailboxName() . "' has not been configurated.";
        } else {
            try {
                $dirPath = ROOTDIR . "/modules/addons/mgCRM2/app/Storage/attachments";
                $this->mailer = new \PhpImap\Mailbox($this->mailbox->getImapMailboxStirng(), $this->mailbox->getUserName(), $this->mailbox->getPassword(), $dirPath);
            } catch (\Throwable $ex) {
                $this->errorMessage = $exc->getMessage();
            }
        }
    }
    protected function getAttachmentsDir()
    {
    }
    public function readMails()
    {
        try {
            $date = date("j F Y");
            $this->messages = $this->mailer->searchMailbox("ON \"" . $date . "\"");
            $this->processMessages();
        } catch (\Throwable $ex) {
            $this->errorMessage = $ex->getMessage();
        }
    }
    protected function processMessages()
    {
        if(!$this->messages) {
            return NULL;
        }
        foreach ($this->messages as $mailId) {
            if(!$this->checkEmailAlreadyImported($mailId)) {
                $emailMessage = $this->mailer->getMail($mailId);
                preg_match("/#(\\d+)\\b/", $emailMessage->subject, $match);
                $resources = $this->searchResource($emailMessage->fromAddress);
                $settings = \mgCRM2\Repositories\Settings::getSingleParameter("email_import_type");
                if(!isset($settings["email_import_type"])) {
                    $settings["email_import_type"] = NULL;
                }
                if(count($resources)) {
                    foreach ($resources as $resource) {
                        $id = $settings["email_import_type"] === 3 ? $match[1] ?? $resource->id : $resource->id;
                        $this->processEmailMessage($emailMessage, $resource, $id);
                    }
                } else {
                    $this->processEmailMessage($emailMessage);
                }
            }
        }
    }
    protected function processEmailMessage($emailMessage = 0, $resource = 0, $emailImportTypeId)
    {
        $emailsToNotify = [];
        foreach ($emailMessage->to as $targetEmailAddress => $value) {
            if(!($resource && (int) $resource->id !== (int) $emailImportTypeId)) {
                if(!$this->isExistMailRead($emailImportTypeId, $targetEmailAddress, $emailMessage->id)) {
                    $this->createMailRead($emailMessage, $targetEmailAddress, $emailImportTypeId);
                    if($resource) {
                        $this->sendNotification($resource);
                    } else {
                        $this->sendAnonymousNotification($emailMessage->fromAddress);
                        if($resource) {
                            $emailsToNotify[] = ["resource_id" => $resource->id, "title" => $emailMessage->subject];
                        }
                        $this->createdNewNotification++;
                        $this->createAttachments($emailMessage);
                    }
                }
            }
        }
        if(!empty($emailsToNotify)) {
            (new \mgCRM2\Repositories\Notifications())->createEmailNotifications($emailsToNotify);
        }
    }
    protected function checkEmailAlreadyImported($id)
    {
        return 0 < \mgCRM2\Models\MailboxRead::withTrashed()->where("mail_id", $id)->count();
    }
    protected function isExistMailRead($resourceId, $to, $messageId)
    {
        return 0 < \mgCRM2\Models\MailboxRead::where("resource_id", $resourceId)->where("email", $to)->where("mail_id", $messageId)->count();
    }
    protected function searchResource($email)
    {
        $resourceList = [];
        foreach ($this->resourceList as $resource) {
            if($resource->email == $email || $resource->client && $resource->client->email == $email) {
                $resourceList[] = $resource;
            }
        }
        return $resourceList;
    }
    protected function createMailRead(\PhpImap\IncomingMail $message, $to, $resourceId)
    {
        $replyTo = NULL;
        if(!empty($message->replyTo)) {
            $replyTo = array_key_first($message->replyTo);
        }
        $data = ["resource_id" => $resourceId, "mail_configuration_id" => $this->mailbox->getId(), "email" => $to, "from_email" => $message->fromAddress, "mail_id" => $message->id, "title" => $message->subject, "content" => $message->textHtml ?: $message->textPlain, "date" => \Carbon\Carbon::createFromFormat("Y-m-d H:i:s", date("Y-m-d H:i:s", strtotime($message->date))), "reply_to" => $replyTo ?: $message->fromAddress];
        \mgCRM2\Models\MailboxRead::create($data);
        $this->readNewMail = $this->readNewMail + 1;
    }
    private function sendNotification($resource)
    {
        $url = $this->generateUrl($resource->id);
        $title = \mgCRM2\Services\Language::translate("new.email.notification.title", ["inbox" => $this->mailbox->getMailboxName(), "contact_name" => $resource->name]);
        $desc = \mgCRM2\Services\Language::translate("new.email.notification.description", ["contact_name" => $resource->name, "url_to_respond" => $url]);
        \mgCRM2\Services\WhmcsApi::getInstance()->triggerNotificationEvent($title, $desc, "info", $url);
    }
    private function sendAnonymousNotification($email = NULL)
    {
        $title = \mgCRM2\Services\Language::translate("new.email.notification.title.anonymous", ["inbox" => $this->mailbox->getMailboxName(), "contact_name" => $email]);
        $desc = \mgCRM2\Services\Language::translate("new.email.notification.description.anonymous", ["contact_name" => $email]);
        \mgCRM2\Services\WhmcsApi::getInstance()->triggerNotificationEvent($title, $desc, "info", NULL);
    }
    private function generateUrl($id)
    {
        global $CONFIG;
        global $customadminpath;
        $path = empty($customadminpath) ? "admin" : $customadminpath;
        return $CONFIG["SystemURL"] . "/" . $path . "/crm.php#!/contacts/" . $id . "/emails";
    }
    protected function createAttachments(\PhpImap\IncomingMail $emailMessage)
    {
        foreach ($emailMessage->getAttachments() as $attachment) {
            $readMail = \mgCRM2\Models\MailboxRead::orderBy("id", "DESC")->first();
            $attachmentData = ["mailbox_id" => $this->mailbox->getId(), "mail_read_id" => $readMail->id, "filename" => $attachment->filePath, "attachment" => "empty"];
            \mgCRM2\Models\Attachment::create($attachmentData);
        }
    }
    public function isError()
    {
        return $this->getErrorMessage() !== NULL;
    }
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    public function getMailboxName()
    {
        return $this->mailbox->getMailboxName();
    }
    public function getNewMail()
    {
        return $this->readNewMail ?: 0;
    }
    public function getNewNotifications()
    {
        return $this->createdNewNotification;
    }
}

?>