<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Services;

class ContactSync
{
    protected $whmcsAttributesToCrm = ["firstname" => "name", "lastname" => "lastname", "email" => "email", "country" => "country", "phonenumber" => "phone"];
    protected $crmAttributesToWhmcs = ["name" => "firstname", "lastname" => "lastname", "email" => "email", "country" => "country", "phone" => "phonenumber"];
    protected $whmcsCustomFieldsToGetValueByOptions = ["dropdown"];
    protected $crmCustomFieldsToGetValueByOptions = ["select"];
    public function contactSyncFromWhmcsToCrm($userId)
    {
        if(!$this->canSyncFromWhmcsToCrm($userId)) {
            return NULL;
        }
        $clientData = $this->getClientData($userId, "whmcsId");
        $crmClients = $clientData["crmClients"];
        $whmcsClient = $clientData["whmcsClient"];
        $fieldsMapping = $clientData["fieldsMapping"];
        $customFieldsMapping = $clientData["customFieldsMapping"];
        foreach ($crmClients as $crmClient) {
            $updatedFields = [];
            foreach ($fieldsMapping as $key => $attribute) {
                if($this->isCustomField($attribute)) {
                    $crmCFValue = \mgCRM2\Models\FieldData::where("resource_id", $crmClient["id"])->where("field_id", $attribute)->first();
                    $this->updateCrmCfValue($whmcsClient->{$key}, $crmCFValue, $crmClient["id"], $attribute);
                } else {
                    $crmClientRecord = $crmClient[$fieldsMapping[$this->crmAttributesToWhmcs[$attribute]]];
                    $whmcsClientRecord = $whmcsClient[$this->crmAttributesToWhmcs[$fieldsMapping[$this->crmAttributesToWhmcs[$attribute]]]];
                    if($crmClientRecord !== $whmcsClientRecord) {
                        $updatedFields[$fieldsMapping[$this->crmAttributesToWhmcs[$attribute]]] = $whmcsClientRecord;
                    }
                }
            }
            if($updatedFields) {
                \mgCRM2\Models\Resource::where("id", $crmClient["id"])->update($updatedFields);
            }
        }
        $this->updateCustomFields($customFieldsMapping, $crmClients, $whmcsClient);
    }
    protected function createFieldDataOptionForSelect($fieldData, $fieldId, $optionValue)
    {
        $option = \mgCRM2\Models\FieldOption::where("field_id", $fieldId)->where("value", $optionValue)->first();
        $data = ["field_data_id" => $fieldData->id, "option_id" => $option->id];
        \mgCRM2\Models\FieldDataOption::create($data);
    }
    protected function isValueAvailableInSelect($whmcsValue, $fieldId)
    {
        $crmField = \mgCRM2\Models\Field::find($fieldId);
        if($crmField->type != "select") {
            return true;
        }
        $availableOptions = \mgCRM2\Models\FieldOption::select("value")->where("field_id", $fieldId)->get();
        return in_array($whmcsValue, array_column($availableOptions->toArray(), "value"));
    }
    public function contactSyncFromCrmToWhmcs($crmClient)
    {
        if($this->canSyncFromCrmToWhmcs() && $crmClient["client_id"]) {
            $whmcsClientId = $crmClient["client_id"];
            $clientData = $this->getClientData($whmcsClientId, "crmId");
            $whmcsClient = $clientData["whmcsClient"];
            $fieldsMapping = $clientData["fieldsMapping"];
            $customFieldsMapping = $clientData["customFieldsMapping"];
            $updatedFields = [];
            foreach ($fieldsMapping as $key => $attribute) {
                if($this->isCustomField($attribute)) {
                    $field = \mgCRM2\Models\FieldData::where("resource_id", $crmClient["id"])->where("field_id", $attribute)->first();
                    $this->checkAndSetSelectValue($field);
                    if($whmcsClient->{$key} != $field->data) {
                        $updatedFields[$key] = $field->data;
                    }
                } elseif($this->crmAttributesToWhmcs[$this->whmcsAttributesToCrm[$key]]) {
                    $crmClientRecord = $crmClient[$fieldsMapping[$this->crmAttributesToWhmcs[$attribute]]];
                    $whmcsClientRecord = $whmcsClient[$this->crmAttributesToWhmcs[$fieldsMapping[$this->crmAttributesToWhmcs[$attribute]]]];
                    if($crmClientRecord !== $whmcsClientRecord) {
                        $updatedFields[$this->crmAttributesToWhmcs[$attribute]] = $crmClientRecord;
                    }
                } else {
                    $crmClientRecord = $crmClient[$attribute];
                    $whmcsClientRecord = $whmcsClient[$key];
                    if($crmClientRecord !== $whmcsClientRecord) {
                        $updatedFields[$key] = $crmClientRecord;
                    }
                }
            }
            if($updatedFields) {
                \mgCRM2\Models\Whmcs\Client::where("id", $crmClient["client_id"])->update($updatedFields);
            }
            $this->updateCustomFields($customFieldsMapping, $crmClient, $whmcsClient, true);
        }
    }
    protected function checkAndSetSelectValue($field)
    {
        if($field->field_type != "select") {
            return NULL;
        }
        $selectedOption = \mgCRM2\Models\FieldDataOption::where("field_data_id", $field->id)->first();
        $field->data = $selectedOption->option->value;
    }
    private function updateCustomFields($fields, $contact, $whmcsClient, $crmToWHMCSFlag = false)
    {
        if($crmToWHMCSFlag) {
            $this->updateWHMCSCustomFields($fields, $contact, $whmcsClient);
        } else {
            $this->updateCrmCustomFields($fields, $contact, $whmcsClient);
        }
    }
    private function updateCrmCustomFields($fields, $contacts, $whmcsClient)
    {
        $cfValueRepo = new \mgCRM2\Repositories\Whmcs\CustomFieldsValues();
        $cfCRMRepo = new \mgCRM2\Repositories\FieldDatas();
        foreach ($contacts as $contact) {
            $contactId = $contact["id"];
            $updatedFields = [];
            foreach ($fields as $whmcsFieldId => $crmFieldId) {
                if($this->isCustomField($crmFieldId)) {
                    $whmcsCfValue = $cfValueRepo->getByFieldIdAndRelId($whmcsFieldId, $whmcsClient->id);
                    $cfCRM = $cfCRMRepo->getByResourceAndField($contactId, $crmFieldId);
                    $this->updateCrmCfValue($whmcsCfValue->value, $cfCRM, $contactId, $crmFieldId);
                } else {
                    $crmClientRecord = $contact[$crmFieldId];
                    $whmcsClientRecord = \mgCRM2\Models\Whmcs\CustomFieldsValue::where("fieldid", $whmcsFieldId)->where("relid", $whmcsClient->id)->first()->value;
                    if($crmClientRecord !== $whmcsClientRecord) {
                        $updatedFields[$crmFieldId] = $whmcsClientRecord;
                    }
                }
            }
            if($updatedFields) {
                \mgCRM2\Models\Resource::where("id", $contact["id"])->update($updatedFields);
            }
        }
    }
    private function updateCrmCfValue($whmcsCfValue, $cfCRM, $contactId, $crmFieldId)
    {
        $cfCRMRepo = new \mgCRM2\Repositories\FieldDatas();
        $crmFieldsRepo = new \mgCRM2\Repositories\Fields();
        if(!$cfCRM) {
            $field = $crmFieldsRepo->find($crmFieldId);
            $data = ["resource_id" => $contactId, "field_id" => $crmFieldId, "field_type" => $field->type, "data" => $field->type == "select" ? NULL : $whmcsCfValue];
            $fieldData = $cfCRMRepo->create($data);
            if(in_array($field->type, $this->crmCustomFieldsToGetValueByOptions) && $this->isValueAvailableInSelect($whmcsCfValue, $crmFieldId)) {
                $this->createFieldDataOptionForSelect($fieldData, $crmFieldId, $whmcsCfValue);
            }
        }
        if($cfCRM && $whmcsCfValue != $this->getCrmCfValue($cfCRM) && $this->isValueAvailableInSelect($whmcsCfValue, $crmFieldId)) {
            $cfCRM->data = $whmcsCfValue;
            if(in_array($cfCRM->field_type, $this->crmCustomFieldsToGetValueByOptions)) {
                $fieldOption = \mgCRM2\Models\FieldOption::where("field_id", $crmFieldId)->where("value", $whmcsCfValue)->first();
                $fieldDataOption = \mgCRM2\Models\FieldDataOption::where("field_data_id", $cfCRM->id)->first();
                $fieldDataOption->option_id = $fieldOption->id;
                $fieldDataOption->save();
            } else {
                $cfCRM->save();
            }
        }
    }
    protected function getCrmCfValue($cf)
    {
        if(in_array($cf->field_type, $this->crmCustomFieldsToGetValueByOptions)) {
            $optionId = \mgCRM2\Models\FieldDataOption::where("field_data_id", $cf->id)->first();
            $optionValue = \mgCRM2\Models\FieldOption::find($optionId->option_id);
            return $optionValue->value;
        }
        return $cf->data;
    }
    private function updateWHMCSCustomFields($fields, $contact, $whmcsClient)
    {
        $cfRepo = new \mgCRM2\Repositories\Whmcs\CustomFieldsValues();
        $cfCRMRepo = new \mgCRM2\Repositories\FieldDatas();
        foreach ($fields as $whmcsCfId => $crmCfId) {
            $cf = $cfRepo->getByFieldIdAndRelId($whmcsCfId, $whmcsClient["id"]);
            $this->updateWHMCSCfValue($cf, $this->isCustomField($crmCfId) ? $cfCRMRepo->getByResourceAndField($contact["id"], $crmCfId) : $contact[$crmCfId], $whmcsCfId, $whmcsClient["id"]);
        }
    }
    protected function isAvailableInWHMCSCfOptions($whmcsCf, $value)
    {
        $whmcsCf = \mgCRM2\Models\Whmcs\CustomField::find($whmcsCf);
        $options = explode(",", $whmcsCf->fieldoptions);
        if($whmcsCf->fieldtype != "select") {
            return true;
        }
        return in_array($value, $options);
    }
    private function updateWHMCSCfValue($cf, $cfCRM, $fieldId, $whmcsClientId)
    {
        $cfRepo = new \mgCRM2\Repositories\Whmcs\CustomFieldsValues();
        $crmCfValue = is_object($cfCRM) ? $this->getCrmCfValue($cfCRM) : $cfCRM;
        if(!$cf && $this->isAvailableInWHMCSCfOptions($fieldId, $crmCfValue)) {
            $data = ["fieldid" => $fieldId, "relid" => $whmcsClientId, "value" => $crmCfValue];
            $cfRepo->create($data);
        }
        if($cf && $cf->value !== $crmCfValue && $this->isAvailableInWHMCSCfOptions($fieldId, $crmCfValue)) {
            $cf->value = $crmCfValue;
            $cf->save();
        }
    }
    private function getClientData($userId, $flag)
    {
        $fieldsMappingData = $this->getContactSyncFieldsMapping();
        $staticFields = $fieldsMappingData["static"] ?: [];
        $customFields = $fieldsMappingData["custom"] ?: [];
        $fieldsMapping = array_filter($staticFields);
        $customFieldsMapping = array_filter($customFields);
        if($flag === "whmcsId") {
            $whmcsClient = $this->getWhmcsUser($userId);
            $crmClients = $whmcsClient->crmEntries->toArray();
            return ["fieldsMapping" => $fieldsMapping, "whmcsClient" => $whmcsClient, "crmClients" => $crmClients, "customFieldsMapping" => $customFieldsMapping];
        }
        if($flag === "crmId") {
            $whmcsClient = $this->getWhmcsUser($userId);
            return ["fieldsMapping" => $fieldsMapping, "whmcsClient" => $whmcsClient, "customFieldsMapping" => $customFieldsMapping];
        }
        return [];
    }
    private function canSyncFromWhmcsToCrm($userId)
    {
        $setting = $this->getContactSyncSetting();
        if($setting !== 2 && $setting !== 4) {
            return false;
        }
        $user = $this->getCrmUserByWhmcsId($userId);
        return $user !== NULL;
    }
    private function canSyncFromCrmToWhmcs()
    {
        $setting = $this->getContactSyncSetting();
        return !($setting !== 3 && $setting !== 4);
    }
    private function getContactSyncSetting()
    {
        return (int) \mgCRM2\Models\Setting::where("name", "syncContact")->first()->value;
    }
    private function getCrmUserByWhmcsId(int $userId)
    {
        return \mgCRM2\Models\Resource::where("client_id", $userId)->first();
    }
    private function getCrmUser(int $userId)
    {
        return \mgCRM2\Models\Resource::where("id", $userId)->first();
    }
    private function getWhmcsUserIdByCrmId(int $userId)
    {
        return \mgCRM2\Models\Resource::where("id", $userId)->first()->client_id;
    }
    private function getContactSyncFieldsMapping()
    {
        return \mgCRM2\Models\Setting::where("name", "fields_map")->first()->value;
    }
    private function getWhmcsUser(int $userId)
    {
        return \mgCRM2\Models\Whmcs\Client::find($userId);
    }
    protected function isCustomField($id)
    {
        return is_numeric($id);
    }
}

?>