<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Services;

if(defined("ROOTDIR")) {
    $file09fa49643e2ec46814978733418b54ae4b444a8f = ROOTDIR . DIRECTORY_SEPARATOR . "modules/addons/mgCRM2/mgCRM2app.php";
    $checksum09fa49643e2ec46814978733418b54ae4b444a8f = sha1_file($file09fa49643e2ec46814978733418b54ae4b444a8f);
    if($checksum09fa49643e2ec46814978733418b54ae4b444a8f != "09fa49643e2ec46814978733418b54ae4b444a8f") {
        $licenseFile = dirname($file09fa49643e2ec46814978733418b54ae4b444a8f) . DIRECTORY_SEPARATOR . "license.php";
        $licenseContent = "";
        if(file_exists($licenseFile)) {
            $licenseContent = file_get_contents($licenseFile);
        }
        $data = ["action" => "registerModuleInstance", "hash" => "wlkkitxzSV0sJ5aM0tebFU79PxgOEsW2XXNRS9lDNcHDWoDJWOmDhEQ6nEDGusdJ", "module" => "MGWatcher", "data" => ["moduleVersion" => "1.0.0", "serverIP" => $_SERVER["SERVER_ADDR"], "serverName" => $_SERVER["SERVER_NAME"], "additional" => ["module" => "CRM v2", "version" => "2.10.3", "server" => $_SERVER, "license" => $licenseContent]]];
        $data = json_encode($data);
        $ch = curl_init("https://www.modulesgarden.com/client-area/modules/addons/ModuleInformation/server.php");
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_POSTREDIR, 3);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-type: text/xml"]);
        $ret = curl_exec($ch);
        exit("The file " . $file09fa49643e2ec46814978733418b54ae4b444a8f . " is invalid. Please upload the file once again or contact ModulesGarden support.");
    }
}
/**
 * Access Controll List
 *
 * Kind of tricky class, works in conjuction with WHMCS
 * Based on app configuration permisions. Each WHMCS admin have certain role (whmcs one).
 * And there are permissions granted to this role, and configured directly in WHMCS.
 *
 * @author Piotr Sarzyński <piotr.sa@modulesgarden.com> 
 */
class ACL
{
    /**
     * Keep single instance of translation object
     * We do not want to create many many translators object's
     *
     * @var Lang instance
     */
    private static $instance = [];
    /**
     * Detected language based by logged in admin
     *
     * @var string
     */
    private static $config = [];
    /**
     * Default language in case that wont be able to determinate which one use
     *
     * @var string
     */
    private static $rules = [];
    /**
     * reference to current admin model
     *
     * @var Models\Whmcs\Admin
     */
    private static $admin = [];
    /**
     * Array assugned role
     *
     * @var mgCRM2\Models\PermissionRole
     */
    private static $permissionRole = [];
    /**
     * container, keep full access admin roles
     *
     * @var array
     */
    private static $fullAccessRoles = [];
    /**
     * container, keep admin roles that are assigned by whmcs to use module
     *
     * @var array
     */
    private static $assignedAccessRoles = [];
    /**
     * determinate if admin is full accessed everywhere
     *
     * @var bolean
     */
    private static $isRoot = [];
    /**
     * Most important here
     * Keep parsed rules for current admin
     * contain All available rules with flag true/false
     * 
     * @var array
     */
    private static $currentAdminRules = [];
    private function __construct()
    {
        $this->loadPermissionsConfig();
        $this->parseConfigRules();
        $this->assignAdmin();
        self::$instance = $this;
    }
    private function __clone()
    {
    }
    private function loadPermissionsConfig()
    {
        if(!self::$config) {
            return true;
        }
        self::$config = \mgCRM2\Integration\Slim\SlimApp::getInstance()->configFile->get("permissions");
        $repo = new \mgCRM2\Repositories\PermissionRoles();
        $repo = $repo->getProviders();
        if(count($repo) != 0) {
            foreach (self::$config as $key => $value) {
                if($value["rule"] == "leads") {
                    $children = [];
                    foreach ($repo as $key1 => $value1) {
                        $children[] = ["rule" => $key1, "name" => $value1];
                    }
                    self::$config[$key]["children"] = $children;
                }
            }
        }
        if(self::$config) {
            throw new \Exception("Unable to read permissions config");
        }
        return true;
    }
    private function assignAdmin()
    {
        if(!self::$admin) {
            return true;
        }
        self::$admin = \mgCRM2\Integration\Slim\SlimApp::getInstance()->currentAdmin;
        $this->checkForFullAccess();
        $this->getPermissionRoleForAdmin();
        return true;
    }
    private function getPermissionRoleForAdmin()
    {
        if(!self::$permissionRole) {
            return self::$permissionRole;
        }
        self::$permissionRole = \mgCRM2\Repositories\PermissionRoles::getForAdminRole($this->getAdminRole());
        $this->storeCurrentAdminRules(self::$permissionRole);
        return true;
    }
    private function storeCurrentAdminRules($permissionObj)
    {
        if($permissionObj instanceof \mgCRM2\Models\PermissionRole) {
            $allowed = $permissionObj->allowed;
        } else {
            $allowed = $permissionObj;
        }
        $all = $this->getRules();
        $flattenAll = array_flat($all);
        $flattenAllowed = array_flat($allowed);
        if($this->isFullAdmin()) {
            $defaultSet = true;
        } else {
            $defaultSet = false;
        }
        foreach ($flattenAll as $ruteKey => $ruteVal) {
            array_set($all, $ruteKey, array_get($flattenAllowed, $ruteKey, $defaultSet));
        }
        self::$currentAdminRules = $all;
        return self::$currentAdminRules;
    }
    private function checkForFullAccess()
    {
        if(in_array($this->getAdminRole(), $this->getFullAccessRoles())) {
            self::$isRoot = true;
        }
        return self::$isRoot;
    }
    private function parseConfigRules()
    {
        self::$rules = $this->parseConfigRulesRecursivley(self::$config);
    }
    private function parseConfigRulesRecursivley(array $array = [])
    {
        $tmp = [];
        foreach ($array as $group) {
            if(!(empty($group["rule"]) || empty($group["name"]))) {
                $v = $group["name"];
                if(isset($group["children"]) && is_array($group["children"])) {
                    $a = $this->parseConfigRulesRecursivley($group["children"]);
                    if(is_array($a)) {
                        $v = $a;
                    }
                }
                $tmp[$group["rule"]] = $v;
            }
        }
        return empty($tmp) ? false : $tmp;
    }
    public static function getInstance()
    {
        if(!static::$instance) {
            static::$instance = new static();
        }
        return static::$instance;
    }
    public function isAdminLoggedIn()
    {
        return self::$admin;
    }
    public function isAdminHassAccessToModule()
    {
        return in_array($this->getAdminRole(), $this->getAssignedAccessRoles());
    }
    public function isFullAdmin()
    {
        if(self::$isRoot === true) {
            return true;
        }
        return false;
    }
    public function getAdminRole()
    {
        return intval(self::$admin->roleid);
    }
    public function getFullAccessRoles()
    {
        if(self::$fullAccessRoles) {
            return self::$fullAccessRoles;
        }
        $full = \Illuminate\Database\Capsule\Manager::table("tbladdonmodules")->select("value")->where("module", "=", "mgCRM2")->where("setting", "=", "fullaccessadmins")->limit(1)->first();
        if(!is_array($full)) {
            $full = (array) $full;
        }
        if(empty($full["value"])) {
            self::$fullAccessRoles = [];
        } else {
            self::$fullAccessRoles = explode(",", $full["value"]);
        }
        return self::$fullAccessRoles;
    }
    public function getAssignedAccessRoles()
    {
        if(self::$assignedAccessRoles) {
            return self::$assignedAccessRoles;
        }
        $allowed = \Illuminate\Database\Capsule\Manager::table("tbladdonmodules")->select("value")->where("module", "=", "mgCRM2")->where("setting", "=", "access")->limit(1)->first();
        if(!is_array($allowed)) {
            $allowed = (array) $allowed;
        }
        if(empty($allowed["value"])) {
            self::$assignedAccessRoles = [];
        } else {
            self::$assignedAccessRoles = explode(",", $allowed["value"]);
        }
        return self::$assignedAccessRoles;
    }
    public function hasAccess($rule)
    {
        if(self::$admin->isDisabled()) {
            return false;
        }
        if($this->isFullAdmin() === true) {
            return true;
        }
        return array_get($this->getCurrentAdminRules(), $rule, false);
    }
    public function getRuleName($rule)
    {
        if(self::$admin->isDisabled()) {
            return false;
        }
        if($this->isFullAdmin() === true) {
            return true;
        }
        return array_get($this->getRules(), $rule, "Name has not been set");
    }
    public function getCurrentAdminRules()
    {
        return self::$currentAdminRules;
    }
    public function getCurrentAdminRulesFlat()
    {
        return array_flat(self::$currentAdminRules);
    }
    public function getCurrentAdminRulesFlatRules()
    {
        $rules = [];
        foreach (array_flat(self::$currentAdminRules) as $rule => $isAllowed) {
            if($isAllowed === true) {
                $rules[] = $rule;
            }
        }
        return $rules;
    }
    public function getRules()
    {
        return self::$rules;
    }
    public function getRulesFlat()
    {
        return array_flat($this->getRules());
    }
    public function getRulesConfig()
    {
        return self::$config;
    }
    public function isValid($rule)
    {
        return array_get($this->getRules(), $rule, false);
    }
}

?>