<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Description of WhmcsCalendar
 *
 * @author inbs
 */
class WhmcsCalendar extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\Whmcs\\Calendar";
    }
    public function create(array $data = [])
    {
        $url = array_get($data, "url_followup", "");
        $parsed = ["title" => "CRM - " . array_get($data, "titleName", NULL), "desc" => array_get($data, "description", NULL) . " -( " . $url . " )", "start" => strtotime(array_get($data, "date", "0000-00-00 00:00:00")), "end" => 0, "allday" => 1, "adminid" => array_get($data, "admin_id", 0), "recurid" => 0];
        $new = new \mgCRM2\Models\Whmcs\Calendar($parsed);
        $new->save();
        return $new;
    }
    public function update($id, array $data = [])
    {
        $url = array_get($data, "url_followup", "");
        $parsed = ["desc" => array_get($data, "description", NULL) . " -( " . $url . " )", "start" => strtotime(array_get($data, "date", "0000-00-00 00:00:00")), "adminid" => array_get($data, "admin_id", 0)];
        $calendar = $this->getModel()->findOrFail($id);
        if($calendar) {
            $calendar->fill($parsed);
            if(!$calendar->save()) {
                throw new \Exception("Something went wrong");
            }
        } else {
            $parsed["id"] = $id;
            $calendar = $this->create($parsed);
        }
        return $calendar;
    }
    public function delete($id)
    {
        $calendar = $this->getModel()->whereId($id)->first();
        if($calendar) {
            $calendar->delete();
        }
    }
}

?>