<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

class WebFormsContents extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\WebFormContent";
    }
    public function createAndAssigneToWebForm($webform_id, array $data = [], $order = 0)
    {
        $data["field_id"] = $data["id"];
        $data["order"] = $order;
        unset($data["id"]);
        $content = $this->getModel();
        $content->fillDetails($data);
        $content->fillWebFormId($webform_id);
        $content->save();
    }
    public function deleteWebformFields($webform_id)
    {
        $content = $this->getModel();
        $content->where("webform_id", "=", $webform_id)->delete();
    }
    public function getContent($webform_id)
    {
        $content = $this->getModel();
        $fields = $content->newQuery()->select("crm_webforms_contents.webform_id", "crm_webforms_contents.field_id", "crm_webforms_contents.custom_name", "crm_webforms_contents.order", "crm_fields.description")->leftJoin("crm_fields", function ($join) {
            $join->on("crm_fields.id", "LIKE", "crm_webforms_contents.field_id");
        })->where("webform_id", "=", $webform_id)->orderBy("order")->get()->toArray();
        $data = [];
        foreach ($fields as $field) {
            if($this->checkIsStaticWebFormField($field)) {
                $webFormField = \mgCRM2\WebFormFields\WebFormFieldFactory::createFieldByName($field["custom_name"]);
                if($webFormField) {
                    $webFormField->fillData($field);
                    $data[] = $webFormField->getFieldArrayData();
                }
            } else {
                $data[] = $field;
            }
        }
        return $data;
    }
    private function checkIsStaticWebFormField($field)
    {
        return substr($field["field_id"], 0, 1) == "R";
    }
}

?>