<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Just container for Settings
 * as repository pattern
 */
class Settings extends Source\AbstractRepository implements Source\RepositoryInterface
{
    /**
     * Basically set default values for general settings
     *
     * @var type 
     */
    protected static $generalDefaults;
    public function determinateModel()
    {
        return "mgCRM2\\Models\\Setting";
    }
    public function getAdminPersonalizedSettings($adminID)
    {
        if(!is_numeric($adminID)) {
            throw new Exception("Invalid Admin ID");
        }
        return $this->getModel()->forAdmin($adminID)->pluck("value", "name");
    }
    public function updateManuForAdmin($adminID, $data)
    {
        if(empty($data)) {
            throw new Exception("Nothing to update");
        }
        if(!is_numeric($adminID)) {
            throw new Exception("Invalid Admin ID");
        }
        foreach ($data as $settingName => $settingValue) {
            $model = \mgCRM2\Models\Setting::where("name", "=", $settingName)->forAdmin($adminID)->first();
            if(is_null($model)) {
                $model = new \mgCRM2\Models\Setting(["name" => $settingName, "admin_id" => intval($adminID)]);
            }
            $model->value = $settingValue;
            $model->save();
        }
        return true;
    }
    public function getGlobal()
    {
        $globals = $this->getModel()->forGlobal()->pluck("value", "name");
        unset($globals["fields_map"]);
        foreach ($globals as $k => $v) {
            if($k !== "followups_create_lead_followup_type") {
                if($v === 1) {
                    $globals[$k] = true;
                } elseif($v === 0) {
                    $globals[$k] = false;
                }
            }
        }
        return $globals;
    }
    public static function getGlobalsForTwig()
    {
        $globals = \mgCRM2\Models\Setting::forGlobal()->pluck("value", "name");
        $globalsArray = [];
        unset($globals["fields_map"]);
        foreach ($globals as $k => $v) {
            if($v === 1) {
                $globals[$k] = true;
            } elseif($v === 0) {
                $globals[$k] = false;
            }
            $globalsArray[$k] = $globals[$k];
        }
        foreach (self::$generalDefaults as $key => $default) {
            if(array_key_exists($key, $globalsArray) === false) {
                array_set($globals, $key, $default);
            }
        }
        return $globals;
    }
    public static function getSingleParameter($what)
    {
        return \mgCRM2\Models\Setting::forGlobal()->whereSetting($what)->pluck("value", "name");
    }
    public function updateGlobals($data)
    {
        if(empty($data)) {
            throw new Exception("Nothing to update");
        }
        foreach ($data as $settingName => $settingValue) {
            $model = \mgCRM2\Models\Setting::where("name", "=", $settingName)->forGlobal()->first();
            if(is_null($model)) {
                $model = new \mgCRM2\Models\Setting(["name" => $settingName, "admin_id" => 0]);
            }
            $model->value = $settingValue;
            $model->save();
        }
        return true;
    }
}

?>