<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Repository pattern for Resource
 * Wrap certain actions for collection of our model or perform more complexed actions on model
 */
class Resources extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\Resource";
    }
    public function changeDateFollowups($formData)
    {
        $ids = array_get($formData, "ids", []);
        $withData = array_get($formData, "withData", time());
        $toData = $withData + 86400 - 1;
        $date = array_get($formData, "date", date("Y-m-d"));
        foreach ($this->getModel()->whereIn("id", $ids)->get() as $model) {
            $followups = \mgCRM2\Models\Followup::where("resource_id", "LIKE", $model->id)->where(\Illuminate\Database\Capsule\Manager::raw("UNIX_TIMESTAMP(`crm_followups`.`date`)"), ">=", $withData)->where(\Illuminate\Database\Capsule\Manager::raw("UNIX_TIMESTAMP(`crm_followups`.`date`)"), "<=", $toData)->get();
            if($followups) {
                foreach ($followups as $followup) {
                    $followup = $followup->update(["date" => $date]);
                    $synchronizationCalendar = new CalendarSynchronization();
                    if($synchronizationCalendar->isSynchonization()) {
                        $synchronizationCalendar->updateSynchronization($followup->toArray());
                    }
                    $model->addLog("follow_up_update_date", ["withData" => date("Y-m-d"), "newDate" => $date, "followUpId" => $followup->id]);
                }
            }
        }
        return true;
    }
    public function getUsedEmailsList() : array
    {
        $emails = [];
        $emailsRows = $this->getModel()->select("email")->get()->toArray();
        foreach ($emailsRows as $emailsRow) {
            $emails[] = $emailsRow["email"];
        }
        return $emails;
    }
    public function rescheduleReminders($formData)
    {
        $ids = array_get($formData, "ids", []);
        $withData = array_get($formData, "withData", time());
        $toData = $withData + 86400 - 1;
        $date = array_get($formData, "date", date("Y-m-d"));
        foreach ($this->getModel()->whereIn("id", $ids)->get() as $model) {
            \mgCRM2\Models\Reminder::where("crm_followup_reminders.target_id", "LIKE", $model->id)->where("crm_followup_reminders.status", "LIKE", "pending")->where("crm_followup_reminders.target", "LIKE", "resource")->where(\Illuminate\Database\Capsule\Manager::raw("UNIX_TIMESTAMP(`crm_followup_reminders`.`date`)"), ">=", $withData)->where(\Illuminate\Database\Capsule\Manager::raw("UNIX_TIMESTAMP(`crm_followup_reminders`.`date`)"), "<=", $toData)->update(["date" => $date]);
            $model->addLog("reminders_up_update_date", ["withData" => date("Y-m-d"), "newDate" => $date]);
        }
        return true;
    }
    public function rescheduleOnAdminReminders($formData)
    {
        $ids = array_get($formData, "ids", []);
        $withData = array_get($formData, "withData", time());
        $toData = $withData + 86400 - 1;
        $date = array_get($formData, "date", date("Y-m-d H:i:s"));
        $admin = array_get($formData, "withAdmin", []);
        foreach ($this->getModel()->whereIn("id", $ids)->get() as $model) {
            \mgCRM2\Models\Reminder::where("crm_followup_reminders.target_id", "LIKE", $admin["id"])->leftJoin("crm_followups", function ($join) {
                $join->on("crm_followup_reminders.followup_id", "LIKE", "crm_followups.id");
            })->where("crm_followup_reminders.status", "LIKE", "pending")->where("crm_followup_reminders.target", "LIKE", "admin")->where("crm_followups.resource_id", "LIKE", $model->id)->where(function ($query) {
                $query->getModel()->timestamps = false;
            })->where(\Illuminate\Database\Capsule\Manager::raw("UNIX_TIMESTAMP(`crm_followup_reminders`.`date`)"), ">=", $withData)->where(\Illuminate\Database\Capsule\Manager::raw("UNIX_TIMESTAMP(`crm_followup_reminders`.`date`)"), "<=", $toData)->update(["crm_followup_reminders.date" => $date, "crm_followup_reminders.updated_at" => date("Y-m-d H:i:s")], ["timestamps" => false]);
            $model->addLog("reminders_up_update_date", ["withData" => date("Y-m-d"), "newDate" => $date]);
        }
        return true;
    }
    public function chagePiority($formData)
    {
        $id = array_get($formData, "id", false);
        $ids = array_get($formData, "resourceIds", []);
        foreach ($this->getModel()->whereIn("id", $ids)->get() as $model) {
            $model->update(["priority" => $id]);
            $model->addLog("priority");
        }
        return true;
    }
    public function changeType($formData)
    {
        $id = array_get($formData, "id", false);
        $ids = array_get($formData, "resourceIds", []);
        foreach ($this->getModel()->whereIn("id", $ids)->with("type")->get() as $model) {
            $data = $model->type->toArray();
            $model->update(["type_id" => $id]);
            $model->addLog("type_id", $data);
        }
        return true;
    }
    public function changeStatus($formData)
    {
        $id = array_get($formData, "id", false);
        $ids = array_get($formData, "resourceIds", []);
        foreach ($this->getModel()->whereIn("id", $ids)->get() as $model) {
            $model->update(["status_id" => $id]);
            $model->addLog("status_id");
        }
        return true;
    }
    public function assignAdmin($formData)
    {
        $id = array_get($formData, "id", false);
        $ids = array_get($formData, "resourceIds", []);
        foreach ($this->getModel()->whereIn("id", $ids)->get() as $model) {
            $model->update(["admin_id" => $id]);
            $model->addLog("admin_id");
        }
        return true;
    }
    public function createNewLead($data)
    {
        return $this->createNew($data, false);
    }
    public function createNewPotential($data)
    {
        return $this->createNew($data, true);
    }
    public function createNew(array $data = [], $isPotential = false)
    {
        $static = array_get($data, "static", []);
        $dynamic = array_get($data, "dynamic", []);
        if(array_get($static, "priority", NULL) === NULL) {
            array_set($static, "priority", 1);
        }
        $resource = $this->getModel();
        $resource->fillMainDetails($static);
        if(array_get($data, "assignedStatus.id", NULL) != NULL) {
            $resource->assignStatus(\mgCRM2\Models\FieldStatus::find(array_get($data, "assignedStatus.id")));
        } elseif(array_get($data, "status_id", NULL) != NULL) {
            $resource->assignStatus(\mgCRM2\Models\FieldStatus::find(array_get($data, "status_id")));
        } elseif(array_get($data, "static.status_id", NULL) != NULL) {
            $resource->assignStatus(\mgCRM2\Models\FieldStatus::find(array_get($data, "static.status_id")));
        } else {
            throw new \Exception("Invalid Contact Status");
        }
        if(array_get($data, "assignedType.id", NULL) != NULL) {
            $resource->assignType(\mgCRM2\Models\ResourceType::find(array_get($data, "assignedType.id")));
        } elseif(array_get($data, "type_id", NULL) != NULL) {
            $resource->assignType(\mgCRM2\Models\ResourceType::find(array_get($data, "type_id")));
        } elseif(array_get($data, "static.type_id", NULL) != NULL) {
            $resource->assignType(\mgCRM2\Models\ResourceType::find(array_get($data, "static.type_id")));
        } else {
            throw new \Exception("Invalid Contact Type");
        }
        if(array_get($data, "assignedAdmin.id", NULL) != NULL) {
            $resource->assignAdmin(\mgCRM2\Models\Whmcs\Admin::where("disabled", "0")->find(array_get($data, "assignedAdmin.id")));
        } elseif(array_get($data, "admin_id", NULL) != NULL) {
            $resource->assignAdmin(\mgCRM2\Models\Whmcs\Admin::where("disabled", "0")->find(array_get($data, "admin_id")));
        } elseif(array_get($data, "static.admin_id", NULL) != NULL) {
            $resource->assignAdmin(\mgCRM2\Models\Whmcs\Admin::where("disabled", "0")->find(array_get($data, "static.admin_id")));
        } else {
            $resource->assignAdmin(\mgCRM2\Models\Whmcs\Admin::find(\mgCRM2\Integration\Slim\SlimApp::getInstance()->currentAdmin->id));
        }
        if(array_get($data, "assignedClient.id", NULL) != NULL) {
            $resource->assignClient(\mgCRM2\Models\Whmcs\Client::find(array_get($data, "assignedClient.id")));
        } elseif(array_get($data, "client_id", NULL) != NULL) {
            $resource->assignClient(\mgCRM2\Models\Whmcs\Client::find(array_get($data, "client_id")));
        } elseif(array_get($data, "static.client_id", NULL) != NULL) {
            $resource->assignClient(\mgCRM2\Models\Whmcs\Client::find(array_get($data, "static.client_id")));
        }
        if(array_get($data, "ticket_id", NULL) != NULL) {
            $resource->assignTicket(\mgCRM2\Models\Whmcs\Ticket::find(array_get($data, "ticket_id", NULL)));
        } elseif(array_get($data, "static.ticket_id", NULL) != NULL) {
            $resource->assignTicket(\mgCRM2\Models\Whmcs\Ticket::find(array_get($data, "static.ticket_id", NULL)));
        }
        $requireEmailSetting = Settings::getSingleParameter("require_contact_email");
        if($requireEmailSetting["require_contact_email"] == 1 && empty($resource->email)) {
            throw new \Exception(\mgCRM2\Services\Language::translate("webform.client.required.email"));
        }
        $disableEmailDuplicateSetting = Settings::getSingleParameter("disable_email_duplicate");
        if(!empty($resource->email) && $disableEmailDuplicateSetting["disable_email_duplicate"] == 0 && 0 < \mgCRM2\Models\Resource::where("email", $resource->email)->count()) {
            throw new \Exception(\mgCRM2\Services\Language::translate("webform.client.exist.email"));
        }
        if(!$resource->country) {
            $defaultCountry = \mgCRM2\Models\Whmcs\Configuration::where("setting", "DefaultCountry")->first();
            $resource->country = $defaultCountry->value;
        }
        $saved = $resource->save();
        $resource->addLog("new_contack");
        $fieldsRepository = new Fields();
        $fieldsErrors = $fieldsRepository->createAndAssignToResource($resource, $dynamic);
        foreach (array_get($data, "labels", []) as $number => $label) {
            $modelLabel = new \mgCRM2\Models\ResourceLabel();
            $modelLabel->client_id = $resource->id;
            $modelLabel->label_id = is_array($label) ? $label["id"] : $label;
            $modelLabel->order = $number;
            $modelLabel->save();
        }
        \mgCRM2\Models\MailboxRead::where("resource_id", "LIKE", 0)->where("from_email", "LIKE", $resource->email)->update(["resource_id" => $resource->id]);
        \mgCRM2\Models\EmailLog::whereNull("resource_id")->where("to", "LIKE", "%" . $resource->email . "%")->update(["resource_id" => $resource->id]);
        if(is_array($fieldsErrors) && !empty($fieldsErrors)) {
            \mgCRM2\Integration\Slim\SlimApp::getInstance()->log->error("Resource Create, custom fields errors: {errors}", ["errors" => implode(" \n", $fieldsErrors)]);
        }
        $resource->pushEvent("CreateFollowupOnCreate", array_get($static, "followup", false));
        return $resource;
    }
    public function parseRepositoriesForTable($data, $showHidden = false, $forAPI = false)
    {
        $alc = \mgCRM2\Services\ACL::getInstance();
        $fullAclRole = $alc->getCurrentAdminRules();
        $notMineRule = $fullAclRole["resources"]["not_mine"];
        $alcRules = $alc->getRules();
        $type_name = [];
        foreach ($alcRules["leads"] as $key => $value) {
            if($alc->hasAccess("leads." . $key)) {
                $type_name[] = (string) $key;
            }
        }
        $limit = array_get($data, "params.pagination.number", 10);
        $ofset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", false);
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $search = array_get($data, "params.search.predicateObject", false);
        $searchGlobal = array_pull($search, "\$", false);
        $columns = array_get($data, "columns", []);
        $contactTypeID = array_get($data, "type", false);
        $whereAND = [];
        $whereOR = [];
        $query = \Illuminate\Database\Capsule\Manager::table(\Illuminate\Database\Capsule\Manager::raw("`crm_resources`"))->leftJoin("tbladmins", function ($join) {
            $join->on("crm_resources.admin_id", "=", "tbladmins.id");
        })->leftJoin("tblclients", function ($join) {
            $join->on("crm_resources.client_id", "=", "tblclients.id");
        })->leftJoin("tbltickets", function ($join) {
            $join->on("crm_resources.ticket_id", "=", "tbltickets.id");
        })->leftJoin("crm_resources_statuses", function ($join) {
            $join->on("crm_resources.status_id", "=", "crm_resources_statuses.id");
        })->leftJoin("crm_resources_types", function ($join) {
            $join->on("type_id", "=", "crm_resources_types.id");
        })->leftJoin("crm_labels_clients", function ($join) {
            $join->on("crm_resources.id", "=", "crm_labels_clients.client_id");
        });
        if($showHidden === true) {
            $query = $query->whereNotNull("crm_resources.deleted_at");
        } elseif(\mgCRM2\Models\Validators\Common::isPositiveUnsignedNumber($contactTypeID)) {
            $query = $query->whereNull("crm_resources.deleted_at");
            $query->whereRaw("`crm_resources`.`type_id` = '" . $contactTypeID . "'");
        } else {
            $query = $query->whereNull("crm_resources.deleted_at");
            $query->whereRaw("`crm_resources_types`.`show_in_dashboard` = 1 AND `crm_resources_types`.`active` = 1");
        }
        $select = [];
        $select[] = "crm_resources.id as id";
        $select[] = "crm_resources.deleted_at";
        $select[] = "crm_resources.type_id as type_id";
        $select[] = \Illuminate\Database\Capsule\Manager::raw("REPLACE(LOWER(`crm_resources_types`.`name`),' ','_') as `code`");
        $select[] = "crm_resources.priority as priority";
        $select[] = "crm_resources.status_id as status";
        $availableSelects = ["name" => "crm_resources.name", "lastname" => "crm_resources.lastname", "email" => "crm_resources.email", "phone" => "crm_resources.phone", "country" => "crm_resources.country", "type_id" => "crm_resources.type_id", "code" => \Illuminate\Database\Capsule\Manager::raw("REPLACE(LOWER(crm_resources_types.name),' ','_')"), "short_description" => "crm_resources.short_description", "created_at" => "crm_resources.created_at", "updated_at" => "crm_resources.updated_at", "ticket" => "tbltickets.tid", "admin_id" => "crm_resources.admin_id", "client_id" => "crm_resources.client_id", "status_id" => "crm_resources.status_id", "ticket_id" => "crm_resources.ticket_id", "admin" => "CONCAT_WS(' ', tbladmins.firstname, tbladmins.lastname)", "client" => "CONCAT_WS(' ', tblclients.firstname, tblclients.lastname)", "labels" => "GROUP_CONCAT(DISTINCT crm_labels_clients.label_id ORDER BY crm_labels_clients.label_id SEPARATOR ',')"];
        foreach ($availableSelects as $staticFieldName => $inject) {
            if(in_array($staticFieldName, $columns) || empty($columns) || in_array($staticFieldName, ["admin_id", "ticket_id", "client_id", "status_id"])) {
                $column = sprintf("%s AS %s", $inject, $staticFieldName);
                $select[] = \Illuminate\Database\Capsule\Manager::raw($column);
                $fieldFilter = array_get($search, $staticFieldName, false);
                if(!empty($fieldFilter) || !empty($searchGlobal)) {
                    $operand = $valuePattern = NULL;
                    if(in_array($staticFieldName, ["name", "lastname", "email", "phone", "country", "short_description"])) {
                        $operand = "LIKE";
                        $valuePattern = "%%%s%%";
                    } elseif(in_array($staticFieldName, ["status", "priority", "id", "ticket", "admin_id", "ticket_id", "client_id", "status_id"])) {
                        $operand = "=";
                        $valuePattern = "%s";
                        if($staticFieldName == "priority" && $fieldFilter == 1) {
                            $whereAND[] = [$inject, $operand, \Illuminate\Database\Capsule\Manager::raw("1 OR " . $inject . " is NULL")];
                        }
                    } elseif(in_array($staticFieldName, ["admin", "client", "labels"])) {
                        $operand = "LIKE";
                        $valuePattern = "%%%s%%";
                        $inject = \Illuminate\Database\Capsule\Manager::raw($inject);
                    }
                    if(!empty($fieldFilter) && $operand !== NULL && $valuePattern !== NULL) {
                        $whereAND[] = [$staticFieldName, $operand, sprintf($valuePattern, $fieldFilter)];
                    }
                    if(!empty($searchGlobal) && $operand !== NULL && $valuePattern !== NULL) {
                        $whereOR[] = [$staticFieldName, $operand, sprintf($valuePattern, $searchGlobal)];
                    }
                }
            }
        }
        $campaignID = array_get($data, "campaign");
        if(\mgCRM2\Models\Validators\Common::isPositiveUnsignedNumber($campaignID)) {
            $query = $query->leftJoin("crm_campaigns_resources", function ($join) use($join) {
                $join->on("crm_resources.id", "=", "crm_campaigns_resources.resource_id")->on("crm_campaigns_resources.campaign_id", "=", \Illuminate\Database\Capsule\Manager::raw($campaignID));
            });
            $query = $query->whereRaw("`crm_campaigns_resources`.`campaign_id` = '" . $campaignID . "'");
        } elseif($campaignID === 0) {
            $query = $query->leftJoin("crm_campaigns_resources", function ($join) {
                return $join->on("crm_resources.id", "=", "crm_campaigns_resources.resource_id");
            });
            $query = $query->whereRaw("`crm_campaigns_resources`.`campaign_id` is null");
        }
        $pureSelect = $select;
        $pureQuery = clone $query;
        $miltipleFields = [];
        $fieldsQuery = $this->addFieldsToQuery($query, $columns, $search, $searchGlobal, $miltipleFields);
        $query = $fieldsQuery["query"];
        $select = array_merge($select, $fieldsQuery["select"]);
        $selectFieldsIds = array_keys($fieldsQuery["selectFields"]);
        if(0 < $fieldsQuery["amount"]) {
            $query->from(\Illuminate\Database\Capsule\Manager::raw("`crm_fields_data` left join `crm_fields_data_options` on `crm_fields_data`.`id`=`crm_fields_data_options`.`field_data_id`, `crm_resources`"));
            for ($i = 0; $i < $fieldsQuery["amount"]; $i++) {
                $pureSelect[] = \Illuminate\Database\Capsule\Manager::raw("null as field_" . $selectFieldsIds[$i]);
            }
        }
        if($notMineRule === false && $alc->isFullAdmin() === false) {
            $app = \mgCRM2\Integration\Slim\SlimApp::getInstance();
            $dataCurrentAdmin = $app->currentAdmin->toArray();
            $adminID = $dataCurrentAdmin["id"];
        } else {
            $adminID = array_get($data, "admin");
        }
        $count = clone $query;
        $query->select($select)->groupBy("crm_resources.id");
        $pureQuery->select($pureSelect)->groupBy("crm_resources.id");
        $mainQuery = \Illuminate\Database\Capsule\Manager::table(\Illuminate\Database\Capsule\Manager::raw("(" . $query->union($pureQuery)->toSql() . ") mgcrm_resources"));
        $whereAND = array_merge($whereAND, $fieldsQuery["whereAND"]);
        if(!empty($whereAND)) {
            $mainQuery = $mainQuery->where(function ($query) {
                foreach ($whereAND as $push) {
                    $query->whereRaw($push[0] . " " . $push[1] . " '" . $push[2] . "'");
                }
            });
        }
        $whereOR = array_merge($whereOR, $fieldsQuery["whereOR"]);
        if(!empty($whereOR)) {
            $mainQuery = $mainQuery->where(function ($query) {
                foreach ($whereOR as $push) {
                    $query->orWhereRaw($push[0] . " " . $push[1] . " '" . $push[2] . "'");
                }
            });
        }
        if($forAPI !== true) {
            if(\mgCRM2\Models\Validators\Common::isPositiveUnsignedNumber($adminID) && $adminID !== NULL) {
                $count->where("admin_id", "=", $adminID);
            } elseif($adminID === 0) {
                $count->whereNull("admin_id");
            }
            $total = $count->select(\Illuminate\Database\Capsule\Manager::raw("count(distinct crm_resources.id) as aggregation"))->first()->aggregation;
        }
        $mainQuery->groupBy("mgcrm_resources.id");
        $mainQuery->where("mgcrm_resources.id", "!=", "0");
        if($orderBy !== false) {
            $mainQuery = $mainQuery->orderBy($orderBy, $orderDesc);
        }
        if($orderBy != "priority") {
            $mainQuery = $mainQuery->orderBy(\Illuminate\Database\Capsule\Manager::raw("priority"), "DESC");
        }
        if($orderBy != "status") {
            $mainQuery = $mainQuery->orderBy(\Illuminate\Database\Capsule\Manager::raw("status"), "ASC");
        }
        if($forAPI !== true) {
            $mainQuery = $mainQuery->take($limit)->offset($ofset);
        }
        if(\mgCRM2\Models\Validators\Common::isPositiveUnsignedNumber($adminID) && $adminID !== NULL) {
            $mainQuery->where("admin_id", "=", $adminID);
        } elseif($adminID === 0) {
            $mainQuery->whereNull("admin_id");
        }
        $data = $mainQuery->get();
        foreach ($data as $row => $rowData) {
            foreach ($rowData as $k => $v) {
                if(array_get($miltipleFields, $k, false) !== false) {
                    $ccc = [];
                    foreach (explode(";", $v) as $y) {
                        $ccc[] = array_get($miltipleFields, $k . "." . $y, NULL);
                    }
                    $data[$row]->{$k} = implode(", ", $ccc);
                }
            }
        }
        $removeIds = [];
        foreach ($data as $key => $value) {
            if(!$alc->hasAccess("leads." . $value->code)) {
                $removeIds[] = $key;
            }
        }
        foreach ($removeIds as $key) {
            unset($data[$key]);
        }
        if($forAPI === true) {
            return $data;
        }
        foreach ($data as &$resource) {
            $resource->name = html_entity_decode($resource->name, ENT_QUOTES);
            $resource->lastname = html_entity_decode($resource->lastname, ENT_QUOTES);
            $resource->email = html_entity_decode($resource->email, ENT_QUOTES);
            $resource->client = html_entity_decode($resource->client, ENT_QUOTES);
        }
        $return = ["data" => $data, "total" => $total - count($removeIds)];
        return $return;
    }
    private function addFieldsToQuery($query, $columns, $search, $searchGlobal, &$miltipleFields)
    {
        $whereAND = [];
        $whereOR = [];
        $fields = \mgCRM2\Models\Field::joinOptions()->get();
        $selectFields = [];
        foreach ($fields as $fieldId => $field) {
            if(in_array("field_" . $field->id, $columns) || empty($columns)) {
                if($field->isMultiple()) {
                    $options = $field->options->toArray();
                    $parsed = [];
                    if(!empty($options)) {
                        array_map(function ($a) use($a) {
                            $parsed[$a["id"]] = $a["value"];
                            return true;
                        }, $options);
                    }
                    $miltipleFields["field_" . $field->id] = $parsed;
                }
                if($field->isMultiple()) {
                    $selectFields[$field->id] = sprintf("GROUP_CONCAT( DISTINCT CASE WHEN crm_fields_data.field_id = %s THEN crm_fields_data_options.option_id ELSE NULL END ORDER BY crm_fields_data_options.id ASC SEPARATOR ';') AS field_%s", $field->id, $field->id);
                } else {
                    $selectFields[$field->id] = sprintf("MAX(CASE WHEN crm_fields_data.field_id = %s THEN crm_fields_data.data ELSE NULL END) AS field_%s", $field->id, $field->id);
                }
                $fieldFilter = array_get($search, "field_" . $field->id, false);
                if(!empty($fieldFilter) || !empty($searchGlobal)) {
                    $inject = $operand = $valuePattern = NULL;
                    if($field->isMultiple()) {
                        $operand = "=";
                        $valuePattern = "%s";
                        $inject = \Illuminate\Database\Capsule\Manager::raw("field_" . $field->id);
                    } else {
                        $operand = "LIKE";
                        $valuePattern = "%%%s%%";
                        $inject = \Illuminate\Database\Capsule\Manager::raw("field_" . $field->id);
                    }
                    if(!empty($fieldFilter) && $operand !== NULL && $valuePattern !== NULL && $inject !== NULL) {
                        $whereAND[] = [$inject, $operand, sprintf($valuePattern, $fieldFilter), $field->isMultiple()];
                    }
                    if(!empty($searchGlobal) && $operand !== NULL && $valuePattern !== NULL && $inject !== NULL) {
                        $whereOR[] = [$inject, $operand, sprintf($valuePattern, $searchGlobal), $field->isMultiple()];
                    }
                }
            }
        }
        $select = [];
        if(!empty($selectFields)) {
            $selectFieldsQuery = implode(", \n", $selectFields);
            $select[] = \Illuminate\Database\Capsule\Manager::raw($selectFieldsQuery);
            $query = $query->where("crm_fields_data.resource_id", "=", \Illuminate\Database\Capsule\Manager::raw("`crm_resources`.`id`"));
        }
        return ["query" => $query, "select" => $select, "amount" => count($selectFields), "whereAND" => $whereAND, "whereOR" => $whereOR, "selectFields" => $selectFields];
    }
    public function getLabelsForId($id)
    {
        return $this->getModel()->with("labels")->find($id);
    }
}

?>