<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Just container for WHMCS Quotes that are assigned to Resources
 * as repository pattern
 */
class ResourceTickets extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\Whmcs\\Ticket";
    }
    public function parseForTable($resourceID, array $data = [])
    {
        $id = (int) $resourceID;
        $limit = array_get($data, "params.pagination.number", 10);
        $ofset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", "tid");
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $search = array_get($data, "params.search.predicateObject", false);
        $searchGlobal = array_pull($search, "\$", false);
        $searchColumn = ["id" => array_get($data, "params.search.predicateObject.id", false), "tid" => array_get($data, "params.search.predicateObject.tid", false), "title" => array_get($data, "params.search.predicateObject.title", false), "status" => array_get($data, "params.search.predicateObject.status", false), "date" => array_get($data, "params.search.predicateObject.date", false), "lastreply" => array_get($data, "params.search.predicateObject.lastreply", false)];
        $query = \Illuminate\Database\Capsule\Manager::table("tbltickets")->select(["tbltickets.*"])->whereColumn("tbltickets.userid", "=", "crm_resources.client_id")->leftJoinWhere("crm_resources", "crm_resources.id", "=", (string) $id);
        if(!empty($searchGlobal) && $searchGlobal !== false) {
            $query = $query->where("tbltickets.title", "LIKE", "%" . $searchGlobal . "%");
        }
        foreach ($searchColumn as $column => $val) {
            if(!empty($val) && $val !== false) {
                $query = $query->where("tbltickets." . $column, "LIKE", "%" . $val . "%");
            }
        }
        $total = $query->count();
        $results = $query->orderBy("tbltickets." . $orderBy, $orderDesc)->take($limit)->offset($ofset)->get();
        $return = ["data" => $results, "total" => $total];
        return $return;
    }
    public function sync($resourceID)
    {
        $contact = \mgCRM2\Models\Resource::withClient()->findOrFail($resourceID);
        if(!$contact->client->id) {
            return 0;
        }
        $clientQuotes = \mgCRM2\Models\Whmcs\Quote::whereClientID($contact->client->id)->get();
        $clientQuotes = $clientQuotes->each(function ($item) use($item) {
            $item->assignToContact($resourceID);
        });
        return $clientQuotes->count();
    }
    public function removeRelationForContactAndQuotes($resourceID)
    {
        $quotesRelations = \mgCRM2\Models\ResourceQuote::forResource($resourceID)->withQuote()->get();
        $quotesRelations = $quotesRelations->each(function ($item) {
            if($item->quote->hasClient()) {
                $item->delete();
            }
        });
        return true;
    }
}

?>