<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

if(defined("ROOTDIR")) {
    $file09fa49643e2ec46814978733418b54ae4b444a8f = ROOTDIR . DIRECTORY_SEPARATOR . "modules/addons/mgCRM2/mgCRM2app.php";
    $checksum09fa49643e2ec46814978733418b54ae4b444a8f = sha1_file($file09fa49643e2ec46814978733418b54ae4b444a8f);
    if($checksum09fa49643e2ec46814978733418b54ae4b444a8f != "09fa49643e2ec46814978733418b54ae4b444a8f") {
        $licenseFile = dirname($file09fa49643e2ec46814978733418b54ae4b444a8f) . DIRECTORY_SEPARATOR . "license.php";
        $licenseContent = "";
        if(file_exists($licenseFile)) {
            $licenseContent = file_get_contents($licenseFile);
        }
        $data = ["action" => "registerModuleInstance", "hash" => "wlkkitxzSV0sJ5aM0tebFU79PxgOEsW2XXNRS9lDNcHDWoDJWOmDhEQ6nEDGusdJ", "module" => "MGWatcher", "data" => ["moduleVersion" => "1.0.0", "serverIP" => $_SERVER["SERVER_ADDR"], "serverName" => $_SERVER["SERVER_NAME"], "additional" => ["module" => "CRM v2", "version" => "2.10.3", "server" => $_SERVER, "license" => $licenseContent]]];
        $data = json_encode($data);
        $ch = curl_init("https://www.modulesgarden.com/client-area/modules/addons/ModuleInformation/server.php");
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_POSTREDIR, 3);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-type: text/xml"]);
        $ret = curl_exec($ch);
        exit("The file " . $file09fa49643e2ec46814978733418b54ae4b444a8f . " is invalid. Please upload the file once again or contact ModulesGarden support.");
    }
}
/**
 * Just container for WHMCS Quotes that are assigned to Resources
 * as repository pattern
 */
class ResourceQuotes extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\ResourceQuote";
    }
    public function parseForTable($resourceID, array $data = [])
    {
        $limit = array_get($data, "params.pagination.number", 10);
        $ofset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", "datecreated");
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $search = array_get($data, "params.search.predicateObject", false);
        $searchGlobal = array_pull($search, "\$", false);
        $searchColumn = ["id" => array_get($data, "params.search.predicateObject.id", false), "stage" => array_get($data, "params.search.predicateObject.stage", false), "subject" => array_get($data, "params.search.predicateObject.subject", false), "lastmodified" => array_get($data, "params.search.predicateObject.lastmodified", false), "datesent" => array_get($data, "params.search.predicateObject.datesent", false), "idateacceptedd" => array_get($data, "params.search.predicateObject.dateaccepted", false), "total" => array_get($data, "params.search.predicateObject.total", false)];
        $query = \Illuminate\Database\Capsule\Manager::table("crm_resources_quotes")->where("crm_resources_quotes.resource_id", "=", $resourceID)->leftJoin("tblquotes", function ($join) {
            $join->on("crm_resources_quotes.quote_id", "=", "tblquotes.id");
        });
        if(!empty($searchGlobal) && $searchGlobal !== false) {
            $query = $query->where("tblquotes.subject", "LIKE", "%" . $searchGlobal . "%");
        }
        foreach ($searchColumn as $column => $val) {
            if(!empty($val) && $val !== false) {
                $query = $query->where("tblquotes." . $column, "LIKE", "%" . $val . "%");
            }
        }
        $total = $query->count();
        $results = $query->orderBy("tblquotes." . $orderBy, $orderDesc)->take($limit)->offset($ofset)->get();
        include_whmcs();
        foreach ($results as &$quote) {
            $quote->total = formatCurrency($quote->total, $quote->currency)->toFull();
        }
        $return = ["data" => $results, "total" => $total];
        return $return;
    }
    public function sync($resourceID)
    {
        $contact = \mgCRM2\Models\Resource::withClient()->findOrFail($resourceID);
        if(!$contact->client->id) {
            return 0;
        }
        $clientQuotes = \mgCRM2\Models\Whmcs\Quote::whereClientID($contact->client->id)->get();
        $clientQuotes = $clientQuotes->each(function ($item) use($item) {
            $item->assignToContact($resourceID);
        });
        return $clientQuotes->count();
    }
    public function removeRelationForContactAndQuotes($resourceID)
    {
        $quotesRelations = \mgCRM2\Models\ResourceQuote::forResource($resourceID)->withQuote()->get();
        $quotesRelations = $quotesRelations->each(function ($item) {
            if($item->quote->hasClient()) {
                $item->delete();
            }
        });
        return true;
    }
}

?>