<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Repository pattern for Notifications
 * Wrap certain actions for collection of our model or perform more complexed actions on model
 */
class PermissionRoles extends Source\AbstractRepository implements Source\RepositoryInterface
{
    protected static $generalDefaultsProviderLabel = [];
    protected static $generalDefaultsProvider = [];
    public function determinateModel()
    {
        return "mgCRM2\\Models\\PermissionRole";
    }
    public function getProviders()
    {
        self::loadDefaultProviders();
        return self::$generalDefaultsProviderLabel;
    }
    protected static function loadDefaultProviders()
    {
        if(count(self::$generalDefaultsProvider) != 0) {
            return NULL;
        }
        $query = \Illuminate\Database\Capsule\Manager::table("crm_resources_types")->select([\Illuminate\Database\Capsule\Manager::raw("`crm_resources_types`.`name` AS 'name'"), \Illuminate\Database\Capsule\Manager::raw("REPLACE(LOWER(`crm_resources_types`.`name`),' ','_') AS 'code'")]);
        $data = $query->whereNull("crm_resources_types.deleted_at")->get();
        foreach ($data as $provider) {
            if(is_array($provider)) {
                array_set(self::$generalDefaultsProvider, $provider["code"], false);
                array_set(self::$generalDefaultsProviderLabel, $provider["code"], $provider["name"]);
            } else {
                array_set(self::$generalDefaultsProvider, $provider->code, false);
                array_set(self::$generalDefaultsProviderLabel, $provider->code, $provider->name);
            }
        }
    }
    public function updateSingleParamInModel($id, $data)
    {
        $model = $this->find($id);
        if(!$model) {
            throw new Exception("Couldnt find role with id " . $id);
        }
        if(!$model->updateSingleParam($data)) {
            throw new Exception("Something went wrong");
        }
        return $model;
    }
    public static function getForAdminRole($roleID)
    {
        $possible = \mgCRM2\Models\PermissionRole::where("admin_groups", "like", "%" . $roleID . "%")->get();
        foreach ($possible as $p) {
            if(in_array($roleID, $p->admin_groups)) {
                return $p;
            }
        }
        return [];
    }
}

?>