<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Repository pattern for Notifications
 * Wrap certain actions for collection of our model or perform more complexed actions on model
 */
class Notifications extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\Notification";
    }
    public function createNotification(array $data = [])
    {
        $parsed = ["class" => array_get($data, "class", ""), "type" => array_get($data, "type", ""), "content" => array_get($data, "content", ""), "date_start" => array_get($data, "date_start", ""), "date_end" => array_get($data, "date_end", ""), "confirmation" => array_get($data, "confirmation", false) === true, "hide_after_confirm" => array_get($data, "hide_after_confirm", false) === true];
        $new = new \mgCRM2\Models\Notification($parsed);
        $new->save();
        $adminsIDs = array_get($data, "admins", []);
        if(!empty($adminsIDs)) {
            $new->admins()->attach($adminsIDs);
        }
        return $new;
    }
    public function createEmailNotifications(array $clientsEmailsToNotify)
    {
        $globals = (new \mgCRM2\Controllers\Api\Settings\GeneralSettings())->repository->getGlobal();
        $notificationInterval = (string) $globals["email_notification_duration"];
        $confirmation = $globals["enable_email_notification_confirmation"] == 1;
        $startDate = new \DateTime();
        $endDate = (new \DateTime())->modify("+" . ($notificationInterval ?: "0") . " minutes");
        foreach ($clientsEmailsToNotify as $clientEmailsToNotify) {
            $clientId = $clientEmailsToNotify["resource_id"];
            $client = (new \mgCRM2\Models\Resource())->find($clientId)->getAttributes();
            $name = $client["name"] . " " . $client["lastname"];
            $mailSubject = $clientEmailsToNotify["title"];
            $content = "You have got a new email from " . $name . ". Subject: " . $mailSubject;
            $notificationData = ["class" => "", "type" => "temporary", "content" => $content, "date_start" => $startDate, "date_end" => $endDate, "confirmation" => $confirmation, "hide_after_confirm" => $confirmation, "admins" => [$client["admin_id"]]];
            $this->createNotification($notificationData);
        }
    }
    public function updateNotification($id, array $data = [])
    {
        $notification = $this->getModel()->find($id);
        if(is_null($notification)) {
            throw new \Exception("Campaign not found");
        }
        $startDate = \Carbon\Carbon::parse(array_get($data, "date_start"));
        $endDate = \Carbon\Carbon::parse(array_get($data, "date_end"));
        $startDate->hour = $endDate->minute = $endDate->second = 0;
        $endDate->hour = 23;
        $endDate->minute = $endDate->second = 59;
        $parsed = ["class" => array_get($data, "class", ""), "type" => array_get($data, "type", ""), "content" => array_get($data, "content", ""), "date_start" => $startDate, "date_end" => $endDate, "confirmation" => array_get($data, "confirmation", false) === true ? true : false, "hide_after_confirm" => array_get($data, "hide_after_confirm", false) === true ? true : false];
        $notification->fill($parsed);
        $notification->save();
        $adminsIDs = array_get($data, "admins", []);
        if(!empty($adminsIDs)) {
            $notification->admins()->sync($adminsIDs);
        }
        return $notification;
    }
    public function getNorificationsListTableQuery($data)
    {
        $limit = array_get($data, "params.pagination.number", 10);
        $ofset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", "date_start");
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $name = array_get($data, "params.search.predicateObject.name", false);
        $description = array_get($data, "params.search.predicateObject.description", false);
        $search = array_get($data, "params.search.predicateObject", false);
        $searchGlobal = array_pull($search, "\$", false);
        $query = $this->getModel()->withAdmins();
        if(!empty($searchGlobal)) {
            $query = $query->whereContent($searchGlobal);
        }
        $total = $query->count();
        $results = $query->orderBy($orderBy, $orderDesc)->take($limit)->offset($ofset)->get();
        $return = [];
        foreach ($results as $r) {
            $tmp = $r->toArray();
            $tmp["accepted"] = $r->getAdminWhoAcceptted();
            $return[] = $tmp;
        }
        $return = ["data" => $return, "total" => $total];
        return $return;
    }
    public function getMineNotificationList($adminID)
    {
        $return = [];
        $notifications = \mgCRM2\Models\Notification::whereHas("admins", function ($q) use($q) {
            $q->where("crm_notifications_admins.admin_id", "=", \Illuminate\Database\Capsule\Manager::raw($adminID));
        })->get();
        $return = [];
        foreach ($notifications as $n) {
            $tmp = $n->toArray();
            if(count($n->admins)) {
                $searchedAdmin = $n->admins->filter(function ($item) use($item) {
                    return $item->id == $adminID;
                })->first();
                $tmp["accepted_at"] = $searchedAdmin->pivot->accepted_at;
                $tmp["class"] = sprintf("note-%s", $n->class);
            }
            if($n->active === true && !($n->confirmation === true && $n->hide_after_confirm === true && $tmp["accepted_at"] !== NULL)) {
                $return[] = $tmp;
            }
        }
        return $return;
    }
    public function deleteNotification($id)
    {
        $found = $this->getModel()->where("id", "=", $id)->first();
        if(is_null($found)) {
            throw new \Exception(sprintf("Couldn't find Notification #%d", $id));
        }
        return $found->forceDelete();
    }
    public function acceptNotification($requestData, $adminID)
    {
        $noteID = array_get($requestData, "note");
        $found = $this->getModel()->find($noteID);
        if($found->active === false) {
            throw new \Exception(sprintf("Notification #%d is inactive", $found->id));
        }
        if(is_null($found)) {
            throw new \Exception(sprintf("Couldn't find Notification #%d", $id));
        }
        $now = \Carbon\Carbon::now();
        \Illuminate\Database\Capsule\Manager::table("crm_notifications_admins")->where("crm_notifications_admins.notification_id", "=", $noteID)->where("crm_notifications_admins.admin_id", "=", $adminID)->update(["accepted_at" => $now]);
        return true;
    }
    public function getNotification($id)
    {
        $notification = $this->getModel()->find($id);
        if(is_null($notification)) {
            throw new \Exception("Notification not found");
        }
        $return = $notification->toArray();
        $return["admins"] = $notification->admins->pluck("id");
        return $return;
    }
}

?>