<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Just container for notes
 * as repository pattern
 */
class Notes extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\Note";
    }
    public function addNoteForResource($resourceId, $noteData)
    {
        $data = [];
        $data = array_add($data, "content", array_get($noteData, "content", NULL));
        $data = array_add($data, "resource_id", intval($resourceId));
        if(array_get($noteData, "admin") != NULL) {
            $data = array_add($data, "admin_id", array_get($noteData, "admin"));
        } else {
            $data = array_add($data, "admin_id", \mgCRM2\Integration\Slim\SlimApp::getInstance()->currentAdmin->id);
        }
        $new = $this->getModel()->fill($data);
        $new->save();
        $new->load(["admin" => function ($query) {
            $query->joinAvatar();
        }]);
        $log = new \mgCRM2\Models\Log(["resource_id" => $resourceId, "admin_id" => array_get($data, "admin_id"), "event" => "Note Add", "date" => \Carbon\Carbon::now(), "message" => \mgCRM2\Services\Language::translate("log.note.new", ["conent" => array_get($noteData, "content", NULL)])]);
        $log->save();
        $notificationHelper = new \mgCRM2\Controllers\Api\Notifications\NotificationsHelpers();
        $notificationHelper->addAdminsNotificationFromMentions($data["content"], $resourceId);
        return $new;
    }
    public function softDeleteFor($resourceId, $noteID)
    {
        return $this->deleteNote($resourceId, $noteID, false);
    }
    public function forceDeleteFor($resourceId, $noteID)
    {
        return $this->deleteNote($resourceId, $noteID, true);
    }
    protected function deleteNote($resourceId, $noteID, $force = false)
    {
        $found = $this->getModel()->withTrashed()->where("resource_id", "=", $resourceId)->where("id", "=", $noteID)->first();
        if(is_null($found)) {
            throw new \Exception(sprintf("Couldn't find Note #%s for Resource %s", $noteID, $resourceId));
        }
        if($force === true) {
            return $found->forceDelete();
        }
        if($found->delete()) {
            return $found;
        }
        throw new \Exception(sprintf("Something went wrong at delete Note #%s for Resource %s", $noteID, $resourceId));
    }
    public function restoreNote($resourceId, $noteID)
    {
        $found = $this->getModel()->withTrashed()->where("resource_id", "=", $resourceId)->where("id", "=", $noteID)->first();
        if(is_null($found)) {
            throw new \Exception(sprintf("Couldn't find Note #%s for Resource %s", $noteID, $resourceId));
        }
        if($found->restore()) {
            return $found;
        }
        throw new \Exception(sprintf("Something went wrong at restore Note #%s for Resource %s", $noteID, $resourceId));
    }
    public function handleEditContent($resourceId, $noteID, array $data = [])
    {
        $found = $this->getModel()->withTrashed()->where("resource_id", "=", $resourceId)->where("id", "=", $noteID)->with(["admin" => function ($query) {
            $query->select("id", "firstname", "lastname", "email");
        }])->first();
        if(is_null($found)) {
            throw new \Exception(sprintf("Couldn't find Note #%s for Resource %s", $noteID, $resourceId));
        }
        $found->content = array_get($data, "content", "");
        if($found->save()) {
            return $found;
        }
        throw new \Exception(sprintf("Something went wrong at editing Note #%s for Resource %s", $noteID, $resourceId));
    }
    public static function fixMigratedNotesHtmlCode($resourceID)
    {
        $colection = \mgCRM2\Models\Note::whereResource($resourceID)->get();
        foreach ($colection as $note) {
            $note->content = html_entity_decode($note->content);
            $note->save();
        }
        unset($colection);
    }
}

?>