<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Just container for model
 * as repository pattern
 */
class MassMessageConfigs extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\MassMessageConfig";
    }
    public function addMassMessageConfig($data)
    {
        $toFill = [];
        $toFill = array_add($toFill, "description", array_get($data, "description", NULL));
        $toFill = array_add($toFill, "message_content", array_get($data, "message_content", NULL));
        $toFill = array_add($toFill, "message_title", array_get($data, "message_title", NULL));
        $toFill = array_add($toFill, "message_type", array_get($data, "message_type", NULL));
        $toFill = array_add($toFill, "target_type", array_get($data, "target_type", NULL));
        $toFill = array_add($toFill, "target_ids", array_get($data, "target_ids", []));
        $toFill = array_add($toFill, "mailbox_id", array_get($data, "mailbox_id", NULL));
        $date = \Carbon\Carbon::parse(array_get($data, "date"));
        $toFill = array_add($toFill, "date", $date);
        $new = $this->model->create($toFill);
        $new->save();
        return $new;
    }
    public function updateMassMessagesConfig($id, $data)
    {
        $model = $this->getModel()->find($id);
        if(is_null($model)) {
            throw new \Exception(sprintf("Couldn't find Mass Mail Configuration #%d", $id));
        }
        $toFill = [];
        $toFill = array_add($toFill, "description", array_get($data, "description", NULL));
        $toFill = array_add($toFill, "message_content", array_get($data, "message_content", NULL));
        $toFill = array_add($toFill, "message_title", array_get($data, "message_title", NULL));
        $toFill = array_add($toFill, "message_type", array_get($data, "message_type", NULL));
        $toFill = array_add($toFill, "target_type", array_get($data, "target_type", NULL));
        $toFill = array_add($toFill, "target_ids", array_get($data, "target_ids", []));
        $toFill = array_add($toFill, "mailbox_id", array_get($data, "mailbox_id", NULL));
        $date = \Carbon\Carbon::parse(array_get($data, "date"));
        $toFill = array_add($toFill, "date", $date);
        $model->fill($toFill);
        $model->save();
        return $model;
    }
    public function getMassMessagesConfig($id)
    {
        $model = $this->getModel()->find($id);
        if(is_null($model)) {
            throw new \Exception(sprintf("Couldn't find Mass Mail Configuration #%d", $id));
        }
        return $model->toArray();
    }
    public function deleteMassMessagesConfig($id)
    {
        $found = $this->getModel()->find($id);
        if(is_null($found)) {
            throw new \Exception(sprintf("Couldn't find Mass Mail Configuration #%d", $id));
        }
        return $found->forceDelete();
    }
    public function parseForTable(array $data = [])
    {
        $limit = array_get($data, "params.pagination.number", 10);
        $ofset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", "date");
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $search = array_get($data, "params.search.predicateObject", false);
        $searchGlobal = array_pull($search, "\$", false);
        $description = array_get($data, "params.search.predicateObject.description", false);
        $messageContent = array_get($data, "params.search.predicateObject.message_content", false);
        $messageTitle = array_get($data, "params.search.predicateObject.message_title", false);
        $messageType = array_get($data, "params.search.predicateObject.message_type", false);
        $targetType = array_get($data, "params.search.predicateObject.target_type", false);
        $generated = array_get($data, "params.search.predicateObject.generated", false);
        $date = array_get($data, "params.search.predicateObject.date", false);
        $orderableColumn = ["id" => "crm_mass_message_configs.id", "description" => "crm_mass_message_configs.description", "message_content" => "crm_mass_message_configs.message_content", "message_title" => "crm_mass_message_configs.message_title", "message_type" => "crm_mass_message_configs.message_type", "target_type" => "crm_mass_message_configs.target_type", "generated" => "crm_mass_message_configs.generated", "date" => "crm_mass_message_configs.date", "messages_count" => "messages_count"];
        if(isset($orderableColumn[$orderBy])) {
            $orderBy = $orderableColumn[$orderBy];
        } else {
            $orderBy = $orderableColumn["date"];
        }
        $query = \mgCRM2\Models\MassMessageConfig::withMessagesCount();
        if(!empty($description)) {
            $query = $query->whereDescription($description);
        }
        if(!empty($messageContent)) {
            $query = $query->whereMessageContent($messageContent);
        }
        if(!empty($messageTitle)) {
            $query = $query->whereMessageTitle($messageTitle);
        }
        if($messageType == "email") {
            $query = $query->whereMessageEmailType();
        } elseif($messageType == "sms") {
            $query = $query->whereTargetUserGroups();
        }
        if($targetType == "users") {
            $query = $query->whereTargetUsers();
        } elseif($targetType == "usergroups") {
            $query = $query->whereTargetUserGroups();
        } elseif($targetType == "campaigns") {
            $query = $query->whereTargetCampaigns();
        }
        if($generated === "1") {
            $query = $query->whereAlreadyGenerated();
        } elseif($generated === "0") {
            $query = $query->whereNotGenerated();
        }
        if(!empty($date)) {
            $query = $query->where("crm_mass_message_configs.date", "like", "%" . $date . "%");
        }
        if(!empty($searchGlobal)) {
            $query = $query->where(function ($query) use($query) {
                $query = $query->orWhere("crm_mass_message_configs.message_content", "like", "%" . $searchGlobal . "%")->orWhere("crm_mass_message_configs.message_title", "like", "%" . $searchGlobal . "%")->orWhere("crm_mass_message_configs.description", "like", "%" . $searchGlobal . "%");
            });
        }
        $totalq = clone $query;
        $totalr = $totalq->select(\Illuminate\Database\Capsule\Manager::raw("Count(*) as total"))->first();
        $total = empty($totalr) ? 0 : intval($totalr->total);
        $results = $query->orderBy($orderBy, $orderDesc)->take($limit)->offset($ofset)->get();
        $return = ["data" => $results->toArray(), "total" => $total];
        return $return;
    }
    public function generatePendingMassMessages()
    {
        $sliApp = new \mgCRM2\Integration\Slim\SlimApp();
        $sliApp::getInstance()->log->notice("CRON: Generate Messages to send - START");
        $collection = $this->getModel()->whereNotGenerated()->afterDate()->get();
        if(0 < count($collection)) {
            \mgCRM2\Integration\Slim\SlimApp::getInstance()->log->notice("CRON: Found {num} Mass Message configuration that date passed", ["num" => count($collection)]);
        } else {
            \mgCRM2\Integration\Slim\SlimApp::getInstance()->log->notice("CRON: Nothing To Generate");
        }
        $collection = $collection->map(function ($item, $key) {
            return $item->generatePendingMessages();
        });
        \mgCRM2\Integration\Slim\SlimApp::getInstance()->log->notice("CRON: Generate Messages to send - END");
    }
}

?>