<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Repository pattern for Campaign
 * Wrap certain actions for collection of our model or perform more complexed actions on model
 */
class Followups extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\Followup";
    }
    public function createWithReminders($resourceID, array $data = [])
    {
        $followup = $this->createFollowup($resourceID, $data);
        $reminders = [];
        $admin_reminders = array_get($data, "admin_reminders", []);
        foreach ($admin_reminders as $remind => $what) {
            if(array_get($what, "enable", false)) {
                if(array_get($what, "email.enable", false)) {
                    $reminders[] = Reminders::createAdminEmailRemidner($followup, $remind, array_get($what, "email", []));
                }
                if(array_get($what, "sms.enable", false)) {
                    $reminders[] = Reminders::createAdminSmsRemidner($followup, $remind, array_get($what, "sms", []));
                }
            }
        }
        $client_reminders = array_get($data, "client_reminders", []);
        foreach ($client_reminders as $remind => $what) {
            if(array_get($what, "enable", false)) {
                if(array_get($what, "email.enable", false)) {
                    $reminders[] = Reminders::createClientEmailRemidner($followup, $remind, array_get($what, "email", []));
                }
                if(array_get($what, "sms.enable", false)) {
                    $reminders[] = Reminders::createClientSmsRemidner($followup, $remind, array_get($what, "sms", []));
                }
            }
        }
        $reminders = array_filter($reminders, function ($value) {
            return $value !== false && $value instanceof \mgCRM2\Models\Reminder;
        });
        $followup->reminders()->saveMany($reminders);
        $followup->load("reminders");
        return $followup;
    }
    public function createFollowup($resourceID, array $data = [])
    {
        $resource = \mgCRM2\Models\Resource::findOrFail($resourceID);
        $followupType = \mgCRM2\Models\FollowupType::findOrFail(array_get($data, "type"));
        $followupStatus = \mgCRM2\Models\FollowupStatus::findOrFail(array_get($data, "status"));
        $admin = \mgCRM2\Models\Whmcs\Admin::where("disabled", "0")->findOrFail(array_get($data, "admin"));
        $date = \Carbon\Carbon::parse(array_get($data, "date"));
        $followup = new \mgCRM2\Models\Followup(["resource_id" => $resource->id, "type_id" => $followupType->id, "status_id" => $followupStatus->id, "admin_id" => $admin->id, "description" => array_get($data, "description", ""), "date" => $date]);
        $followup->save();
        if($followup) {
            $synchronizationCalendar = new CalendarSynchronization();
            if($synchronizationCalendar->isSynchonization()) {
                $synchronizationCalendar->createSynchronization($followup->toArray());
            }
        }
        return $followup;
    }
    public static function createFollowupForResourceOnCreate(\mgCRM2\Models\Resource $resource, array $data = [])
    {
        $followupTypeID = \mgCRM2\Models\Setting::forGlobal()->whereSetting("followups_create_lead_followup_type")->first();
        $followupStatusID = \mgCRM2\Models\Setting::forGlobal()->whereSetting("followups_create_lead_followup_status")->first();
        $followupType = \mgCRM2\Models\FollowupType::find($followupTypeID->value);
        if(!$followupType) {
            $followupType = \mgCRM2\Models\FollowupType::first();
        }
        $followupStatus = \mgCRM2\Models\FollowupStatus::find($followupStatusID->value);
        if(!$followupStatus) {
            $followupStatus = \mgCRM2\Models\FollowupStatus::first();
        }
        $admin = \mgCRM2\Models\Whmcs\Admin::where("disabled", "0")->find(array_get($data, "admin"));
        if(!$admin) {
            if($resource->admin->id) {
                $admin = $resource->admin;
            } else {
                $admin = \mgCRM2\Models\Whmcs\Admin::where("disabled", "0")->find(\mgCRM2\Integration\Slim\SlimApp::getInstance()->currentAdmin->id);
            }
        }
        if(isset($data["date"])) {
            $date = \Carbon\Carbon::parse(array_get($data, "date"));
        } else {
            $date = \Carbon\Carbon::now();
        }
        $followup = new \mgCRM2\Models\Followup(["resource_id" => $resource->id, "type_id" => $followupType->id, "status_id" => $followupStatus->id, "admin_id" => $admin->id, "description" => array_get($data, "description", "After Create"), "date" => $date]);
        $followup->save();
        return $followup;
    }
    public function parseForTable($resourceID, array $data = [])
    {
        $limit = array_get($data, "params.pagination.number", 10);
        $ofset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", "date");
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $description = array_get($data, "params.search.predicateObject.description", false);
        $typeId = array_get($data, "params.search.predicateObject.type_id", false);
        $statusId = array_get($data, "params.search.predicateObject.status_id", false);
        $admin_id = array_get($data, "params.search.predicateObject.admin_id", false);
        $search_id = array_get($data, "params.search.predicateObject.id", false);
        $search_date = array_get($data, "params.search.predicateObject.date", false);
        if($orderBy == "admin") {
            $orderBy = "admin_id";
        } elseif($orderBy == "type") {
            $orderBy = "type_id";
        }
        if($orderBy == "status") {
            $orderBy = "status_id";
        }
        $queryTotal = \mgCRM2\Models\Followup::whereResource($resourceID);
        $query = $this->getModel()->select(["crm_followups.*", "crm_resources_types.icon", \Illuminate\Database\Capsule\Manager::raw("REPLACE(LOWER(`crm_resources_types`.`name`),' ','_') AS 'code'")])->leftJoin("crm_resources", "crm_resources.id", "=", "crm_followups.resource_id")->leftJoin("crm_resources_types", "crm_resources.type_id", "=", "crm_resources_types.id")->whereResource($resourceID)->joinAdminRelevant()->joinType()->joinStatus()->orderBy($orderBy, $orderDesc)->with("remindersCount")->with("reminders")->take($limit)->offset($ofset);
        if(!empty($description) && $description !== false) {
            $query = $query->where("crm_followups.description", "like", "%" . $description . "%");
            $queryTotal = $queryTotal->where("crm_followups.description", "like", "%" . $description . "%");
        }
        if(!empty($typeId) && $typeId !== false) {
            $query = $query->where("crm_followups.type_id", "=", $typeId);
            $queryTotal = $queryTotal->where("crm_followups.type_id", "=", $typeId);
        }
        if(!empty($statusId) && $statusId !== false) {
            $query = $query->where("crm_followups.status_id", "=", $statusId);
            $queryTotal = $queryTotal->where("crm_followups.status_id", "=", $statusId);
        }
        if(!empty($admin_id) && $admin_id !== false || $admin_id === "0") {
            if((int) $admin_id == 0) {
                $query = $query->whereNull("crm_followups.admin_id");
                $queryTotal = $queryTotal->whereNull("crm_followups.admin_id");
            } else {
                $query = $query->where("crm_followups.admin_id", "=", $admin_id);
                $queryTotal = $queryTotal->where("crm_followups.admin_id", "=", $admin_id);
            }
        }
        if(!empty($search_id) && $search_id !== false) {
            $query = $query->where("crm_followups.id", "=", $search_id);
            $queryTotal = $queryTotal->where("crm_followups.id", "=", $search_id);
        }
        if(!empty($search_date) && $search_date !== false) {
            $query = $query->where("crm_followups.date", "like", "%" . $search_date . "%");
            $queryTotal = $queryTotal->where("crm_followups.id", "like", "%" . $search_date . "%");
        }
        $results = $query->get();
        $count = $queryTotal->count();
        $parsed = [];
        foreach ($results as $r) {
            $tmp = $r->toArray();
            $tmp["reminders_count"] = $r->remindersCount;
            $parsed[] = $tmp;
        }
        $settings = new Settings();
        $settings = $settings->getGlobalsForTwig()->all();
        if($settings["followups_per_day"]) {
            foreach ($parsed as $key => &$data) {
                $parsed[$key]["date"] = $this->convertDatetimeToDate($parsed[$key]["date"]);
            }
        }
        $alc = \mgCRM2\Services\ACL::getInstance();
        $removeIds = [];
        foreach ($parsed as $key => $value) {
            if(!$alc->hasAccess("leads." . $value["code"])) {
                $removeIds[] = $key;
            }
        }
        foreach ($removeIds as $key) {
            unset($parsed[$key]);
        }
        $return = ["data" => $parsed, "total" => $count - count($removeIds)];
        return $return;
    }
    private function convertDatetimeToDate($data)
    {
        $date = new \DateTime($data);
        return $date->format("Y-m-d");
    }
    public function parseForDashboardTable(array $data = [], $adminID = false, $forAPI = false)
    {
        $limit = array_get($data, "params.pagination.number", 5);
        $ofset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", "date");
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $search = array_get($data, "params.search.predicateObject", []);
        $searchGlobal = array_pull($search, "\$", false);
        $description = array_get($data, "params.search.predicateObject.description", false);
        $typeId = array_get($data, "params.search.predicateObject.type_id", false);
        $reminders = array_get($data, "params.search.predicateObject.reminders", false);
        $leadStatusId = array_get($data, "params.search.predicateObject.lead_status_id", false);
        $leadPriorityId = array_get($data, "params.search.predicateObject.lead_priority_id", false);
        $leadName = array_get($data, "params.search.predicateObject.lead_name", false);
        $startDate = array_get($data, "startDate", false);
        $endDate = array_get($data, "endDate", false);
        $day = array_get($data, "params.search.predicateObject.day", false);
        if(!$day) {
            $dayObj = \Carbon\Carbon::now();
        } else {
            $dayObj = \Carbon\Carbon::parse($day);
        }
        if($orderBy == "lead_name") {
            $orderBy = "crm_resources.name";
        } elseif($orderBy == "date") {
            $orderBy = "crm_followups.date";
        } elseif($orderBy == "type") {
            $orderBy = "crm_followup_types.order";
        } elseif($orderBy == "status") {
            $orderBy = "crm_resources_statuses.order";
        } elseif($orderBy == "priority") {
            $orderBy = "crm_resources.priority";
        } elseif($orderBy == "description") {
            $orderBy = "crm_followups.description";
        }
        $query = $this->getModel()->select(["crm_followups.*", "crm_resources_types.icon", \Illuminate\Database\Capsule\Manager::raw("REPLACE(LOWER(`crm_resources_types`.`name`),' ','_') AS 'code'")])->joinAdminRelevant()->joinType()->withResourceAndStatus()->orderBy($orderBy, $orderDesc)->with(["remindersCount", "resource", "resource.type", "resource.status"])->leftJoin("crm_followup_types", "crm_followup_types.id", "=", "crm_followups.type_id")->leftJoin("crm_resources", "crm_resources.id", "=", "crm_followups.resource_id")->leftJoin("crm_resources_statuses", "crm_resources_statuses.id", "=", "crm_resources.status_id")->leftJoin("crm_resources_types", "crm_resources.type_id", "=", "crm_resources_types.id");
        $query = $query->whereNull("crm_resources.deleted_at");
        if(is_numeric($adminID)) {
            $adminID = (int) $adminID;
        }
        if(\mgCRM2\Models\Validators\Common::isPositiveUnsignedNumber($adminID) && $adminID !== false) {
            $query = $query->where("crm_followups.admin_id", "=", $adminID);
        } elseif($adminID !== "") {
            if($adminID === 0) {
                $query = $query->whereNull("crm_resources.admin_id");
            }
        }
        $campaignID = array_get($data, "campaign");
        if(\mgCRM2\Models\Validators\Common::isPositiveUnsignedNumber($campaignID)) {
            $query = $query->whereCampaign($campaignID);
        } elseif($campaignID === 0) {
            $query = $query->whereNoCampaign();
        }
        $query = $query->where(\Illuminate\Database\Capsule\Manager::raw("DATE_FORMAT(date, '%Y-%m-%d')"), "=", $dayObj->format("Y-m-d"));
        if(!empty($searchGlobal) && $searchGlobal !== false) {
            $query = $query->where(function ($query) use($query) {
                $query->where("crm_followups.description", "LIKE", \Illuminate\Database\Capsule\Manager::raw("'%" . $searchGlobal . "%'"))->orWhere("crm_resources.name", "LIKE", \Illuminate\Database\Capsule\Manager::raw("'%" . $searchGlobal . "%'"))->orWhere("crm_resources.lastname", "LIKE", \Illuminate\Database\Capsule\Manager::raw("'%" . $searchGlobal . "%'"));
            });
        }
        if(!empty($description) && $description !== false) {
            $query = $query->withDescription($description);
        }
        if(!empty($typeId) && $typeId !== false) {
            $query = $query->where("crm_followups.type_id", "=", $typeId);
        }
        if(!empty($startDate) && $startDate !== false) {
            $query = $query->where("crm_followups.date", ">", $startDate);
        }
        if(!empty($endDate) && $endDate !== false) {
            $query = $query->where("crm_followups.date", "<", $endDate);
        }
        if(!empty($leadPriorityId) && $leadPriorityId !== false) {
            if($leadPriorityId == 1) {
                $query = $query->where(function ($query) {
                    $query->whereNull("crm_resources.priority")->orWhere("crm_resources.priority", "LIKE", 1);
                });
            } else {
                $query = $query->where("crm_resources.priority", "LIKE", $leadPriorityId);
            }
        }
        $query->joinStatus();
        $results = $query->get();
        $parsed = [];
        foreach ($results as $r) {
            $tmp = $r->toArray();
            $tmp["reminders_count"] = $r->remindersCount;
            $conditions = true;
            if(!empty($reminders) && $reminders !== false && $r->remindersCount != $reminders) {
                $conditions = false;
            }
            if(!empty($leadStatusId) && $leadStatusId !== false && $r->resource->status->id != $leadStatusId) {
                $conditions = false;
            }
            if(!empty($leadPriorityId) && $leadPriorityId !== false) {
                if($leadPriorityId == 1) {
                    if($r->resource->priority != 1 && $r->resource->priority != NULL) {
                        $conditions = false;
                    }
                } elseif($r->resource->priority != $leadPriorityId) {
                    $conditions = false;
                }
            }
            if(!empty($leadName) && $leadName !== false && strpos($r->resource->name, $leadName) === false) {
                $conditions = false;
            }
            if($conditions) {
                $parsed[] = $tmp;
            }
        }
        $alc = \mgCRM2\Services\ACL::getInstance();
        $removeIds = [];
        foreach ($parsed as $key => $value) {
            if(!$alc->hasAccess("leads." . $value["code"])) {
                $removeIds[] = $key;
            }
        }
        foreach ($removeIds as $key) {
            unset($parsed[$key]);
        }
        if($forAPI === true) {
            return $parsed;
        }
        $cut = [];
        for ($i = $ofset; $i < count($parsed); $i++) {
            if($limit <= 0) {
                break;
            }
            $cut[] = $parsed[$i];
            $limit--;
        }
        $return = ["data" => $cut, "total" => count($parsed)];
        return $return;
    }
    public function getSingleWithReminders($resourceID, $followupID)
    {
        return $this->getModel()->whereResource($resourceID)->joinAdminRelevant()->joinType()->joinStatus()->joinReminders()->findOrFail($followupID);
    }
    public function getSingle($resourceID, $followupID)
    {
        return $this->getModel()->whereResource($resourceID)->joinAdminRelevant()->joinType()->joinStatus()->findOrFail($followupID);
    }
    public function updateSingleFollowup($resourceID, $followupID, $requestData)
    {
        $followup = $this->getModel()->whereResource($resourceID)->findOrFail($followupID);
        $followupType = \mgCRM2\Models\FollowupType::findOrFail(array_get($requestData, "type_id"));
        $followupStatus = \mgCRM2\Models\FollowupStatus::findOrFail(array_get($requestData, "status_id"));
        $admin = \mgCRM2\Models\Whmcs\Admin::where("disabled", "0")->findOrFail(array_get($requestData, "admin_id"));
        $newDate = \Carbon\Carbon::parse(array_get($requestData, "date"));
        $description = array_get($requestData, "description", "");
        $oldDate = \Carbon\Carbon::parse($followup->date)->copy();
        $followup->fill(["resource_id" => $followup->resource_id, "date" => $newDate, "description" => $description, "admin_id" => $admin->id, "type_id" => $followupType->id, "status_id" => $followupStatus->id]);
        if(!$followup->save()) {
            throw new Exception("Something went wrong");
        }
        if(array_get($requestData, "updateReminders", false) === true) {
            $timeDiff = $oldDate->diffInMinutes($newDate);
            $plusToDate = $newDate->gt($oldDate);
            foreach ($followup->reminders as $reminder) {
                $reminder->reschedue($plusToDate, $timeDiff);
            }
        }
        if($followup) {
            $synchronizationCalendar = new CalendarSynchronization();
            if($synchronizationCalendar->isSynchonization()) {
                $synchronizationCalendar->updateSynchronization($followup->toArray());
            }
        }
        return $followup;
    }
    public function queryCalendarForAdmin($adminID)
    {
        return $this->getModel()->whereAdmin($adminID)->joinLeadTypeAndName()->with(["remindersCount", "resource", "resource.type", "resource.status"])->get();
    }
    public function queryCalendarForAllAdmins()
    {
        return $this->getModel()->joinLeadTypeAndName()->with(["remindersCount", "resource", "resource.type", "resource.status"])->get();
    }
    public function deleteSingleFollowup($resourceID, $followupID)
    {
        if($followupID) {
            $synchronizationCalendar = new CalendarSynchronization();
            if($synchronizationCalendar->isSynchonization()) {
                $synchronizationCalendar->deleteSynchronization($followupID);
            }
        }
        $followup = $this->getModel()->whereResource($resourceID)->findOrFail($followupID);
        $followup->dropWithReminders();
    }
    public function reschedueFollowup($resourceID, $followupID, array $data = [])
    {
        $followup = $this->getModel()->whereResource($resourceID)->joinReminders()->findOrFail($followupID);
        return $followup->reschedueWithReminders($data);
    }
    public function getCountersForCalendar($year, $month, $adminID, $campaign = NULL)
    {
        $alc = \mgCRM2\Services\ACL::getInstance();
        $alcRules = $alc->getRules();
        $type_name = [];
        foreach ($alcRules["leads"] as $key => $value) {
            if($alc->hasAccess("leads." . $key)) {
                $type_name[] = (string) $key;
            }
        }
        $query = $this->getModel()->select(\Illuminate\Database\Capsule\Manager::raw("count(*) as total"), \Illuminate\Database\Capsule\Manager::raw("DATE_FORMAT(crm_followups.date, '%d') as day"))->leftJoin("crm_resources", "crm_resources.id", "=", "crm_followups.resource_id")->leftJoin("crm_resources_types", "crm_resources.type_id", "=", "crm_resources_types.id")->whereNull("crm_followups.deleted_at")->where(\Illuminate\Database\Capsule\Manager::raw("DATE_FORMAT(crm_followups.date, '%Y')"), "=", $year)->where(\Illuminate\Database\Capsule\Manager::raw("DATE_FORMAT(crm_followups.date, '%c')"), "=", $month)->whereIn(\Illuminate\Database\Capsule\Manager::raw("REPLACE(LOWER(`crm_resources_types`.`name`),' ','_')"), $type_name)->groupBy(\Illuminate\Database\Capsule\Manager::raw("DATE_FORMAT(crm_followups.date, '%d')"));
        $query = $query->whereNull("crm_resources.deleted_at");
        if(is_numeric($adminID)) {
            $adminID = (int) $adminID;
        }
        if(\mgCRM2\Models\Validators\Common::isPositiveUnsignedNumber($adminID)) {
            $query = $query->where("crm_followups.admin_id", "=", $adminID);
        } elseif($adminID === 0) {
            $query = $query->whereNull("crm_resources.admin_id");
        }
        if(\mgCRM2\Models\Validators\Common::isPositiveUnsignedNumber($campaign)) {
            $query = $query->whereCampaign($campaign);
        } elseif($campaign === 0) {
            $query = $query->whereNoCampaign();
        }
        $counter = $query->get()->toArray();
        $return = [];
        $dt = \Carbon\Carbon::parse($year . "-" . $month);
        for ($i = 0; $i < $dt->daysInMonth; $i++) {
            $return[] = 0;
        }
        foreach ($counter as $c) {
            array_set($return, intval(--$c["day"]), intval($c["total"]));
        }
        return $return;
    }
}

?>