<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Just container for Orders
 * as repository pattern
 */
class FieldGroups extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\FieldGroup";
    }
    public function reorder(array $newOrder)
    {
        if(empty($newOrder)) {
            $this->app->response->setStatus(404);
            throw new Exception("Wrong order parameters provided");
        }
        $groups = $this->model->all();
        foreach ($groups as $group) {
            $group->order = array_get($newOrder, $group->id, 0);
            $group->save();
        }
        return true;
    }
    public function updateSingleParamInModel($id, $data)
    {
        $model = $this->find($id);
        if(!$model) {
            throw new Exception("Couldnt find group with id " . $id);
        }
        if(!$model->updateSingleParam($data)) {
            throw new Exception("Something went wrong");
        }
        return $model;
    }
    public function withFieldsAndValidators()
    {
        return $this->model->where("active", "=", 1)->with(["fields" => function ($query) {
            $query->where("active", "=", 1)->orderBy("order", "asc");
        }, "fields.validators", "fields.options"])->orderBy("order", "asc")->get();
    }
    public function getAllForResourceSummary($resourceID)
    {
        return \mgCRM2\Models\FieldGroup::activeGroups()->activeGroups()->joinActiveFields()->joinValidators()->joinOptions()->joinFieldsDataFor($resourceID)->orderred()->get();
    }
}

?>