<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Just container for Field Datas
 * Nothing much here except trigger scopes function to obtain various records
 * as repository pattern
 */
class FieldDatas extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\FieldData";
    }
    public function getAllForResourceSummary($resourceID)
    {
        $repository = new FieldGroups();
        $fields = $repository->withFieldsAndValidators();
        return ["groups" => $fields->toArray(), "fields" => $this->getArrayFieldsForResourceSummary($resourceID)];
    }
    public function getArrayFieldsForResourceSummary($resourceID)
    {
        $query = $this->getModel()->joinField()->withResource($resourceID)->joinAssignedOptionsAndOption()->get();
        $result = $query->toArray();
        foreach ($result as &$row) {
            $row["data"] = preg_replace("/<br(\\s+)?\\/?>/i", "\n", $row["data"]);
        }
        return $result;
    }
    public function getOnlyFieldsForResourceSummary($resourceID)
    {
        $query = $this->getModel()->joinField()->withResource($resourceID)->joinAssignedOptionsAndOption()->get();
        return self::toArrayForSmarty($query);
    }
    public function getByResourceAndField($resourceId, $fieldId)
    {
        return $this->model->where("resource_id", $resourceId)->where("field_id", $fieldId)->first();
    }
    public static function toArrayForSmarty($data)
    {
        $return = [];
        foreach ($data as $fieldData) {
            $tmp = ["id" => $fieldData->field->id, "type" => $fieldData->field->type, "active" => $fieldData->field->active, "name" => $fieldData->field->name, "description" => $fieldData->field->description, "data" => $fieldData->data, "options" => NULL];
            if($fieldData->options) {
                $value = implode(" | ", $fieldData->options->map(function ($item, $key) {
                    return $item->option->value;
                })->toArray());
                $tmp["options"] = $value;
            }
            $return[$fieldData->field_id] = $tmp;
        }
        return $return;
    }
    public static function toArrayForExport($data)
    {
        $return = [];
        foreach ($data as $fieldData) {
            if($fieldData->options->count()) {
                $tmpOptions = $fieldData->options->map(function ($item, $key) {
                    return $item->option->value;
                })->toArray();
                $tmp = implode(";", $tmpOptions);
            } else {
                $tmp = is_null($fieldData->data) ? "" : $fieldData->data;
            }
            $return[$fieldData->field_id] = $tmp;
        }
        return $return;
    }
    public function updateData($resourceID, array $data = [])
    {
        $resourceID = intval($resourceID);
        $fieldID = array_get($data, "field_id");
        $fieldDataID = array_get($data, "field_data_id");
        $field = \mgCRM2\Models\Field::with("data")->findOrFail($fieldID);
        $resource = \mgCRM2\Models\Resource::findOrFail($resourceID);
        $fieldData = $field->getFieldDataOrNew($fieldID, $resourceID);
        $newVal = str_replace(["\n", "\r"], "", nl2br(array_get($data, "data", false)));
        if($fieldData->setData($newVal)) {
            $message = \mgCRM2\Services\Language::translate("log.field." . $fieldData->field_type . ".update", ["id" => $field->id, "field" => $field->name, "value" => $fieldData->getData()]);
            $log = new \mgCRM2\Models\Log(["resource_id" => $resourceID, "admin_id" => \mgCRM2\Integration\Slim\SlimApp::getInstance()->currentAdmin->id, "event" => "Field Update", "date" => \Carbon\Carbon::now(), "message" => $message]);
            $log->save();
            if($resource->touches) {
                $resource->touch();
            }
            $fieldDataArray = $fieldData->load("options")->toArray();
            unset($fieldDataArray["field"]);
            return ["status" => "success", "msg" => "Field has been updated", "updated_at" => $resource->updated_at->toDateTimeString(), "data" => $fieldDataArray];
        }
        throw new \Exception("something went wrong in update");
    }
}

?>