<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Just container for Email Logs
 * as repository pattern
 */
class EmailLogs extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\EmailLog";
    }
    public function parseForTable($resourceID, array $data = [])
    {
        $limit = array_get($data, "params.pagination.number", 10);
        $ofset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", "date");
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $search = array_get($data, "params.search.predicateObject.message", false);
        $search = array_get($data, "params.search.predicateObject", false);
        $searchGlobal = array_pull($search, "\$", false);
        $searchColumn = ["date" => array_get($data, "params.search.predicateObject.date", false), "to" => array_get($data, "params.search.predicateObject.to", false), "followup_id" => array_get($data, "params.search.predicateObject.followup_id", false), "reminder_id" => array_get($data, "params.search.predicateObject.reminder_id", false), "subject" => array_get($data, "params.search.predicateObject.subject", false), "cc" => array_get($data, "params.search.predicateObject.cc", false), "bcc" => array_get($data, "params.search.predicateObject.cc", false), "attachments" => array_get($data, "params.search.predicateObject.attachments", false)];
        $searchColumnmailBox = ["date" => array_get($data, "params.search.predicateObject.date", false), "email" => array_get($data, "params.search.predicateObject.to", false), "title" => array_get($data, "params.search.predicateObject.subject", false)];
        $query = $this->getModel()->withResource($resourceID)->withFollowup()->select("id", "resource_id", "followup_id", "reminder_id", "subject", "message", "date", "to", "cc", "bcc", "attachments", \Illuminate\Database\Capsule\Manager::raw("\"SEND\" AS table_row"));
        $mailboxReadQuery = (new \mgCRM2\Models\MailboxRead())->withResource($resourceID)->select("id", "resource_id as resource_id", \Illuminate\Database\Capsule\Manager::raw("NULL as followup_id"), \Illuminate\Database\Capsule\Manager::raw("NULL as reminder_id"), "title as subject", "content as message", "date as date", "email as to", \Illuminate\Database\Capsule\Manager::raw("\"\" as cc"), \Illuminate\Database\Capsule\Manager::raw("\"\" as bcc"), \Illuminate\Database\Capsule\Manager::raw("\"\" as attachments"), \Illuminate\Database\Capsule\Manager::raw("\"READ\" AS table_row"));
        if(!empty($searchGlobal) && $searchGlobal !== false) {
            $mailboxReadQuery->searchGlobal($searchGlobal);
        }
        foreach ($searchColumnmailBox as $column => $val) {
            if(!empty($val) && $val !== false) {
                $mailboxReadQuery->where($column, "LIKE", "%" . $val . "%");
            }
        }
        if(!empty($searchGlobal) && $searchGlobal !== false) {
            $query->withMessage($searchGlobal);
        }
        foreach ($searchColumn as $column => $val) {
            if(!empty($val) && $val !== false) {
                $query->where($column, "LIKE", "%" . $val . "%");
            }
        }
        $query->unionAll($mailboxReadQuery);
        $total = count($query->get());
        $results = $query->orderBy($orderBy, $orderDesc)->take($limit)->offset($ofset)->get();
        foreach ($results as $key => &$result) {
            if($result->table_row === "READ") {
                $id = $result->id;
                $attachment = \mgCRM2\Models\Attachment::where("mail_read_id", $id)->get();
                if($attachment) {
                    $attachment = $attachment->toArray();
                    foreach ($attachment as $key => &$attach) {
                        $attach["attachment"] = base64_encode($attach["attachment"]);
                        $attach["filename"] = \mgCRM2\Helpers\AttachmentsHelper::parseFileNameToDisplay($attach["filename"]);
                    }
                    $result->attachments = $attachment;
                }
            }
        }
        $return = ["data" => $results->toArray(), "total" => $total];
        return $return;
    }
    public function parseForDashboardTable(array $data = [])
    {
        $limit = array_get($data, "params.pagination.number", 10);
        $ofset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", "date");
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $search = array_get($data, "params.search.predicateObject", false);
        $searchGlobal = array_pull($search, "\$", false);
        $searchColumn = ["date" => array_get($data, "params.search.predicateObject.date", false), "sender" => array_get($data, "params.search.predicateObject.from", false), "to" => array_get($data, "params.search.predicateObject.to", false), "followup_id" => array_get($data, "params.search.predicateObject.followup_id", false), "reminder_id" => array_get($data, "params.search.predicateObject.reminder_id", false), "subject" => array_get($data, "params.search.predicateObject.subject", false), "cc" => array_get($data, "params.search.predicateObject.cc", false), "attachments" => array_get($data, "params.search.predicateObject.attachments", false), "message" => array_get($data, "params.search.predicateObject.message", false)];
        $searchColumnmailBox = ["date" => array_get($data, "params.search.predicateObject.date", false), "email" => array_get($data, "params.search.predicateObject.to", false), "title" => array_get($data, "params.search.predicateObject.subject", false)];
        $query = $this->getModel()->select("id", "sender as mail_configuration_id", "resource_id", "sender as from", "subject", "message", "date", "to");
        $mailboxReadQuery = (new \mgCRM2\Models\MailboxRead())->select("id", "mail_configuration_id", "resource_id as resource_id", "from_email as from", "title as subject", "content as message", "date as date", "email as to");
        if(!empty($searchGlobal) && $searchGlobal !== false) {
            $mailboxReadQuery->searchGlobal($searchGlobal);
        }
        foreach ($searchColumnmailBox as $column => $val) {
            if(!empty($val) && $val !== false) {
                $mailboxReadQuery->where($column, "LIKE", "%" . $val . "%");
            }
        }
        if(!empty($searchGlobal) && $searchGlobal !== false) {
            $query->withMessage($searchGlobal);
        }
        foreach ($searchColumn as $column => $val) {
            if(!empty($val) && $val !== false) {
                $query->where($column, "LIKE", "%" . $val . "%");
            }
        }
        $query->unionAll($mailboxReadQuery);
        $total = count($query->get());
        $results = $query->orderBy($orderBy, $orderDesc)->take($limit)->offset($ofset)->get();
        foreach ($results as &$email) {
            $email->message = html_entity_decode(strip_tags($this->removeHTMLElements($email->message)), ENT_QUOTES);
        }
        $return = ["data" => $results->toArray(), "total" => $total];
        return $return;
    }
    private function removeHTMLElements($html)
    {
        $doc = new \DomDocument();
        $doc->loadHTML(mb_convert_encoding($html, "HTML-ENTITIES", "UTF-8"));
        $this->removeElementsByTagName("style", $doc);
        $this->removeElementsByTagName("script", $doc);
        return $doc->saveHTML();
    }
    private function removeElementsByTagName($tagName, $document)
    {
        $nodeList = $document->getElementsByTagName($tagName);
        $nodeIdx = $nodeList->length;
        while (0 <= --$nodeIdx) {
            $node = $nodeList->item($nodeIdx);
            $node->parentNode->removeChild($node);
        }
    }
    public function sendRawEmail($resourceID, array $data = [], array $files = [])
    {
        require_once ROOTDIR . "/modules/addons/mgCRM2/app/Services/GetServicesInstance.php";
        $isGlobalConfig = true;
        $from = array_get($data, "from", NULL);
        $to = array_get($data, "to", NULL);
        $cc = \mgCRM2\Controllers\Api\Helpers\MailCcParameterHelper::parseFromString(array_get($data, "cc", NULL));
        $bcc = \mgCRM2\Controllers\Api\Helpers\MailCcParameterHelper::parseFromString(array_get($data, "bcc", NULL));
        $fromTypeName = array_get($data, "from_type_name", NULL);
        $template = array_get($data, "template", NULL);
        $subject = array_get($data, "subject", NULL);
        $content = array_get($data, "content", NULL);
        $settings = Settings::getSingleParameter("email_import_type");
        if($settings["email_import_type"] === 2 || $settings["email_import_type"] === 3) {
            $subject = "#" . $resourceID . " - " . $subject;
        }
        if(!empty($content)) {
            $content = nl2br($content);
        }
        if(!\mgCRM2\Models\Validators\Common::isValidEmail($to)) {
            throw new \Exception(sprintf("Email (%s) is not valid", $to));
        }
        if($from == 0) {
            $systemEmail = \Illuminate\Database\Capsule\Manager::table("tblconfiguration")->where("setting", "=", "Email")->take(1)->first(["value"]);
            $from = $systemEmail->value;
        } else {
            if($fromTypeName == "t") {
                $department = \mgCRM2\Models\Whmcs\TicketDepartment::filterIrrelevantParams()->find($from);
            } elseif($fromTypeName == "m") {
                $department = \mgCRM2\Models\Mailbox::filterIrrelevantParams()->find($from);
                $isGlobalConfig = false;
            }
            if(is_null($department)) {
                throw new \Exception("invalid ticket department");
            }
            $from = $department->email;
        }
        $smartyVariables = [];
        $customFieldRepo = new FieldDatas();
        $resource = \mgCRM2\Models\Resource::findOrFail($resourceID);
        $fieldsData = $customFieldRepo->getOnlyFieldsForResourceSummary($resource->id);
        array_set($smartyVariables, "fields", $fieldsData);
        array_set($smartyVariables, "contact", $resource->load("admin", "type", "notes", "labels", "status", "client", "ticket")->toArray());
        array_set($smartyVariables, "resource", $this->getResourceVariables($resourceID));
        $whmcsClient = $resource->load("client");
        if(isset($whmcsClient->client)) {
            array_set($smartyVariables, "contact.client", $whmcsClient->client->markAllColumnsVisible()->toArray());
        }
        if(\mgCRM2\Models\Validators\Common::isPositiveNumber($template) && $template != "false") {
            $mailer = mgCRM_getMailerInstance();
            $additional = ["resource_id" => $resource->id, "is_global_config" => $isGlobalConfig, "department_id" => $department->id, "subject" => $subject, "content" => $content, "cc" => $cc, "bcc" => $bcc];
            $result = $mailer->sentRawEmailFromTemplate($from, $to, $template, $smartyVariables, $additional);
        } else {
            $mailer = mgCRM_getMailerInstance();
            $additional = ["resource_id" => $resource->id, "is_global_config" => $isGlobalConfig, "department_id" => $department->id, "cc" => $cc, "bcc" => $bcc];
            $result = $mailer->sentEmailFromRawData($from, $to, $subject, $content, $files, $smartyVariables, $additional);
        }
        return $result;
    }
    private function getResourceVariables($resourceID)
    {
        $resource = \mgCRM2\Models\Resource::findOrFail($resourceID);
        $whmcsClient = $resource->load("client");
        $resourceVariables = [];
        array_set($resourceVariables, "client.id", $whmcsClient->client->id);
        array_set($resourceVariables, "client.firstname", $whmcsClient->client->firstname);
        array_set($resourceVariables, "client.lastname", $whmcsClient->client->lastname);
        array_set($resourceVariables, "client.email", $whmcsClient->client->email);
        array_set($resourceVariables, "id", $resource->id);
        array_set($resourceVariables, "name", $resource->name);
        array_set($resourceVariables, "status_id", $resource->load("status")->id);
        array_set($resourceVariables, "email", $resource->email);
        array_set($resourceVariables, "phone", $resource->phone);
        array_set($resourceVariables, "piority", $resource->priority);
        array_set($resourceVariables, "type_id", $resource->load("type")->id);
        array_set($resourceVariables, "admin_id", $resource->load("admin")->id);
        array_set($resourceVariables, "ticket_id", $resource->load("ticket")->id);
        array_set($resourceVariables, "client_id", $resource->load("client")->id);
        array_set($resourceVariables, "created_at", $resource->created_at ? $resource->created_at->toDateTimeString() : "");
        array_set($resourceVariables, "deleted_at", $resource->deleted_at ? $resource->deleted_at->toDateTimeString() : "");
        array_set($resourceVariables, "status", $resource->load("status")->name);
        array_set($resourceVariables, "updated_at", $resource->updated_at ? $resource->updated_at->toDateTimeString() : "");
        return $resourceVariables;
    }
}

?>