<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Repository pattern for Campaign
 * Wrap certain actions for collection of our model or perform more complexed actions on model
 */
class Campaigns extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\Campaign";
    }
    public static function obtainAllCampaignsListForAdmin($adminID)
    {
        $campaigns = \mgCRM2\Models\Campaign::withAdmins()->get();
        $campaigns->map(function ($c) use($c) {
            return $c->markAvailableOrNotFor($adminID);
        });
        return $campaigns;
    }
    public static function obtainCampaignsForAdmin($adminID)
    {
        $campaigns = \mgCRM2\Models\Campaign::forAdmin($adminID)->activeForNow()->get()->toArray();
        foreach ($campaigns as &$c) {
            unset($c["filters"]);
        }
        return $campaigns;
    }
    public function createCampaign(array $data = [])
    {
        $parsed = ["name" => array_get($data, "name", ""), "color" => array_get($data, "color", "#000000"), "description" => array_get($data, "description", ""), "date_start" => \Carbon\Carbon::parse(array_get($data, "date_start")), "date_end" => \Carbon\Carbon::parse(array_get($data, "date_end")), "filters" => array_get($data, "filters", [])];
        if($parsed["date_end"]->getTimestamp() < $parsed["date_start"]->getTimestamp()) {
            throw new \Exception("The date is set incorrectly");
        }
        $new = new \mgCRM2\Models\Campaign($parsed);
        $new->save();
        $adminsIDs = array_get($data, "admins", []);
        if(!empty($adminsIDs)) {
            $new->admins()->attach($adminsIDs);
        }
        $resourcesIDs = $this->filterResourcesForCampaign($new->filters);
        if(!empty($resourcesIDs)) {
            $new->resources()->attach($resourcesIDs);
        }
        return $new;
    }
    public function updateCampaign($id, array $data = [])
    {
        $campaign = $this->getModel()->find($id);
        if(is_null($campaign)) {
            throw new \Exception("Campaign not found");
        }
        $parsed = ["name" => array_get($data, "name", ""), "color" => array_get($data, "color", "#000000"), "description" => array_get($data, "description", ""), "date_start" => \Carbon\Carbon::parse(array_get($data, "date_start")), "date_end" => \Carbon\Carbon::parse(array_get($data, "date_end")), "filters" => array_get($data, "filters", [])];
        if($parsed["date_end"]->getTimestamp() < $parsed["date_start"]->getTimestamp()) {
            throw new \Exception("The date is set incorrectly");
        }
        $campaign->fill($parsed);
        $campaign->save();
        $adminsIDs = array_get($data, "admins", []);
        if(!empty($adminsIDs)) {
            $campaign->admins()->sync($adminsIDs);
        }
        $resourcesIDs = $this->filterResourcesForCampaign($campaign->filters);
        if(!empty($resourcesIDs)) {
            $campaign->resources()->sync($resourcesIDs);
        }
        return $campaign;
    }
    public function deleteCampaign($id)
    {
        $found = $this->getModel()->where("id", "=", $id)->first();
        if(is_null($found)) {
            throw new \Exception(sprintf("Couldn't find Campaign #%d", $id));
        }
        return $found->delete();
    }
    public function getCampaign($id)
    {
        $campaign = $this->getModel()->find($id);
        $return = $campaign->toArray();
        if(is_null($campaign)) {
            throw new \Exception("Campaign not found");
        }
        $return["admins"] = $campaign->admins->pluck("id");
        return $return;
    }
    public function syncCampaignResourcesByFilters($id)
    {
        $campaign = $this->getModel()->find($id);
        if(is_null($campaign)) {
            throw new \Exception("Campaign not found");
        }
        $resourcesIDs = $this->filterResourcesForCampaign($campaign->filters);
        if(!empty($resourcesIDs)) {
            $campaign->resources()->sync($resourcesIDs);
        }
        return true;
    }
    public function ResourcesTableQueryByFilters(array $data = [], $showHidden = false)
    {
        return $this->filterResources($data, false);
    }
    public function filterResourcesForCampaign($data)
    {
        $parsedData = ["search" => $data];
        return $this->filterResources($parsedData, true);
    }
    public function parseSearchByFilters($data)
    {
        $filter = function ($array) {
            $return = [];
            foreach ($array as $sName => $sVal) {
                if(array_get($sVal, "enabled", false)) {
                    $sName = is_numeric($sName) ? "field_" . $sName : $sName;
                    $return[$sName] = isset($sVal["value"]) ? $sVal["value"] : "";
                }
            }
            return $return;
        };
        $return = $filter(array_get($data, "static", [])) + $filter(array_get($data, "dynamic", []));
        $return = array_filter($return);
        return $return;
    }
    public function filterResources(array $data = [], $onlyIDs = false)
    {
        $limit = array_get($data, "params.pagination.number", 10);
        $ofset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", false);
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $searchRaw = array_get($data, "search", false);
        $search = [];
        if(is_array($searchRaw) && !empty($searchRaw)) {
            $search = $this->parseSearchByFilters($searchRaw);
        }
        $whereAND = [];
        $query = \Illuminate\Database\Capsule\Manager::table("crm_resources")->groupBy("crm_resources.id")->whereNull("crm_resources.deleted_at")->leftJoin("crm_resources_statuses", function ($join) {
            $join->on("crm_resources.status_id", "=", "crm_resources_statuses.id");
        });
        $select = [];
        $select[] = \Illuminate\Database\Capsule\Manager::raw("fields.*");
        $select[] = "crm_resources.id as id";
        $select[] = "crm_resources.deleted_at";
        $select[] = "crm_resources.type_id as type_id";
        $availableSelects = ["id" => "crm_resources.id", "name" => "crm_resources.name", "status" => "crm_resources.status_id", "email" => "crm_resources.email", "phone" => "crm_resources.phone", "country" => "crm_resources.country", "priority" => "crm_resources.priority", "type_id" => "crm_resources.type_id", "created_at" => "crm_resources.created_at", "updated_at" => "crm_resources.updated_at", "admin_id" => "crm_resources.admin_id", "client_id" => "crm_resources.client_id", "status_id" => "crm_resources.status_id", "ticket_id" => "crm_resources.ticket_id"];
        foreach ($availableSelects as $staticFieldName => $inject) {
            $column = sprintf("%s AS %s", $inject, $staticFieldName);
            $select[] = \Illuminate\Database\Capsule\Manager::raw($column);
            $fieldFilter = array_get($search, $staticFieldName, false);
            if(!empty($fieldFilter)) {
                $operand = $valuePattern = NULL;
                if(in_array($staticFieldName, ["name", "email", "phone"])) {
                    $whereAND[] = [$inject, "LIKE", sprintf("%%%s%%", $fieldFilter)];
                } elseif(in_array($staticFieldName, ["status", "country", "priority", "type_id", "status_id"])) {
                    if(is_array($fieldFilter)) {
                        $tmp = [];
                        foreach ($fieldFilter as $idek) {
                            if($idek == 1 && $staticFieldName == "priority") {
                                $tmp[] = "(" . $inject . " is NULL OR " . $inject . " = '" . $idek . "' )";
                            } else {
                                $tmp[] = "(" . $inject . " = '" . $idek . "')";
                            }
                        }
                        if(!empty($tmp)) {
                            $whereAND[] = \Illuminate\Database\Capsule\Manager::raw("(" . implode(" OR ", $tmp) . ")");
                        }
                    } else {
                        $whereAND[] = [$inject, "=", sprintf("%s", $fieldFilter)];
                    }
                }
                if(!empty($fieldFilter) && $operand !== NULL && $valuePattern !== NULL) {
                    $whereAND[] = [$inject, $operand, sprintf($valuePattern, $fieldFilter)];
                }
            }
        }
        $select[] = \Illuminate\Database\Capsule\Manager::raw("fields.*");
        $fields = \mgCRM2\Models\Field::joinOptions()->get();
        $miltipleFields = [];
        $selectFields = [];
        foreach ($fields as $fieldId => $field) {
            if($field->isMultiple()) {
                $options = $field->options->toArray();
                $parsed = [];
                if(!empty($options)) {
                    array_map(function ($a) use($a) {
                        $parsed[$a["id"]] = $a["value"];
                        return true;
                    }, $options);
                }
                $miltipleFields["field_" . $field->id] = $parsed;
            }
            if($field->isMultiple()) {
                $selectFields[] = sprintf("GROUP_CONCAT( CASE WHEN crm_fields_data.field_id = %s THEN crm_fields_data_options.option_id ELSE NULL END ORDER BY crm_fields_data_options.id ASC SEPARATOR ';') AS field_%s", $field->id, $field->id);
            } else {
                $selectFields[] = sprintf("MAX(CASE WHEN crm_fields_data.field_id = %s THEN crm_fields_data.data ELSE NULL END) field_%s", $field->id, $field->id);
            }
            $fieldFilter = array_get($search, "field_" . $field->id, false);
            if(!empty($fieldFilter)) {
                $inject = $operand = $valuePattern = NULL;
                if($field->isMultiple()) {
                    $operand = "=";
                    $valuePattern = "%s";
                    $inject = \Illuminate\Database\Capsule\Manager::raw("fields.field_" . $field->id);
                    if(is_array($fieldFilter)) {
                        $tmp = [];
                        foreach ($fieldFilter as $idek) {
                            $tmp[] = "(" . $inject . " = '" . $idek . "')";
                        }
                        if(!empty($tmp)) {
                            $whereAND[] = \Illuminate\Database\Capsule\Manager::raw("(" . implode(" OR ", $tmp) . ")");
                        }
                    } else {
                        $whereAND[] = [$inject, "=", sprintf("%s", $fieldFilter)];
                    }
                } else {
                    $operand = "LIKE";
                    $valuePattern = "%%%s%%";
                    $inject = \Illuminate\Database\Capsule\Manager::raw("fields.field_" . $field->id);
                    if(!empty($fieldFilter) && $operand !== NULL && $valuePattern !== NULL && $inject !== NULL) {
                        $whereAND[] = [$inject, $operand, sprintf($valuePattern, $fieldFilter)];
                    }
                }
            }
        }
        if(!empty($selectFields)) {
            $selectFieldsQuery = implode(", \n", $selectFields);
            $query = $query->leftJoin(\Illuminate\Database\Capsule\Manager::raw("\n                        (\n                            SELECT\n                            `crm_fields_data`.`resource_id`,\n\n                            " . $selectFieldsQuery . "\n\n                            FROM `crm_fields_data`\n                            left join `crm_fields_data_options` on `crm_fields_data`.`id` = `crm_fields_data_options`.`field_data_id`\n\n                            group by `crm_fields_data`.`resource_id`\n                        ) AS fields\n                        "), function ($join) {
                $join->on("fields.resource_id", "=", "crm_resources.id");
            });
        }
        $labels = $search["labels"];
        $query->leftJoin("crm_labels_clients", "crm_labels_clients.client_id", "=", "crm_resources.id");
        $query = $query->where(function ($where) {
            foreach ($labels as $labelid) {
                $where->orWhere("crm_labels_clients.label_id", "=", $labelid);
            }
        });
        if(!empty($whereAND)) {
            $query = $query->where(function ($query) {
                foreach ($whereAND as $push) {
                    if(is_array($push)) {
                        $query->where($push[0], $push[1], $push[2]);
                    } elseif($push instanceof \Illuminate\Database\Query\Expression) {
                        $query->whereRaw($push);
                    }
                }
            });
        }
        if($onlyIDs === true) {
            return $query->select(["crm_resources.id"])->pluck("id");
        }
        $count = clone $query;
        $total = count($count->select(\Illuminate\Database\Capsule\Manager::raw("count(crm_resources.id) as total"))->pluck("total"));
        $query = $query->select($select)->take($limit)->offset($ofset);
        $data = $query->get();
        foreach ($data as $row => $rowData) {
            foreach ($rowData as $k => $v) {
                if(array_get($miltipleFields, $k, false) !== false) {
                    $ccc = [];
                    foreach (explode(";", $v) as $y) {
                        $ccc[] = array_get($miltipleFields, $k . "." . $y, NULL);
                    }
                    $data[$row]->{$k} = implode(",", $ccc);
                }
            }
        }
        $return = ["data" => $data, "total" => $total];
        return $return;
    }
    public function getCampaignListTableQuery($data)
    {
        $limit = array_get($data, "params.pagination.number", 10);
        $ofset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", "date_start");
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $name = array_get($data, "params.search.predicateObject.name", false);
        $description = array_get($data, "params.search.predicateObject.description", false);
        $search = array_get($data, "params.search.predicateObject", false);
        $searchGlobal = array_pull($search, "\$", false);
        $query = $this->getModel();
        if(!empty($name)) {
            $query = $query->whereName($name);
        }
        if(!empty($description)) {
            $query = $query->whereDescription($description);
        }
        if(!empty($searchGlobal)) {
            $query = $query->whereNameOrDescription($searchGlobal);
        }
        $total = $query->count();
        $results = $query->withResourcesCount()->withAdmins()->orderBy($orderBy, $orderDesc)->take($limit)->offset($ofset)->get();
        $return = ["data" => $results->toArray(), "total" => $total];
        return $return;
    }
    public function getCampaignsForAPI()
    {
        return $this->getModel()->withResourcesCount()->withAdmins()->get()->toArray();
    }
}

?>