<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

class Attachments extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\Attachment";
    }
    public function download($id)
    {
        $attachment = $this->getModel()->find($id)->toArray();
        if(empty($attachment)) {
            return NULL;
        }
        $fileData = file_get_contents($attachment["filename"]);
        $fileName = \mgCRM2\Helpers\AttachmentsHelper::parseFileNameToDisplay($attachment["filename"]);
        $temp_pointer = tmpfile();
        fwrite($temp_pointer, $fileData);
        fseek($temp_pointer, 0);
        $type = mime_content_type($temp_pointer);
        header("Content-Description: File Transfer");
        header("Content-Type: " . $type);
        header("Content-disposition: attachment; filename=" . $fileName);
        echo fread($temp_pointer, strlen($fileData));
        fclose($temp_pointer);
        exit;
    }
    public function deleteAllFromMailbox($id)
    {
        $attachments = $this->model->where("mailbox_id", $id)->get();
        foreach ($attachments as $attachment) {
            unlink($attachment["filename"]);
            $attachment->delete();
        }
    }
}

?>