<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models\Validators;

/**
 * Class for common validator types
 *
 * All functions are STATIC !
 * each function return BOLEAN
 */
class Common
{
    public static function isEmpty($value)
    {
        return !empty($value);
    }
    public static function isEmail($value)
    {
        return filter_var($value, FILTER_VALIDATE_EMAIL);
    }
    public static function isPositiveNumber($value)
    {
        return filter_var($value, FILTER_VALIDATE_INT, ["options" => ["min_range" => 0]]) !== false;
    }
    public static function isPositiveUnsignedNumber($value)
    {
        return filter_var($value, FILTER_VALIDATE_INT, ["options" => ["min_range" => 1]]) !== false;
    }
    public static function isNumber($value)
    {
        return filter_var($value, FILTER_VALIDATE_INT) !== false;
    }
    public static function isBolean($value)
    {
        return filter_var($value, FILTER_VALIDATE_BOOLEAN);
    }
    public static function isValidEmail($value)
    {
        if(!filter_var($value, FILTER_VALIDATE_EMAIL)) {
            return false;
        }
        return true;
    }
    public static function isValidUrl($value)
    {
        return filter_var($value, FILTER_VALIDATE_URL) !== false;
    }
    public static function isValidByRegex($value, $regex)
    {
        return preg_match($regex, $value) == 1;
    }
    public static function validMinCharacters($value, $num)
    {
        return (int) $num <= strlen($value);
    }
    public static function validMaxCharacters($value, $num)
    {
        return strlen($value) <= (int) $num;
    }
}

?>