<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

/**
 * Class Model Resource types
 */
class ResourceType extends Source\AbstractModel
{
    use Illuminate\Database\Eloquent\SoftDeletes;
    /**
     * Table name
     *
     * @var string
     */
    protected $table = "crm_resources_types";
    /**
     * Eloquent guarded parameters
     * @var array
     */
    protected $guarded = ["id"];
    /**
     * Eloquent fillable parameters
     * @var array
     */
    protected $fillable = ["name", "order", "color", "icon", "active", "show_in_nav", "show_in_submenu", "show_in_dashboard"];
    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ["deleted_at", "updated_at", "created_at"];
    /**
     * Indicates if the model should soft delete.
     *
     * @var bool
     */
    protected $softDelete = true;
    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = true;
    public function notes()
    {
        return $this->hasMany("mgCRM2\\Models\\Resource", "type_id");
    }
    public function getOrderAttribute($value)
    {
        return intval($value);
    }
    public function getActiveAttribute($value)
    {
        return filter_var($value, FILTER_VALIDATE_BOOLEAN);
    }
    public function getShowInNavAttribute($value)
    {
        return filter_var($value, FILTER_VALIDATE_BOOLEAN);
    }
    public function getShowInSubmenuAttribute($value)
    {
        return filter_var($value, FILTER_VALIDATE_BOOLEAN);
    }
    public function getShowInDashboardAttribute($value)
    {
        return filter_var($value, FILTER_VALIDATE_BOOLEAN);
    }
    public function updateSingleParam($data)
    {
        if(count($data) == 0 || empty($data)) {
            throw new \Exception("nothing to update");
        }
        foreach ($data as $param => $value) {
            $this->{$param} = $value;
        }
        if($this->save()) {
            return true;
        }
        return false;
    }
    public function isVisibleInNavbar()
    {
        return $this->show_in_nav === true;
    }
    public function isVisibleInNavbarSubmenu()
    {
        return $this->show_in_submenu === true;
    }
    public function isVisibleInDashboard()
    {
        return $this->show_in_dashboard === true;
    }
    public function isActive()
    {
        return $this->active === true && !$this->deleted_at;
    }
    public function scopeOrderred($query)
    {
        return $query->orderBy("order", "ASC");
    }
    public function scopeOnlyActive($query)
    {
        return $query->where("active", "=", "1");
    }
    public function toNavigationArray()
    {
        return ["id" => $this->id, "name" => $this->name, "color" => $this->color, "icon" => $this->icon];
    }
    public function toRoutingArray()
    {
        return ["id" => $this->id, "name" => $this->name, "color" => $this->color, "icon" => $this->icon, "dashboard" => $this->isVisibleInDashboard(), "active" => $this->isActive()];
    }
}

?>