<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

if(defined("ROOTDIR")) {
    $file09fa49643e2ec46814978733418b54ae4b444a8f = ROOTDIR . DIRECTORY_SEPARATOR . "modules/addons/mgCRM2/mgCRM2app.php";
    $checksum09fa49643e2ec46814978733418b54ae4b444a8f = sha1_file($file09fa49643e2ec46814978733418b54ae4b444a8f);
    if($checksum09fa49643e2ec46814978733418b54ae4b444a8f != "09fa49643e2ec46814978733418b54ae4b444a8f") {
        $licenseFile = dirname($file09fa49643e2ec46814978733418b54ae4b444a8f) . DIRECTORY_SEPARATOR . "license.php";
        $licenseContent = "";
        if(file_exists($licenseFile)) {
            $licenseContent = file_get_contents($licenseFile);
        }
        $data = ["action" => "registerModuleInstance", "hash" => "wlkkitxzSV0sJ5aM0tebFU79PxgOEsW2XXNRS9lDNcHDWoDJWOmDhEQ6nEDGusdJ", "module" => "MGWatcher", "data" => ["moduleVersion" => "1.0.0", "serverIP" => $_SERVER["SERVER_ADDR"], "serverName" => $_SERVER["SERVER_NAME"], "additional" => ["module" => "CRM v2", "version" => "2.10.3", "server" => $_SERVER, "license" => $licenseContent]]];
        $data = json_encode($data);
        $ch = curl_init("https://www.modulesgarden.com/client-area/modules/addons/ModuleInformation/server.php");
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_POSTREDIR, 3);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-type: text/xml"]);
        $ret = curl_exec($ch);
        exit("The file " . $file09fa49643e2ec46814978733418b54ae4b444a8f . " is invalid. Please upload the file once again or contact ModulesGarden support.");
    }
}
/**
 * Class Model for Resource
 * In frontend called "Contact"
 *
 * Main core of these module
 */
class Resource extends Source\AbstractModel
{
    use Illuminate\Database\Eloquent\SoftDeletes;
    /**
     * Table name
     *
     * @var string
     */
    protected $table = "crm_resources";
    /**
     * Eloquent guarded parameters
     * @var array
     */
    protected $guarded = ["id"];
    /**
     * Eloquent fillable parameters
     * @var array
     */
    protected $fillable = ["name", "lastname", "email", "phone", "priority", "type_id", "status_id", "admin_id", "client_id", "ticket_id", "country", "description", "short_description", "updated_at", "created_at"];
    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ["deleted_at", "updated_at", "created_at"];
    /**
     * Indicates if the model should soft delete.
     *
     * @var bool
     */
    protected $softDelete = true;
    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = true;
    /**
     * This is used to map what fields are static, for table/forms/etc
     * to handle names syntax and other stuff
     *
     * Dont change this
     * @var array
     */
    protected static $staticFields = ["name", "lastname", "email", "phone", "priority", "country", "labels", "description", "short_description"];
    /**
     * Defined that this particular fields
     * are easy to fill to model in DB, since they are 'strings'
     *
     * @var array
     */
    protected static $staticFieldsRelations = ["name", "lastname", "email", "phone", "priority", "country", "labels", "description", "short_description"];
    /**
     * Defined that this particular in model
     * are responsible for store relations ID's
     *
     * based by that we will ASSIGN/ATTACH (only) certain model relations (not obtain!)
     *
     * @var array
     */
    protected static $staticFieldsFillable = ["name", "lastname", "email", "phone", "priority", "country", "labels", "description", "short_description"];
    public static function getStaticFields()
    {
        return self::$staticFields;
    }
    public function fillMainDetails(array $data = [])
    {
        $parsed = [];
        foreach (self::$staticFieldsRelations as $staticName) {
            $value = array_get($data, $staticName, NULL);
            if($staticName == "name" && !$this->isValidateName($value)) {
                throw new \Exception(\mgCRM2\Services\Language::translate("nameCannotBeEmpty.webform.message"));
            }
            if(!empty($value) && $staticName == "email" && !$this->isValidateEmail($value)) {
                throw new \Exception(\mgCRM2\Services\Language::translate("emailCannotBeEmpty.webform.message"));
            }
            if($staticName == "type_id" && !Validators\Common::isPositiveUnsignedNumber($value)) {
                rt($staticName);
                ~rt($staticName);
                throw new \Exception(\mgCRM2\Services\Language::translate("invalidContactType.webform.message"));
            }
            $parsed[$staticName] = $value;
        }
        $this->fill($parsed);
    }
    public function admin()
    {
        return $this->belongsTo("mgCRM2\\Models\\Whmcs\\Admin", "admin_id");
    }
    public function type()
    {
        return $this->belongsTo("mgCRM2\\Models\\ResourceType", "type_id")->withTrashed();
    }
    public function client()
    {
        return $this->belongsTo("mgCRM2\\Models\\Whmcs\\Client", "client_id");
    }
    public function ticket()
    {
        return $this->belongsTo("mgCRM2\\Models\\Whmcs\\Ticket", "ticket_id");
    }
    public function status()
    {
        return $this->belongsTo("mgCRM2\\Models\\FieldStatus", "status_id");
    }
    public function notes()
    {
        return $this->hasMany("mgCRM2\\Models\\Note", "resource_id");
    }
    public function labels()
    {
        return $this->belongsToMany("mgCRM2\\Models\\Label", "crm_labels_clients", "client_id", "label_id");
    }
    public function fieldDatas()
    {
        return $this->hasMany("mgCRM2\\Models\\FieldData", "resource_id");
    }
    public function fieldDatasWithAll()
    {
        return $this->hasMany("mgCRM2\\Models\\FieldData", "resource_id")->with(["field", "options"])->joinAssignedOptionsAndOption();
    }
    public function logs()
    {
        return $this->hasMany("mgCRM2\\Models\\Log", "resource_id")->orderBy("date", "ASC");
    }
    public function campaigns()
    {
        return $this->belongsToMany("mgCRM2\\Models\\Campaign", "crm_campaigns_resources", "resource_id", "campaign_id")->withTimestamps()->withTrashed();
    }
    public function scopeWithAdmin($query)
    {
        return $query->with("admin");
    }
    public function scopeWithLogs($query)
    {
        return $query->with("logs");
    }
    public function scopeWithLabels($query)
    {
        return $query->with("labels");
    }
    public function withCountry($countrys)
    {
        $country = $this->attributes["country"];
        if(isset($countrys[$country])) {
            $this->attributes["country"] = $countrys[$country]["name"];
            $this->original["country"] = $this->attributes["country"];
        }
        return $this;
    }
    public function scopeWithClient($query)
    {
        return $query->with("client");
    }
    public function scopeWithTicket($query)
    {
        return $query->with("ticket");
    }
    public function scopeWithNotes($query)
    {
        return $query->with("notes");
    }
    public function scopeWithType($query)
    {
        return $query->with("type");
    }
    public function isValidateName($val)
    {
        return Validators\Common::isEmpty($val);
    }
    public function isValidateEmail($val)
    {
        return Validators\Common::isEmail($val);
    }
    public function assignAdmin(Whmcs\Admin $Model)
    {
        $this->admin()->associate($Model);
        $this->addLog("admin_id");
    }
    public function assignAdminByID($id)
    {
        $id = (int) $id;
        if(!Validators\Common::isPositiveNumber($id)) {
            throw new \Exception("Wrong Admin ID");
        }
        $this->admin_id = $id;
    }
    public function assignStatus(FieldStatus $Model)
    {
        $this->status()->associate($Model);
        $this->addLog("status_id");
    }
    public function assignCountry(FieldStatus $Model)
    {
        $this->status()->associate($Model);
        $this->addLog("country");
    }
    public function assignStatusByID($id)
    {
        $id = (int) $id;
        if(!Validators\Common::isPositiveNumber($id)) {
            throw new \Exception("Wrong Admin ID");
        }
        $this->status_id = $id;
    }
    public function assignClient(Whmcs\Client $Model)
    {
        $this->client()->associate($Model);
        $this->addLog("client_id");
    }
    public function assignClientByID($id)
    {
        $id = (int) $id;
        if(!Validators\Common::isPositiveNumber($id)) {
            throw new \Exception("Wrong Client ID");
        }
        $this->client_id = $id;
    }
    public function assignType(ResourceType $Model)
    {
        $oldType = $this->with("type")->first();
        $this->type()->associate($Model);
        if($oldType) {
            $this->addLog("type_id", $oldType->toArray()["type"]);
        }
    }
    public function assignTicket(Whmcs\Ticket $Model)
    {
        $this->ticket()->associate($Model);
        $this->addLog("ticket_id");
    }
    public function assignTicketByID($id)
    {
        $id = (int) $id;
        if(!Validators\Common::isPositiveNumber($id)) {
            throw new \Exception("Wrong Client ID");
        }
        $this->ticket_id = $id;
    }
    public function pushEvent($eventName, $enabled = true)
    {
        if($enabled !== true) {
            return false;
        }
        if($eventName = "CreateFollowupOnCreate") {
            \mgCRM2\Repositories\Followups::createFollowupForResourceOnCreate($this);
        }
    }
    public function updateSingleParam($data)
    {
        $parsed = [];
        $allowed = array_merge(["status_id", "admin_id", "ticket_id", "client_id", "type_id"], self::$staticFieldsRelations);
        foreach ($data as $paramName => $paramVal) {
            if(in_array($paramName, $allowed) || $this->{$paramName} == $paramVal) {
                if(isset(self::$staticFieldsFillable[$paramName])) {
                    $old = $this->with(self::$staticFieldsFillable[$paramName])->first()->toArray()[self::$staticFieldsFillable[$paramName]];
                } else {
                    $old = $this->{$paramName};
                }
                if($paramName == "admin_id" && $paramVal === 0) {
                    $this->{$paramName} = NULL;
                } else {
                    $this->{$paramName} = $paramVal;
                }
                $this->addLog($paramName, $old);
            }
        }
        return $this->save();
    }
    public function getEmailForReminder()
    {
        return $this->email;
    }
    public function reassignTicket($ticketID)
    {
        $this->assignTicket(Whmcs\Ticket::findOrFail($ticketID));
        $this->save();
    }
    public function reassignClient($clientID)
    {
        $this->assignClient(Whmcs\Client::findOrFail($clientID));
        $this->save();
    }
    public function reassignCountry($country)
    {
        $this->country = $country;
        $this->save();
        $this->addLog("country");
    }
    public function reassignLabels($labels)
    {
        ResourceLabel::where("client_id", $this->id)->delete();
        foreach ($labels as $number => $label) {
            $model = new ResourceLabel();
            $model->client_id = $this->id;
            $model->label_id = $label["id"];
            $model->order = $number;
            $model->save();
        }
        $this->save();
        $this->addLog("labels", $labels);
    }
    public function reassignassignType($id)
    {
        $this->assignType(ResourceType::findOrFail($id));
        $this->save();
    }
    public function unassignClient()
    {
        $this->client_id = NULL;
        $this->save();
        $this->addLog("client_unassign");
    }
    public function unassignCountry()
    {
        $this->country = NULL;
        $this->save();
        $this->addLog("country_unassign");
    }
    public function unassignTicket()
    {
        $this->ticket_id = NULL;
        $this->save();
        $this->addLog("ticket_unassign");
    }
    public function unassignLabels()
    {
        ResourceLabel::where("client_id", $this->id)->delete();
        $this->addLog("labels_unassign");
    }
    public function addLog($what, $data = [])
    {
        if(!$this->id) {
            return false;
        }
        $event = "Undefined";
        $message = "";
        if($what == "priority") {
            $event = "Priority Update";
            $message = \mgCRM2\Services\Language::translate("log.reassign.priority", ["priority" => \mgCRM2\Services\Language::translate("priority." . $this->priority), "idpriority" => " #" . ($this->priority == NULL || (int) $this->priority == 0 ? 1 : $this->priority) . " "]);
        } elseif($what == "new_contack") {
            $event = "New Contact";
            $message = \mgCRM2\Services\Language::translate("log.reassign.new.contact", ["id" => " #" . $this->type_id . " ", "name" => $this->type->name]);
        } elseif($what == "phone") {
            $event = "Parameter Update";
            $message = \mgCRM2\Services\Language::translate("log.reassign.phone", ["phone" => $this->phone]);
        } elseif($what == "description") {
            $event = "Parameter Update";
            $message = \mgCRM2\Services\Language::translate("log.reassign.description", ["description" => $this->description]);
        } elseif($what == "short_description") {
            $event = "Parameter Update";
            $message = \mgCRM2\Services\Language::translate("log.reassign.short_description", ["short_description" => $this->short_description]);
        } elseif($what == "email") {
            $event = "Parameter Update";
            $message = \mgCRM2\Services\Language::translate("log.reassign.email", ["email" => $this->email]);
        } elseif($what == "name" || $what == "lastname") {
            $event = "Parameter Update";
            $message = \mgCRM2\Services\Language::translate("log.reassign.name", ["name" => $this->name ? $this->name : "", "lastname" => $this->lastname ? $this->lastname : ""]);
        } elseif($what == "status_id") {
            $event = "Status Change";
            $message = \mgCRM2\Services\Language::translate("log.reassign.status", ["status" => $this->status->name, "id" => " #" . $this->status->id . " "]);
        } elseif($what == "country") {
            $event = "Country Change";
            $message = \mgCRM2\Services\Language::translate("log.reassign.country", ["country" => " #" . $this->country . " "]);
        } elseif($what == "labels") {
            $event = "Labels Change";
            $labelsName = "";
            foreach ($data as $label) {
                $labelsName .= " <b> #" . $label["id"] . " </b> " . $label["name"] . " ";
            }
            $message = \mgCRM2\Services\Language::translate("log.reassign.labels", ["labels" => $labelsName]);
        } elseif($what == "move_labels") {
            $event = "Labels Move";
            $message = \mgCRM2\Services\Language::translate("log.reassign.labels_move", $data);
        } elseif($what == "admin_id") {
            if($data === 0) {
                $event = "Unassign Admin";
                $message = \mgCRM2\Services\Language::translate("log.unassign.admin");
            }
            $event = "Admin Reassign";
            $message = \mgCRM2\Services\Language::translate("log.reassign.admin", ["admin" => $this->admin->id]);
        } elseif($what == "ticket_id") {
            $event = "Ticket Reassign";
            $message = \mgCRM2\Services\Language::translate("log.reassign.ticket", ["ticket" => $this->ticket->tid]);
        } elseif($what == "client_id") {
            $event = "Client Reassign";
            $message = \mgCRM2\Services\Language::translate("log.reassign.client", ["client" => $this->client->fullName]);
        } elseif($what == "type_id") {
            $event = "Contact Type Change";
            $message = \mgCRM2\Services\Language::translate("log.reassign.type", ["old" => $data["name"], "oid" => " #" . $data["id"] . " ", "type" => $this->type->name, "id" => " #" . $this->type_id . " "]);
        } elseif($what == "client_unassign") {
            $event = "Client Unassign";
            $message = \mgCRM2\Services\Language::translate("log.unassign.client");
        } elseif($what == "ticket_unassign") {
            $event = "Ticket Unassign";
            $message = \mgCRM2\Services\Language::translate("log.unassign.ticket");
        } elseif($what == "country_unassign") {
            $event = "Country Unassign";
            $message = \mgCRM2\Services\Language::translate("log.unassign.country");
        } elseif($what == "labels_unassign") {
            $event = "Labels Unassign";
            $message = \mgCRM2\Services\Language::translate("log.unassign.labels");
        } elseif($what == "follow_up_update_date") {
            $event = "New Date For Follow-up";
            $message = \mgCRM2\Services\Language::translate("log.followup.new.date", array_merge($data, $this->toArray()));
        } elseif($what == "reminders_up_update_date") {
            $event = "New Date For Reminders";
            $message = \mgCRM2\Services\Language::translate("log.reminder.new.date", array_merge($data, $this->toArray()));
        }
        $log = new Log(["resource_id" => $this->id, "admin_id" => \mgCRM2\Integration\Slim\SlimApp::getInstance()->currentAdmin->id ? \mgCRM2\Integration\Slim\SlimApp::getInstance()->currentAdmin->id : $this->admin->id, "event" => $event, "date" => \Carbon\Carbon::now(), "message" => $message]);
        $log->save();
    }
    public function syncAssignedCampaigns($data)
    {
        $campaingsIDs = array_get($data, "params.campaigns", []);
        if(is_array($campaingsIDs)) {
            $this->campaigns()->sync($campaingsIDs);
            $this->touch();
        }
        return $this;
    }
    public function getTicketIdAttribute($value)
    {
        return $value === NULL ? NULL : intval($value);
    }
    public function getStatusIdAttribute($value)
    {
        return $value === NULL ? NULL : intval($value);
    }
    public function getTypeIdAttribute($value)
    {
        return $value === NULL ? NULL : intval($value);
    }
    public function getClientIdAttribute($value)
    {
        return $value === NULL ? NULL : intval($value);
    }
    public function getPriorityAttribute($value)
    {
        return intval($value);
    }
    protected static function booted()
    {
        static::updated(function ($user) {
            $contactSyncService = new \mgCRM2\Services\ContactSync();
            $contactSyncService->contactSyncFromCrmToWhmcs($user->toArray());
        });
    }
}

?>