<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

/**
 * Class Model for Campaign
 */
class Notification extends Source\AbstractModel
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = "crm_notifications";
    /**
     * Eloquent guarded parameters
     * @var array
     */
    protected $guarded = ["id"];
    /**
     * Eloquent fillable parameters
     * @var array
     */
    protected $fillable = ["class", "type", "content", "confirmation", "hide_after_confirm", "date_start", "date_end"];
    /**
     * Eloquent additional parameters that will be recieved
     * @var array
     */
    protected $appends = ["active"];
    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ["date_start", "date_end"];
    /**
     * Indicates if the model should soft delete.
     *
     * @var bool
     */
    protected $softDelete = false;
    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = true;
    public function admins()
    {
        return $this->belongsToMany("mgCRM2\\Models\\Whmcs\\Admin", "crm_notifications_admins", "notification_id", "admin_id")->withPivot("accepted_at")->withTimestamps();
    }
    public function scopeWithAdmins($query)
    {
        return $query->with("admins");
    }
    public function scopeWhereContent($query, $str)
    {
        return $query->where("content", "like", "%" . $str . "%");
    }
    public function getActiveAttribute($value)
    {
        if($this->type == "permanent") {
            return true;
        }
        return \Carbon\Carbon::now()->between(\Carbon\Carbon::parse($this->attributes["date_start"]), \Carbon\Carbon::parse($this->attributes["date_end"]));
    }
    public function scopeForAdmin($query, $id)
    {
        return $query->whereHas("admins", function ($query) use($query) {
            $query->where("tbladmins.id", "=", $id);
        });
    }
    public function scopeActiveForNow($query)
    {
        return $query->where("date_start", "<=", \Carbon\Carbon::now())->where("date_end", ">=", \Carbon\Carbon::now());
    }
    public function getDateStartAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->toDateString();
    }
    public function getDateEndAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->toDateString();
    }
    public function getAdminWhoAcceptted()
    {
        $return = [];
        foreach ($this->admins as $a) {
            if(!is_null($a->pivot->accepted_at)) {
                $return[] = $a->toArray();
            }
        }
        return $return;
    }
    public function getConfirmationAttribute($value)
    {
        return filter_var($value, FILTER_VALIDATE_BOOLEAN);
    }
    public function getHideAfterConfirmAttribute($value)
    {
        return filter_var($value, FILTER_VALIDATE_BOOLEAN);
    }
}

?>