<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

/**
 * Class For Mass Mail Config records
 */
class MassMessageConfig extends Source\AbstractModel
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = "crm_mass_message_configs";
    /**
     * Eloquent guarded parameters
     * @var array
     */
    protected $guarded = ["id"];
    /**
     * Eloquent fillable parameters
     * @var array
     */
    protected $fillable = ["description", "message_content", "message_title", "message_type", "target_ids", "target_type", "generated", "total", "date", "mailbox_id"];
    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ["deleted_at", "updated_at", "created_at", "date"];
    /**
     * Indicates if the model should soft delete.
     *
     * @var bool
     */
    protected $softDelete = false;
    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = true;
    /**
     * Basically possible messages types for validation
     * as protection layer
     *
     * @var type
     */
    protected static $allowedMessageTypes = ["users", "usergroups", "campaigns"];
    /**
     * Basically possible messages types for validation
     * as protection layer
     *
     * @var type
     */
    protected static $allowedTargetTypes = ["users", "usergroups", "campaigns"];
    public function mailbox()
    {
        return $this->belongsTo("mgCRM2\\Models\\Mailbox", "mailbox_id", "id");
    }
    public function getGeneratedAttribute($value)
    {
        return filter_var($value, FILTER_VALIDATE_BOOLEAN);
    }
    public function getTotalAttribute($value)
    {
        return intval($value);
    }
    public function getTargetIdsAttribute($value)
    {
        return json_decode($value, true);
    }
    public function setTargetIdsAttribute($value)
    {
        if(empty($value) || !is_array($value) || is_null($value)) {
            $toSave = [];
        } else {
            $toSave = array_filter($value);
        }
        $this->attributes["target_ids"] = json_encode($toSave, true);
    }
    public function setMessageTypeAttribute($value)
    {
        if(!in_array($value, self::$allowedMessageTypes)) {
            throw new \Exception("Invalid Message Type");
        }
        $this->attributes["message_type"] = $value;
    }
    public function setTargetTypeAttribute($value)
    {
        if(!in_array($value, self::$allowedTargetTypes)) {
            throw new \Exception("Invalid Message Type");
        }
        $this->attributes["target_type"] = $value;
    }
    public function messages()
    {
        return $this->hasMany("mgCRM2\\Models\\MassMessagePending", "mass_message_config_id");
    }
    public function getDateAttribute($value)
    {
        $date = \Carbon\Carbon::parse($value);
        return $date->toDateString() . " " . $date->hour . ":" . $date->minute;
    }
    public function scopeWithMessagesCount($query)
    {
        return $query->leftJoin("crm_mass_message_pendings", "crm_mass_message_pendings.mass_message_config_id", "=", "crm_mass_message_configs.id")->addSelect(\Illuminate\Database\Capsule\Manager::raw("crm_mass_message_configs.*, count(crm_mass_message_pendings.id) as messages_count"))->groupBy("crm_mass_message_configs.id");
    }
    public function getMessagesCountAttribute()
    {
        return isset($this->attributes["messages_count"]) ? (int) $this->attributes["messages_count"] : 0;
    }
    public function scopeWhereDescription($query, $str)
    {
        return $query->where("crm_mass_message_configs.description", "like", "%" . $str . "%");
    }
    public function scopeWhereMessageTitle($query, $str)
    {
        return $query->where("crm_mass_message_configs.message_title", "like", "%" . $str . "%");
    }
    public function scopeWhereMessageContent($query, $str)
    {
        return $query->where("crm_mass_message_configs.message_content", "like", "%" . $str . "%");
    }
    public function scopeWhereMessageEmailType($query)
    {
        return $query->where("crm_mass_message_configs.message_type", "=", "email");
    }
    public function scopeWhereMessageSmsType($query)
    {
        return $query->where("crm_mass_message_configs.message_type", "=", "sms");
    }
    public function scopeWhereTargetUsers($query)
    {
        return $query->where("crm_mass_message_configs.target_type", "=", "users");
    }
    public function scopeWhereTargetUserGroups($query)
    {
        return $query->where("crm_mass_message_configs.target_type", "=", "usergroups");
    }
    public function scopeWhereTargetCampaigns($query)
    {
        return $query->where("crm_mass_message_configs.target_type", "=", "campaigns");
    }
    public function scopeWhereAlreadyGenerated($query)
    {
        return $query->where("crm_mass_message_configs.generated", "=", "1");
    }
    public function scopeWhereNotGenerated($query)
    {
        return $query->where("crm_mass_message_configs.generated", "=", "0");
    }
    public function scopeAfterDate($query)
    {
        return $query->where("crm_mass_message_configs.date", "<=", \Carbon\Carbon::now());
    }
    public function generatePendingMessages()
    {
        if($this->target_type == "usergroups") {
            $relObjects = \Illuminate\Database\Capsule\Manager::table("tblclients")->where("status", "=", "Active")->whereIn("groupid", $this->target_ids)->pluck("id");
            $relType = "client_id";
        } elseif($this->target_type == "users") {
            $relObjects = \Illuminate\Database\Capsule\Manager::table("tblclients")->where("status", "=", "Active")->pluck("id");
            $relType = "client_id";
        } elseif($this->target_type == "campaigns") {
            $relType = "resource_id";
            $relObjects = \Illuminate\Database\Capsule\Manager::table("crm_campaigns")->select(["crm_campaigns_resources.campaign_id", "crm_campaigns_resources.resource_id"])->whereIn("crm_campaigns.id", $this->target_ids)->whereNull("crm_campaigns_resources.deleted_at")->whereNull("crm_campaigns.deleted_at")->leftJoin("crm_campaigns_resources", function ($join) {
                $join->on("crm_campaigns.id", "=", "crm_campaigns_resources.campaign_id");
            })->pluck("resource_id");
        }
        \mgCRM2\Integration\Slim\SlimApp::getInstance()->log->notice("CRON: Generating Messages for #{id} that will generate {num} records to send", ["id" => $this->id, "num" => count($relObjects)]);
        if(0 < count($relObjects)) {
            $message = $this->generateSingleMessageArrayData();
            $messagesArray = [];
            foreach ($relObjects as $relID) {
                $messagesArray[] = new MassMessagePending(array_merge($message, [$relType => $relID]));
            }
            $this->messages()->saveMany($messagesArray);
        }
        $this->generated = true;
        $this->total = count($relObjects);
        $this->save();
        \mgCRM2\Integration\Slim\SlimApp::getInstance()->log->notice("CRON: Marked Mass Messages Configuration #{id} as generated", ["id" => $this->id]);
        return $this;
    }
    public function generateSingleMessageArrayData()
    {
        return ["message_content" => $this->message_content, "message_title" => $this->message_title, "message_type" => $this->message_type];
    }
}

?>