<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

/**
 * Description of Mailbox
 *
 * @author inbs
 */
class MailboxRead extends Source\AbstractModel
{
    use Illuminate\Database\Eloquent\SoftDeletes;
    public $timestamps = false;
    protected $table = "crm_mail_read";
    protected $fillable = ["resource_id", "mail_configuration_id", "email", "from_email", "mail_id", "title", "content", "date", "reply_to"];
    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ["date"];
    /**
     * Indicates if the model should soft delete.
     *
     * @var bool
     */
    protected $softDelete = true;
    public function resource()
    {
        return $this->belongsTo("mgCRM2\\Models\\Resource", "resource_id")->withTrashed();
    }
    public function mailbox()
    {
        return $this->belongsTo("mgCRM2\\Models\\Mailbox", "mail_configuration_id")->with("admin");
    }
    public function scopeWhereMailId($query, $id)
    {
        return $query->where("mail_id", "LIKE", $id);
    }
    public function scopeSearchGlobal($query, $str)
    {
        return $query->where(function ($query) use($query) {
            return $query->orWhere("email", "like", "%" . $str . "%")->orWhere("title", "like", "%" . $str . "%")->orWhere("from_email", "like", "%" . $str . "%")->orWhere("content", "like", "%" . $str . "%");
        });
    }
    public function scopeWithResource($query, $id)
    {
        return $query->where("resource_id", "=", $id);
    }
}

?>