<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

/**
 * Description of Mailbox
 *
 * @author inbs
 */
class Mailbox extends Source\AbstractModel
{
    public $timestamps = false;
    protected $table = "crm_mail_configuration";
    protected $fillable = ["name", "description", "email", "MailEncoding", "SMTPHost", "SMTPPort", "SMTPUsername", "SMTPPassword", "SMTPSSL", "admin_id", "receive_method", "receive_port", "receive_folder", "receive_ssl", "receive_server"];
    public function admin()
    {
        return $this->belongsTo("mgCRM2\\Models\\Whmcs\\Admin", "admin_id");
    }
    public function scopeJoinAdminRelevant($query)
    {
        return $query->with(["admin" => function ($query) {
            $query->select("id", "firstname", "lastname", "email");
        }]);
    }
    public function scopeWhereAdminId($query, $id = NULL)
    {
        return $query->where("admin_id", "=", $id);
    }
    public function scopeFilterIrrelevantParams($query, $admin_id = NULL)
    {
        $query = $query->select([$this->primaryKey, "name", "description", "email", \Illuminate\Database\Capsule\Manager::raw("CONCAT( name, ' (mailbox)'  ) as full"), \Illuminate\Database\Capsule\Manager::raw("CONCAT( name, ' (', email, ')') as fullemail")]);
        if($admin_id) {
            $query->where("admin_id", "LIKE", $admin_id);
        }
        return $query;
    }
    public function getReceiveSslAttribute($value)
    {
        return unserialize($value);
    }
    public function setReceiveSslAttribute($value)
    {
        $this->attributes["receive_ssl"] = serialize($value);
        return $this;
    }
    public function scopeSearchGlobal($query, $str)
    {
        return $query->where(function ($query) use($query) {
            return $query->orWhere("name", "like", "%" . $str . "%")->orWhere("email", "like", "%" . $str . "%")->orWhere("description", "like", "%" . $str . "%");
        });
    }
}

?>