<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

class FollowupType extends Source\AbstractModel
{
    public $timestamps = false;
    protected $table = "crm_followup_types";
    protected $guarded = ["id"];
    protected $fillable = ["name", "color", "order", "active"];
    public function followups()
    {
        return $this->hasMany("mgCRM2\\Models\\Followup", "type_id");
    }
    public function updateSingleParam($data)
    {
        if(count($data) == 0 || empty($data)) {
            throw new \Exception("nothing to update");
        }
        foreach ($data as $param => $value) {
            $this->{$param} = $value;
        }
        if($this->save()) {
            return true;
        }
        return false;
    }
    public function delete()
    {
        $count = $this->followups()->count();
        if(0 < $count) {
            throw new \Exception("You can't delete group that have " . $count . " Records(s) assigned to this type.");
        }
        return parent::delete();
    }
    public function scopeActiveGroups($query)
    {
        return $query->where("active", "=", 1);
    }
    public function scopeJoinFollowups($query)
    {
        return $query->with("followups");
    }
    public function scopeOrderred($query)
    {
        return $query->orderBy("order", "asc");
    }
    public function getOrderAttribute($value)
    {
        return intval($value);
    }
    public function getActiveAttribute($value)
    {
        return filter_var($value, FILTER_VALIDATE_BOOLEAN);
    }
}

?>