<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

/**
 * Class Model for lead/potential
 */
class File extends Source\AbstractModel
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = "crm_resources_files";
    /**
     * Eloquent guarded parameters
     * @var array
     */
    protected $guarded = ["id"];
    /**
     * Eloquent fillable parameters
     * @var array
     */
    protected $fillable = ["resource_id", "admin_id", "file_name", "path_name", "description"];
    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ["created_at"];
    /**
     * Indicates if the model should soft delete.
     *
     * @var bool
     */
    protected $softDelete = false;
    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = true;
    public function admin()
    {
        return $this->belongsTo("mgCRM2\\Models\\Whmcs\\Admin", "admin_id");
    }
    public function scopeWithAdmin($query)
    {
        return $query->with(["admin" => function ($query) {
            $query->select("id", "roleid", "username", "firstname", "lastname", "email");
        }]);
    }
    public function assignAdmin(Whmcs\Admin $Model)
    {
        $this->admin()->associate($Model);
    }
    public function assignAdminByID($id)
    {
        $id = (int) $id;
        if(!Validators\Common::isPositiveNumber($id)) {
            throw new \Exception("Wrong Admin ID");
        }
        $this->admin_id = $id;
    }
    public function resource()
    {
        return $this->belongsTo("mgCRM2\\Models\\Resource", "resource_id")->withTrashed();
    }
    public function scopeResource($query)
    {
        return $query->with("resource");
    }
    public function assignResource(Resource $Model)
    {
        $this->resource()->associate($Model);
    }
    public function assignResourceByID($id)
    {
        $id = (int) $id;
        if(!Validators\Common::isPositiveNumber($id)) {
            throw new \Exception("Wrong Admin ID");
        }
        $this->resource_id = $id;
    }
    public function scopeWithDescriptionOrName($query, $str = "")
    {
        return $query->where("description", "LIKE", "%" . $str . "%")->orWhere("file_name", "LIKE", "%" . $str . "%");
    }
    public function scopeWhereResource($query, $id)
    {
        return $query->where("resource_id", "=", $id);
    }
    public function scopeWhereAdmin($query, $id)
    {
        return $query->where("admin_id", "=", $id);
    }
    public function scopeJoinAdminRelevant($query)
    {
        return $query->with(["admin" => function ($query) {
            $query->select("id", "firstname", "lastname", "email");
        }]);
    }
    public function getfileFullPathAttribute()
    {
        $mainPath = \mgCRM2\Integration\Slim\SlimApp::getInstance()->config("storage.path");
        $filesDir = \mgCRM2\Integration\Slim\SlimApp::getInstance()->config("storage.files");
        return $mainPath . "/" . $filesDir . "/" . $this->resource_id . "/" . $this->path_name;
    }
    public function getfileSizeAttribute()
    {
        if($this->verifyFile()) {
            return size_format(filesize($this->fileFullPath));
        }
        return NULL;
    }
    public function getfileSizeWithoutFormatAttribute()
    {
        if($this->verifyFile()) {
            return filesize($this->fileFullPath);
        }
        return NULL;
    }
    public function verifyFile()
    {
        if(file_exists($this->fileFullPath)) {
            return true;
        }
        $this->dropFile();
        return false;
    }
    public function dropFile()
    {
        unlink($this->fileFullPath);
        return $this->forceDelete();
    }
}

?>