<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

class FieldStatus extends Source\AbstractModel
{
    public $timestamps = false;
    protected $table = "crm_resources_statuses";
    protected $guarded = ["id"];
    protected $fillable = ["name", "color", "order", "active"];
    public function resources()
    {
        return $this->hasMany("mgCRM2\\Models\\Resource", "status_id")->withTrashed();
    }
    public function scopeWithActive($query)
    {
        return $query->where("active", "=", 1);
    }
    public function getOrderAttribute($value)
    {
        return intval($value);
    }
    public function getActiveAttribute($value)
    {
        return filter_var($value, FILTER_VALIDATE_BOOLEAN);
    }
    public function resourcesCount()
    {
        return $this->hasOne("mgCRM2\\Models\\Resource", "status_id")->selectRaw("status_id, count(*) as aggregate")->groupBy("status_id");
    }
    public function getResourcesCountAttribute()
    {
        if(!array_key_exists("resourcesCount", $this->relations)) {
            $this->load("resourcesCount");
        }
        $related = $this->getRelation("resourcesCount");
        return $related ? (int) $related->aggregate : 0;
    }
    public function countRecordsForAdmin($adminID)
    {
        $query = \Illuminate\Database\Capsule\Manager::table("crm_resources")->select(\Illuminate\Database\Capsule\Manager::raw("count(crm_resources.id) as total"))->where("crm_resources.status_id", "=", $this->id);
        if(Validators\Common::isPositiveNumber($adminID) && $adminID != 0) {
            $query = $query->where("crm_resources.admin_id", "=", $adminID);
        }
        $return = $query->pluck("total");
        return intval($return[0]);
    }
    public function safeDelete()
    {
        $count = $this->resources()->count();
        if(0 < $count) {
            throw new \Exception(sprintf("Cannot delete, since this status is assigned to %s element(s).", $count));
        }
        return $this->forceDelete();
    }
    public function countRecordsFor($type_id, $adminID, $campaignID = NULL)
    {
        $alc = \mgCRM2\Services\ACL::getInstance();
        $alcRules = $alc->getRules();
        $type_name = [];
        foreach ($alcRules["leads"] as $key => $value) {
            if($alc->hasAccess("leads." . $key)) {
                $type_name[] = (string) $key;
            }
        }
        $query = \Illuminate\Database\Capsule\Manager::table("crm_resources")->leftJoin("crm_resources_types", "crm_resources.type_id", "=", "crm_resources_types.id")->select(\Illuminate\Database\Capsule\Manager::raw("count(crm_resources.id) as total"))->whereNull("crm_resources.deleted_at")->where("crm_resources.status_id", "=", $this->id)->whereIn(\Illuminate\Database\Capsule\Manager::raw("REPLACE(LOWER(`crm_resources_types`.`name`),' ','_')"), $type_name);
        if(Validators\Common::isPositiveUnsignedNumber($type_id)) {
            $query = $query->where("crm_resources.type_id", "=", $type_id);
        }
        if(Validators\Common::isPositiveUnsignedNumber($adminID)) {
            $query = $query->where("crm_resources.admin_id", "=", $adminID);
        } elseif($campaignID === 0) {
            $query = $query->whereNull("crm_resources.admin_id");
        }
        if(Validators\Common::isPositiveUnsignedNumber($campaignID)) {
            $query = $query->leftJoin("crm_campaigns_resources", function ($join) use($join) {
                $join->on("crm_resources.id", "=", "crm_campaigns_resources.resource_id")->on("crm_campaigns_resources.campaign_id", "=", \Illuminate\Database\Capsule\Manager::raw($campaignID));
            });
            $query = $query->where("crm_campaigns_resources.campaign_id", "=", $campaignID);
        } elseif($campaignID === 0) {
            $query = $query->leftJoin("crm_campaigns_resources", function ($join) {
                $join->on("crm_resources.id", "=", "crm_campaigns_resources.resource_id");
            });
            $query = $query->whereNull("crm_campaigns_resources.campaign_id");
        }
        $return = $query->pluck("total");
        return intval($return[0]);
    }
}

?>