<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

class FieldGroup extends Source\AbstractModel
{
    public $timestamps = false;
    protected $table = "crm_fields_groups";
    protected $guarded = ["id"];
    protected $fillable = ["name", "color", "order", "active"];
    public function fields()
    {
        return $this->hasMany("mgCRM2\\Models\\Field", "group_id");
    }
    public function fieldsOrderred()
    {
        return $this->fields()->orderBy("order", "ASC");
    }
    public function updateSingleParam($data)
    {
        if(count($data) == 0 || empty($data)) {
            throw new \Exception("nothing to update");
        }
        foreach ($data as $param => $value) {
            $this->{$param} = $value;
        }
        if($this->save()) {
            return true;
        }
        return false;
    }
    public function delete()
    {
        $count = $this->fields()->count();
        if(0 < $count) {
            throw new \Exception("You can't delete group that have " . $count . " field(s) assigned to.");
        }
        return parent::delete();
    }
    public function scopeActiveGroups($query)
    {
        return $query->where("active", "=", 1);
    }
    public function scopeJoinActiveFields($query)
    {
        return $query->with(["fields" => function ($query) {
            $query->where("active", "=", 1)->orderBy("order", "asc");
        }]);
    }
    public function scopeJoinFieldsDataFor($query, $resourceID)
    {
        return $query->with(["fields" => function ($query) use($query) {
            $query->with(["data" => function ($query) use($query) {
                $query->withResource($resourceID);
            }]);
        }]);
    }
    public function scopeJoinValidators($query)
    {
        return $query->with("fields.validators");
    }
    public function scopeJoinOptions($query)
    {
        return $query->with("fields.options");
    }
    public function scopeOrderred($query)
    {
        return $query->orderBy("order", "asc");
    }
    public function getOrderAttribute($value)
    {
        return intval($value);
    }
    public function getActiveAttribute($value)
    {
        return filter_var($value, FILTER_VALIDATE_BOOLEAN);
    }
}

?>