<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

class Field extends Source\AbstractModel
{
    public $timestamps = false;
    protected $table = "crm_fields";
    protected $guarded = ["id"];
    protected $fillable = ["group_id", "type", "name", "description", "order", "active"];
    protected $possibleTypes = ["text", "textarea", "select", "radio", "date", "datetime", "checkbox", "numeric", "phone"];
    public function group()
    {
        return $this->belongsTo("mgCRM2\\Models\\FieldGroup", "group_id");
    }
    public function validators()
    {
        return $this->hasMany("mgCRM2\\Models\\FieldValidatorConfig", "field_id");
    }
    public function options()
    {
        return $this->hasMany("mgCRM2\\Models\\FieldOption", "field_id");
    }
    public function data()
    {
        return $this->hasMany("mgCRM2\\Models\\FieldData", "field_id");
    }
    public function updateSingleParam($data)
    {
        if(count($data) == 0 || empty($data)) {
            throw new Exception("nothing to update");
        }
        foreach ($data as $param => $value) {
            $this->{$param} = $value;
        }
        if($this->save()) {
            return true;
        }
        return false;
    }
    public function scopeActiveFields($query)
    {
        return $query->select("crm_fields.*")->leftJoin("crm_fields_groups", "crm_fields.group_id", "=", "crm_fields_groups.id")->where("crm_fields_groups.active", "=", 1)->where("crm_fields.active", "=", 1);
    }
    public function scopeOrderred($query)
    {
        return $query->orderBy("order", "ASC");
    }
    public function scopeWhereActive($query)
    {
        return $query->where("active", "=", 1);
    }
    public function scopeWithValidators($query)
    {
        return $query->with("validators");
    }
    public function createNewData(Resource &$resource, $data)
    {
        $fieldDataClass = FieldData::getMappedClass($this->type);
        $fieldData = new $fieldDataClass(["resource_id" => $resource->id, "field_id" => $this->id, "field_type" => $this->type]);
        $fieldData->setValidators($this->validators()->get()->toArray());
        $fieldData->setData($data);
        return $fieldData;
    }
    public function createNewDataFromMigrationData(Resource &$resource, $data)
    {
        $data = rtrim($data);
        if(empty($data)) {
            return true;
        }
        $fieldDataClass = FieldData::getMappedClass($this->type);
        $fieldData = new $fieldDataClass(["resource_id" => $resource->id, "field_id" => $this->id, "field_type" => $this->type]);
        $fieldData->setDataFromMigration($this, $data);
        return $fieldData;
    }
    public function scopeJoinGroup($query)
    {
        return $query->with("group");
    }
    public function scopeJoinValidators($query)
    {
        return $query->with("validators");
    }
    public function scopeJoinOptions($query)
    {
        return $query->with("options");
    }
    public function getGroupIdAttribute($value)
    {
        return intval($value);
    }
    public function getOrderAttribute($value)
    {
        return intval($value);
    }
    public function getActiveAttribute($value)
    {
        return filter_var($value, FILTER_VALIDATE_BOOLEAN);
    }
    public function isMultiple()
    {
        return in_array($this->type, ["select", "radio", "checkbox"]);
    }
    public function getFieldDataOrNew($fieldId, $resourceID)
    {
        $fieldData = FieldData::where("resource_id", $resourceID)->where("field_id", $fieldId)->first();
        if(is_null($fieldData)) {
            $class = FieldData::getMappedClass($this->type);
            $fieldData = new $class();
        }
        $fieldData->fill(["resource_id" => $resourceID, "field_id" => $this->id, "field_type" => $this->type]);
        return $fieldData;
    }
}

?>