<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

/**
 * Class Model for lead/potential
 */
class EmailLog extends Source\AbstractModel
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = "crm_email_logs";
    /**
     * Eloquent guarded parameters
     * @var array
     */
    protected $guarded = ["id"];
    /**
     * Eloquent fillable parameters
     * @var array
     */
    protected $fillable = ["resource_id", "followup_id", "reminder_id", "date", "subject", "message", "sender", "to", "cc", "bcc", "attachments", "template_id"];
    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ["date"];
    /**
     * Indicates if the model should soft delete.
     *
     * @var bool
     */
    protected $softDelete = false;
    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public function resource()
    {
        return $this->belongsTo("mgCRM2\\Models\\Resource", "resource_id")->withTrashed();
    }
    public function scopeResource($query)
    {
        return $query->with("resource");
    }
    public function followup()
    {
        return $this->belongsTo("mgCRM2\\Models\\Followup", "followup_id");
    }
    public function scopeWithFollowup($query)
    {
        return $query->with("followup");
    }
    public function scopeForFollowup($query, $id)
    {
        return $query->where("followup", "=", $id);
    }
    public function reminder()
    {
        return $this->belongsTo("mgCRM2\\Models\\Reminder", "reminder_id");
    }
    public function scopeWithReminder($query)
    {
        return $query->with("followup");
    }
    public function scopeWithMessage($query, $str = "")
    {
        return $query->where("message", "LIKE", "%" . $str . "%")->orWhere("date", "like", "%" . $str . "%")->orWhere("to", "like", "%" . $str . "%")->orWhere("sender", "like", "%" . $str . "%")->orWhere("subject", "like", "%" . $str . "%");
    }
    public function scopeWithResource($query, $id)
    {
        return $query->where("resource_id", "=", $id);
    }
}

?>