<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

/**
 * Class Model for Campaign
 */
class Campaign extends Source\AbstractModel
{
    use Illuminate\Database\Eloquent\SoftDeletes;
    /**
     * Table name
     *
     * @var string
     */
    protected $table = "crm_campaigns";
    /**
     * Eloquent guarded parameters
     * @var array
     */
    protected $guarded = ["id"];
    /**
     * Eloquent fillable parameters
     * @var array
     */
    protected $fillable = ["name", "description", "date_start", "date_end", "filters", "color"];
    /**
     * Eloquent additional parameters that will be recieved
     * @var array
     */
    protected $appends = ["active"];
    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ["date_start", "date_end"];
    /**
     * Indicates if the model should soft delete.
     *
     * @var bool
     */
    protected $softDelete = true;
    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = true;
    public function resources()
    {
        return $this->belongsToMany("mgCRM2\\Models\\Resource", "crm_campaigns_resources", "campaign_id", "resource_id")->withTimestamps()->withTrashed();
    }
    public function admins()
    {
        return $this->belongsToMany("mgCRM2\\Models\\Whmcs\\Admin", "crm_campaigns_admins", "campaign_id", "admin_id")->withTimestamps();
    }
    public function scopeWithAdmins($query)
    {
        return $query->with("admins");
    }
    public function filterMainDataFilters()
    {
        $return = $this->toArray();
        unset($return["description"]);
        unset($return["filters"]);
        unset($return["created_at"]);
        unset($return["updated_at"]);
        unset($return["deleted_at"]);
        unset($return["pivot"]);
        return $return;
    }
    public function getFiltersAttribute($value)
    {
        if(isset($this->parsedRules)) {
            return $this->parsedRules;
        }
        $this->parsedFilters = json_decode($value, true);
        return $this->parsedFilters;
    }
    public function setFiltersAttribute($value)
    {
        if(empty($value) || !is_array($value) || is_null($value)) {
            $toSave = [];
        } else {
            $toSave = $value;
            foreach ($value as $gk => $group) {
                foreach ($group as $vk => $v) {
                    if($v["enabled"] !== true) {
                        unset($value[$gk]);
                    }
                }
            }
        }
        $this->attributes["filters"] = json_encode($toSave);
    }
    public function scopeWhereName($query, $str)
    {
        return $query->where("name", "like", "%" . $str . "%");
    }
    public function scopeWhereDescription($query, $str)
    {
        return $query->where("description", "like", "%" . $str . "%");
    }
    public function scopeWhereNameOrDescription($query, $str)
    {
        return $query->where(function ($query) use($query) {
            return $query->orWhere("description", "like", "%" . $str . "%")->orWhere("name", "like", "%" . $str . "%");
        });
    }
    public function scopeWithResourcesCount($query)
    {
        return $query->leftJoin("crm_campaigns_resources", "crm_campaigns_resources.campaign_id", "=", "crm_campaigns.id")->addSelect(\Illuminate\Database\Capsule\Manager::raw("crm_campaigns.*, count(crm_campaigns_resources.id) as resources_count"))->groupBy("crm_campaigns.id");
    }
    public function getActiveAttribute($value)
    {
        return \Carbon\Carbon::now()->between(\Carbon\Carbon::parse($this->date_start), \Carbon\Carbon::parse($this->date_end));
    }
    public function getResourcesCountAttribute()
    {
        return isset($this->attributes["resources_count"]) ? (int) $this->attributes["resources_count"] : 0;
    }
    public function scopeForAdmin($query, $id)
    {
        return $query->whereHas("admins", function ($query) use($query) {
            $query->where("tbladmins.id", "=", $id);
        });
    }
    public function scopeActiveForNow($query)
    {
        return $query->where("date_start", "<=", \Carbon\Carbon::now())->where("date_end", ">=", \Carbon\Carbon::now());
    }
    public function getDateStartAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->toDateString();
    }
    public function getDateEndAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->toDateString();
    }
    public function markAvailableOrNotFor($adminID)
    {
        $this->canAssign = in_array($adminID, $this->admins->pluck("id")->all()) && $this->active ? true : false;
    }
}

?>