<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

/**
 * Class Model for lead/potential
 */
class Automations extends Source\AbstractModel
{
    use Illuminate\Database\Eloquent\SoftDeletes;
    /**
     * Table name
     *
     * @var string
     */
    protected $table = "crm_automations";
    /**
     * Eloquent guarded parameters
     * @var array
     */
    protected $guarded = ["id"];
    /**
     * Eloquent fillable parameters
     * @var array
     */
    protected $fillable = ["name", "status", "order", "rules"];
    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ["created_at", "updated_at", "deleted_at"];
    /**
     * Indicates if the model should soft delete.
     *
     * @var bool
     */
    protected $softDelete = true;
    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = true;
    public function rules()
    {
        return $this->hasMany("mgCRM2\\Models\\AutomationRules", "automation_id", "id")->where("crm_automations_rules.parent_id", "LIKE", 0)->with("rules")->orderBy("order", "asc");
    }
    public function scopeWhereSearch($query, $str)
    {
        return $query->where("name", "like", "%" . $str . "%")->orWhere("id", "like", "%" . $str . "%");
    }
    public function scopeOnlyActive($query)
    {
        return $query->where("status", "like", 1);
    }
}

?>