<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models\AutomationRules;

class OnServiceSuspendRule implements RuleInterface
{
    protected $rule;
    protected $resultData;
    public function setRule($data)
    {
        $this->rule = $data;
        return $this;
    }
    public function validateField()
    {
        return true;
    }
    public function validateRule()
    {
        $eventsData = \mgCRM2\Models\Events::select("data", "created_at")->where("name", \mgCRM2\Services\EventsManager::SERVICE_SUSPENDED)->get();
        $serviceIds = [];
        $eventsData->filter(function ($data) use($data) {
            $event = json_decode($data->data);
            $eventDateCreation = $data->created_at;
            $automationDateCreation = $this->rule->automation->created_at;
            if($automationDateCreation->lt($eventDateCreation) && !$eventDateCreation->lt(\Carbon\Carbon::now()->subDay())) {
                $serviceIds[] = $event->serviceId;
            }
        });
        $this->resultData = $this->resultData->filter(function ($resource) use($resource) {
            if($resource->client->hostings) {
                foreach ($resource->client->hostings as $hosting) {
                    if(in_array($hosting->id, $serviceIds)) {
                        return true;
                    }
                }
            }
            return false;
        });
        return 0 < $this->resultData->count();
    }
    public function execute()
    {
        return $this;
    }
    public function setResultData($data)
    {
        $this->resultData = $data;
        return $this;
    }
    public function getResultData()
    {
        return $this->resultData;
    }
    public function setCustomParams($params)
    {
    }
    public function getCustomParams()
    {
    }
}

?>