<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models\AutomationRules;

class OnEmailSendRule implements RuleInterface
{
    protected $rule;
    protected $resultData;
    protected $fields = ["type"];
    protected $customParams;
    public function setCustomParams($params)
    {
        $this->customParams = $params;
        return $this;
    }
    public function getCustomParams()
    {
        return $this->customParams;
    }
    public function setRule($data)
    {
        $this->rule = $data;
        return $this;
    }
    public function execute()
    {
        return $this;
    }
    public function validateRule()
    {
        $type = $this->rule->data->type->name;
        $eventsData = \mgCRM2\Models\Events::select("data", "created_at")->where("name", \mgCRM2\Services\EventsManager::EMAIL_SENT)->get();
        $relIds = [];
        $eventsData->filter(function ($data) use($data) {
            $event = json_decode($data->data);
            $eventDateCreation = $data->created_at;
            $automationDateCreation = $this->rule->automation->created_at;
            if($type === $event->messageName && $automationDateCreation->lt($eventDateCreation) && !$eventDateCreation->lt(\Carbon\Carbon::now()->subDay())) {
                $relIds[] = $event->relId;
                return true;
            }
        });
        $email = \mgCRM2\Models\Whmcs\EmailTemplates::select("type")->where("name", $type)->first();
        if(is_null($email)) {
            return false;
        }
        $this->resultData = $this->resultData->filter(function ($resource) use($resource) {
            switch ($email->type) {
                case "invoice":
                    return \mgCRM2\Services\FilterEmailSend::invoiceType($resource->client->invoices, $relIds);
                    break;
                case "general":
                    return \mgCRM2\Services\FilterEmailSend::generalType($resource->client, $relIds);
                    break;
                case "product":
                    return \mgCRM2\Services\FilterEmailSend::productType($resource->client->hostings, $relIds);
                    break;
                case "domain":
                    return \mgCRM2\Services\FilterEmailSend::domainType($resource->client->domains, $relIds);
                    break;
                default:
                    return false;
            }
        });
        return 0 < $this->resultData->count();
    }
    public function validateField()
    {
        $data = $this->rule->data;
        $isSuccess = true;
        foreach ($this->fields as $field) {
            if(!isset($data->{$field}) || $data->{$field} === "") {
                $isSuccess = false;
                return $isSuccess;
            }
        }
    }
    public function setResultData($data)
    {
        $this->resultData = $data;
        return $this;
    }
    public function getResultData()
    {
        return $this->resultData;
    }
}

?>