<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models\AutomationRules;

class ConditionIfDaysAfterContactCreatedRule implements RuleInterface
{
    protected $rule;
    protected $resultData;
    protected $fields = ["after"];
    public function setCustomParams($params)
    {
        $this->customParams = $params;
        return $this;
    }
    public function getCustomParams()
    {
        return $this->customParams;
    }
    public function setRule($data)
    {
        $this->rule = $data;
        return $this;
    }
    public function execute()
    {
        return $this;
    }
    public function validateField()
    {
        foreach ($this->fields as $field) {
            if(!isset($this->rule->data->{$field}) || !is_integer($this->rule->data->{$field}) || $this->rule->data->{$field} === NULL) {
                return false;
            }
        }
        if(!is_numeric($this->rule->data->after) || $this->rule->data->after < 0) {
            return false;
        }
        return true;
    }
    public function validateRule()
    {
        $after = (int) $this->rule->data->after;
        $today = (new \Carbon\Carbon())->setTime(0, 0, 0);
        $this->resultData = $this->resultData->filter(function ($record) use($record) {
            $created_at = \Carbon\Carbon::parse($record->created_at);
            $date = (string) $created_at->addDays($after);
            $recordExecutionDate = new \Carbon\Carbon(substr($date, 0, 10));
            return !$today->diffInDays($recordExecutionDate);
        });
        return 0 < count($this->getResultData());
    }
    public function getResultData()
    {
        return $this->resultData;
    }
    public function setResultData($resultData)
    {
        $this->resultData = $resultData;
    }
}

?>