<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models\AutomationRules;

/**
 * Description of ReminderByChangeTypeRule
 *
 * @author Rafał
 */
class ConditionIfChangeTypeRule implements RuleInterface
{
    /**
     * @var \mgCRM2\Models\AutomationRules 
     */
    protected $rule;
    protected $resultData;
    protected $fields = ["contact_type_from_id", "contact_type_to_id", "after"];
    protected $customParams;
    public function setCustomParams($params)
    {
        $this->customParams = $params;
        return $this;
    }
    public function getCustomParams()
    {
        return $this->customParams;
    }
    public function setRule($data)
    {
        $this->rule = $data;
        return $this;
    }
    public function execute()
    {
        return $this;
    }
    public function validateRule()
    {
        $contactTypeFromId = $this->rule->data->contact_type_from_id != 0 ? " #" . $this->rule->data->contact_type_from_id . " " : "";
        $contactTypeToId = $this->rule->data->contact_type_to_id != 0 ? " #" . $this->rule->data->contact_type_to_id . " " : "";
        $afterDays = $this->rule->data->after;
        $resourceIds = array_map(function ($recource) {
            return (int) $recource["id"];
        }, $this->resultData->toArray());
        $contactTypeIds = [];
        foreach (\mgCRM2\Models\ResourceType::orderred()->onlyActive()->pluck("id") as $id) {
            if(!(" #" . $id . " " === $contactTypeFromId || " #" . $id . " " === $contactTypeToId)) {
                $contactTypeIds[] = "% #" . $id . " %";
            }
        }
        $logs = \mgCRM2\Models\Log::whereIn("resource_id", $resourceIds)->whereIn("event", ["Contact Type Change", "New Contact"])->where(function ($query) use($query) {
            $useFrom = false;
            if($contactTypeFromId == "") {
                $query->where("message", "LIKE", "%" . $contactTypeToId . "%");
            } else {
                $useFrom = true;
                $query->where("message", "LIKE", "%" . $contactTypeFromId . "%");
            }
            if($useFrom && $contactTypeToId != "") {
                $query->orWhere("message", "LIKE", "%" . $contactTypeToId . "%");
            }
            if($contactTypeFromId == "" || $contactTypeToId == "") {
                $query->orWhereIn("message", $contactTypeIds);
            }
        })->whereRaw("DATE(`date`) LIKE DATE(NOW() - INTERVAL ? DAY)", [$afterDays])->orderBy("date", "ASC");
        $resourceIds = $this->executeLogs($logs, $contactTypeFromId, $contactTypeToId, $afterDays, $contactTypeIds);
        $this->resultData = $this->resultData->filter(function ($resource) use($resource) {
            return in_array("#" . $resource->id, $resourceIds);
        });
        return 0 < $this->resultData->count();
    }
    public function validateField()
    {
        $data = $this->rule->data;
        $isSuccess = true;
        foreach ($this->fields as $field) {
            if(!isset($data->{$field}) || $data->{$field} === NULL || $data->{$field} === "") {
                $isSuccess = false;
                return $isSuccess;
            }
        }
    }
    public function setResultData($data)
    {
        $this->resultData = $data;
        return $this;
    }
    public function getResultData()
    {
        return $this->resultData;
    }
    protected function getRecource($id)
    {
        foreach ($this->resultData as $recource) {
            if($recource->id == $id) {
                return $recource;
            }
        }
        return \mgCRM2\Models\Resource::with(["admin", "status", "ticket", "client", "campaigns", "labels", "fieldDatasWithAll", "logs"])->where("id", $id)->first();
    }
    protected function executeLogs($query, $contactTypeFromId, $contactTypeToId, $afterDays, $contactTypeIds)
    {
        $resourceIds = [];
        foreach ($query->get() as $log) {
            $findOtheIds = [];
            foreach ($contactTypeIds as $id) {
                if(($findOtherId = strpos($log->message, str_replace("%", "", $id))) !== false) {
                    $findOtheIds[] = [$this->convertToId($id), $findOtherId];
                }
            }
            $fromPosition = $contactTypeFromId == "" ? false : (strpos($log->message, $contactTypeFromId) !== false ? strpos($log->message, $contactTypeFromId) : false);
            $toPosition = $contactTypeToId == "" ? false : (strpos($log->message, $contactTypeToId) !== false ? strpos($log->message, $contactTypeToId) : false);
            if($log->event == "New Contact" && $contactTypeFromId === "") {
                if($toPosition !== true) {
                    if(!in_array("#" . $log->resource_id, $resourceIds)) {
                        $resourceIds[] = "#" . $log->resource_id;
                    }
                } elseif(count($findOtheIds) == 1 && !in_array("#" . $log->resource_id, $resourceIds)) {
                    $resourceIds[] = "#" . $log->resource_id;
                }
            } elseif($contactTypeFromId !== "" && $contactTypeToId !== "") {
                if($fromPosition < $toPosition && !in_array("#" . $log->resource_id, $resourceIds)) {
                    $resourceIds[] = "#" . $log->resource_id;
                }
            } elseif(count($findOtheIds) === 2 && $contactTypeFromId === "" && $contactTypeToId === "") {
                if(!in_array("#" . $log->resource_id, $resourceIds)) {
                    $resourceIds[] = "#" . $log->resource_id;
                }
            } elseif(count($findOtheIds) === 1 && ($contactTypeFromId !== "" || $contactTypeToId !== "")) {
                list($id, $position) = $findOtheIds[0];
                if($contactTypeFromId !== "" && strpos($log->message, $contactTypeFromId) < $position) {
                    if(!in_array("#" . $log->resource_id, $resourceIds)) {
                        $resourceIds[] = "#" . $log->resource_id;
                    }
                } elseif($contactTypeToId !== "" && $position < strpos($log->message, $contactTypeToId) && !in_array("#" . $log->resource_id, $resourceIds)) {
                    $resourceIds[] = "#" . $log->resource_id;
                }
            }
        }
        return $resourceIds;
    }
    protected function convertToId($string)
    {
        return (int) str_replace([" ", "%", "#"], "", $string);
    }
}

?>