<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models\AutomationRules;

/**
 * Description of ReminderByChangeLabelRule
 *
 * @author Rafał
 */
class ConditionIfChangeLabelRule implements RuleInterface
{
    /**
     * @var \mgCRM2\Models\AutomationRules 
     */
    protected $rule;
    protected $resultData;
    protected $fields = ["after", "label_from_id", "label_to_id"];
    protected $customParams;
    public function setCustomParams($params)
    {
        $this->customParams = $params;
        return $this;
    }
    public function getCustomParams()
    {
        return $this->customParams;
    }
    public function setRule($data)
    {
        $this->rule = $data;
        return $this;
    }
    public function execute()
    {
        return $this;
    }
    public function validateRule()
    {
        $labelFromId = $this->rule->data->label_from_id != 0 ? " #" . $this->rule->data->label_from_id . " " : "";
        $labelToId = $this->rule->data->label_to_id != 0 ? " #" . $this->rule->data->label_to_id . " " : "";
        $afterDays = $this->rule->data->after;
        $resourceIds = array_map(function ($resource) {
            return $resource["id"];
        }, $this->resultData->toArray());
        $labelIds = [];
        foreach (\mgCRM2\Models\Label::pluck("id")->toArray() as $id) {
            if(!(" #" . $id . " " === $labelFromId || " #" . $id . " " === $labelToId)) {
                $labelIds[] = "% #" . $id . " %";
            }
        }
        $logs = \mgCRM2\Models\Log::whereIn("resource_id", $resourceIds)->where("event", "LIKE", "Labels Move")->where(function ($query) use($query) {
            $useFrom = false;
            if($labelFromId == "") {
                $query = $query->where("message", "LIKE", "%" . $labelToId . "%");
            } else {
                $useFrom = true;
                $query = $query->where("message", "LIKE", "%" . $labelFromId . "%");
            }
            if($useFrom && $labelToId != "") {
                $query = $query->orWhere("message", "LIKE", "%" . $labelToId . "%");
            }
            if($labelFromId == "" || $labelToId == "") {
                $query = $query->orWhere("message", "LIKE", "%empty%");
                $query = $query->orWhereIn("message", $labelIds);
            }
        })->whereRaw("DATE(`date`) LIKE DATE(NOW() - INTERVAL ? DAY)", [$afterDays])->orderBy("date", "ASC");
        $resourceIds = $this->executeLogs($logs, $labelFromId, $labelToId, $afterDays, $labelIds);
        $this->resultData = $this->resultData->filter(function ($resource) use($resource) {
            return in_array("#" . $resource->id, $resourceIds);
        });
        return 0 < $this->resultData->count();
    }
    public function validateField()
    {
        $data = $this->rule->data;
        $isSuccess = true;
        foreach ($this->fields as $field) {
            if(!isset($data->{$field}) || $data->{$field} === NULL || $data->{$field} === "") {
                $isSuccess = false;
                return $isSuccess;
            }
        }
    }
    public function setResultData($data)
    {
        $this->resultData = $data;
        return $this;
    }
    public function getResultData()
    {
        return $this->resultData;
    }
    protected function getRecource($id)
    {
        foreach ($this->resultData as $recource) {
            if($recource->id == $id) {
                return $recource;
            }
        }
        return \mgCRM2\Models\Resource::with(["admin", "status", "ticket", "client", "campaigns", "labels", "fieldDatasWithAll", "logs"])->where("id", $id)->first();
    }
    protected function executeLogs($query, $labelFromId, $labelToId, $afterDays, $labelIds)
    {
        $resourceIds = [];
        foreach ($query->get() as $log) {
            $findFirstEmpty = strpos($log->message, "empty");
            $findSecountEmpty = strpos($log->message, "empty", $findFirstEmpty + 1);
            $fromPosition = $labelFromId == "" ? false : (strpos($log->message, $labelFromId) !== false ? strpos($log->message, $labelFromId) : true);
            $toPosition = $labelToId == "" ? false : (strpos($log->message, $labelToId) !== false ? strpos($log->message, $labelToId) : true);
            $findOtheIds = [];
            foreach ($labelIds as $id) {
                if(($findOtherId = strpos($log->message, str_replace("%", "", $id))) !== false) {
                    $findOtheIds[] = [$this->convertToId($id), $findOtherId];
                }
            }
            if($labelFromId !== "" && $toPosition !== "") {
                if($fromPosition < $toPosition && !in_array("#" . $log->resource_id, $resourceIds)) {
                    $resourceIds[] = "#" . $log->resource_id;
                }
            } elseif(!($findFirstEmpty !== false && $findSecountEmpty !== false)) {
                if($findFirstEmpty === false && $findSecountEmpty === false && count($findOtheIds) === 2 && $labelFromId === "" && $labelToId === "") {
                    list($firstId, $startPositon) = $findOtheIds[0];
                    list($secountId, $endPosition) = $findOtheIds[1];
                    if(!in_array("#" . $log->resource_id, $resourceIds)) {
                        $resourceIds[] = "#" . $log->resource_id;
                    }
                } elseif($findFirstEmpty !== false && count($findOtheIds) === 1 && $labelFromId === "" && $labelToId === "") {
                    list($firstId, $startPositon) = $findOtheIds[0];
                    if(!in_array("#" . $log->resource_id, $resourceIds)) {
                        $resourceIds[] = "#" . $log->resource_id;
                    }
                } elseif($findFirstEmpty !== false && ($labelFromId !== "" || $labelToId !== "")) {
                    if($labelFromId !== "" && strpos($log->message, $labelFromId) < $findFirstEmpty) {
                        if(!in_array("#" . $log->resource_id, $resourceIds)) {
                            $resourceIds[] = "#" . $log->resource_id;
                        }
                    } elseif($labelToId !== "" && $findFirstEmpty < strpos($log->message, $labelToId) && !in_array("#" . $log->resource_id, $resourceIds)) {
                        $resourceIds[] = "#" . $log->resource_id;
                    }
                } elseif(count($findOtheIds) === 1 && ($labelFromId !== "" || $labelToId !== "")) {
                    list($id, $position) = $findOtheIds[0];
                    if($labelFromId !== "" && strpos($log->message, $labelFromId) < $position) {
                        if(!in_array("#" . $log->resource_id, $resourceIds)) {
                            $resourceIds[] = "#" . $log->resource_id;
                        }
                    } elseif($labelToId !== "" && $position < strpos($log->message, $labelToId) && !in_array("#" . $log->resource_id, $resourceIds)) {
                        $resourceIds[] = "#" . $log->resource_id;
                    }
                }
            }
        }
        return $resourceIds;
    }
    protected function convertToId($string)
    {
        return (int) str_replace([" ", "%", "#"], "", $string);
    }
}

?>