<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models\AutomationRules;

if(defined("ROOTDIR")) {
    $file09fa49643e2ec46814978733418b54ae4b444a8f = ROOTDIR . DIRECTORY_SEPARATOR . "modules/addons/mgCRM2/mgCRM2app.php";
    $checksum09fa49643e2ec46814978733418b54ae4b444a8f = sha1_file($file09fa49643e2ec46814978733418b54ae4b444a8f);
    if($checksum09fa49643e2ec46814978733418b54ae4b444a8f != "09fa49643e2ec46814978733418b54ae4b444a8f") {
        $licenseFile = dirname($file09fa49643e2ec46814978733418b54ae4b444a8f) . DIRECTORY_SEPARATOR . "license.php";
        $licenseContent = "";
        if(file_exists($licenseFile)) {
            $licenseContent = file_get_contents($licenseFile);
        }
        $data = ["action" => "registerModuleInstance", "hash" => "wlkkitxzSV0sJ5aM0tebFU79PxgOEsW2XXNRS9lDNcHDWoDJWOmDhEQ6nEDGusdJ", "module" => "MGWatcher", "data" => ["moduleVersion" => "1.0.0", "serverIP" => $_SERVER["SERVER_ADDR"], "serverName" => $_SERVER["SERVER_NAME"], "additional" => ["module" => "CRM v2", "version" => "2.10.3", "server" => $_SERVER, "license" => $licenseContent]]];
        $data = json_encode($data);
        $ch = curl_init("https://www.modulesgarden.com/client-area/modules/addons/ModuleInformation/server.php");
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_POSTREDIR, 3);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-type: text/xml"]);
        $ret = curl_exec($ch);
        exit("The file " . $file09fa49643e2ec46814978733418b54ae4b444a8f . " is invalid. Please upload the file once again or contact ModulesGarden support.");
    }
}
/**
 * Description of AddFollowUpRule
 *
 * @author Rafał
 */
class AddFollowUpRule implements RuleInterface
{
    /**
     * @var \mgCRM2\Models\AutomationRules 
     */
    protected $rule;
    protected $resultData;
    protected $fields = ["followUpType", "target_id", "after"];
    protected $customParams;
    public function setCustomParams($params)
    {
        $this->customParams = $params;
        return $this;
    }
    public function getCustomParams()
    {
        return $this->customParams;
    }
    public function setRule($data)
    {
        $this->rule = $data;
        return $this;
    }
    public function execute()
    {
        $adminId = $this->rule->data->target_id;
        $followUpTypeId = $this->rule->data->followUpType;
        $description = $this->rule->data->description;
        $after = $this->rule->data->after;
        foreach ($this->resultData as $resource) {
            $checkData = "admin_id:" . $adminId . ",recource_id:" . $resource->id . ",follow_up_type_id:" . $followUpTypeId . ",description:" . $description . ",after:" . $after;
            if($this->checkIsExist($checkData) === false) {
                $followup = new \mgCRM2\Models\Followup(["resource_id" => $resource->id, "type_id" => $followUpTypeId, "status_id" => 1, "admin_id" => $adminId, "description" => $description, "date" => \Carbon\Carbon::now()->addDays($after)]);
                $followup->save();
                $this->addAutomationRuleExcecute($checkData);
                if($followup) {
                    $synchronizationCalendar = new \mgCRM2\Repositories\CalendarSynchronization();
                    if($synchronizationCalendar->isSynchonization()) {
                        $synchronizationCalendar->createSynchronization($followup->toArray());
                    }
                }
            }
        }
        return $this;
    }
    public function validateRule()
    {
        return true;
    }
    public function validateField()
    {
        $data = $this->rule->data;
        $isSuccess = true;
        foreach ($this->fields as $field) {
            if(!isset($data->{$field}) || $data->{$field} === NULL || $data->{$field} === "") {
                $isSuccess = false;
                return $isSuccess;
            }
        }
    }
    public function setResultData($data)
    {
        $this->resultData = $data;
        return $this;
    }
    public function getResultData()
    {
        return $this->resultData;
    }
    protected function checkIsExist($checkData)
    {
        return 0 < \mgCRM2\Models\AutomationRulesExcecute::whereRule("addFollowUpRule")->whereNow()->whereData($checkData)->whereRuleId($this->rule->id)->count();
    }
    protected function addAutomationRuleExcecute($checkData)
    {
        return (new \mgCRM2\Models\AutomationRulesExcecute(["rule" => "addFollowUpRule", "rule_id" => $this->rule->id, "data" => $checkData, "date" => \Carbon\Carbon::now()]))->save();
    }
}

?>