<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Middleware;

class TemplateVariables extends \Slim\Middleware
{
    public function call()
    {
        if(!$this->app->view instanceof \mgCRM2\Integration\Slim\JsonView) {
            $app = $this->app;
            $data = $this->getSharedData();
            $app->hook("slim.before.dispatch", function () {
                foreach ($data as $key => $value) {
                    $app->view()->set($key, $value);
                }
            }, 5);
        }
        $this->next->call();
    }
    protected function getSharedData()
    {
        $data = [];
        $globalSettings = $this->app->container->settings;
        foreach ($globalSettings as $key => $value) {
            if(!is_object($value)) {
                array_set($data["settings"], $key, $value);
            }
        }
        $configFileContainer = $this->app->container->get("configFile");
        $configFile = $configFileContainer->all();
        $configFile = reset($configFile);
        $data["configFile"] = $configFile;
        array_set($data["settings"], "templates.rootDir", $this->app->config("appDir") . "templates/" . $configFileContainer->get("app.templates.template"));
        if($this->app->config("skipWHMCS") === false) {
            global $CRM_ADMINAREA_OUTPUT;
            $CRM_ADMINAREA_OUTPUT = str_replace("\$(\"#whmcsdevbanner\").css(\"display\",\"inline\");", "\$(\"#whmcsdevbanner\").remove();", $CRM_ADMINAREA_OUTPUT);
            $CRM_ADMINAREA_OUTPUT = str_replace("\$(\"body\").css(\"margin\",\"0 0 \"+\$(\"#whmcsdevbanner\").height()+\"px 0\");", "", $CRM_ADMINAREA_OUTPUT);
            $CRM_ADMINAREA_OUTPUT = str_replace("<html", "<html id=\"ng-app\"  data-ng-app=\"mgCRMapp\"", $CRM_ADMINAREA_OUTPUT);
            preg_match("#<head(.*?)>(.*?)</head>#is", $CRM_ADMINAREA_OUTPUT, $maches);
            $CRM_ADMINAREA_OUTPUT = str_replace($maches, "{{head}}", $CRM_ADMINAREA_OUTPUT);
            libxml_use_internal_errors(true);
            $headHtml = new \DOMDocument();
            $headHtml->loadHTML($maches[0]);
            $toRemove = ["jquery.min.js", "jquery.js", "bootstrap.min.js", "bootstrap.js", "jquery-ui.min.js", "jquery-ui.js", "jqueryui.js"];
            $scriptsToAdd = [array_get($data, "settings.templates.rootDir") . "/assets/plugins/jquery/jquery-1.11.2.min.js", array_get($data, "settings.templates.rootDir") . "/assets/plugins/jquery-migrate/jquery-migrate-1.2.1.min.js", array_get($data, "settings.templates.rootDir") . "/assets/plugins/jquery-ui/js/jquery-ui.min.js"];
            $domElemsToRemove = [];
            $headScripts = $headHtml->getElementsByTagName("script");
            foreach ($headScripts as $script) {
                $found = explode("/", $script->getAttribute("src"));
                if(in_array(array_pop($found), $toRemove)) {
                    $domElemsToRemove[] = $script;
                }
            }
            $headScripts = $headHtml->getElementsByTagName("link");
            foreach ($headScripts as $style) {
                if($style->getAttribute("rel") == "stylesheet" && $style->getAttribute("type") == "text/css") {
                    $found = explode("/", $style->getAttribute("href"));
                    if(in_array(array_pop($found), $toRemove)) {
                        $domElemsToRemove[] = $style;
                    }
                }
            }
            foreach ($domElemsToRemove as $domElement) {
                $domElement->parentNode->removeChild($domElement);
            }
            $headTitle = $headHtml->getElementsByTagName("title")->item(0);
            $headTitle->setAttribute("data-ng-bind", "page.title");
            $head = $headHtml->getElementsByTagName("head")->item(0);
            $link = $headHtml->createElement("link");
            $link->setAttribute("rel", "shortcut icon");
            $link->setAttribute("href", $this->app->config("appDir") . "templates/" . $configFileContainer->get("app.templates.template") . "/assets/img/favicon.png");
            $head->appendChild($link);
            $first = $headHtml->getElementsByTagName("script");
            if(0 < $first->length) {
                $insertBefore = $first->item(0);
            }
            foreach ($scriptsToAdd as $a) {
                $newChild = $headHtml->createElement("script");
                $newChild->setAttribute("type", "text/javascript");
                $newChild->setAttribute("src", $a);
                if(isset($insertBefore) && $insertBefore instanceof \DOMNode) {
                    $insertBefore->parentNode->insertBefore($newChild, $insertBefore);
                } else {
                    $headHtml->appendChild($newChild);
                }
            }
            $CRM_ADMINAREA_OUTPUT = str_replace("{{head}}", $headHtml->saveHTML($head), $CRM_ADMINAREA_OUTPUT);
            $data["whmcs"]["templateContent"] = $CRM_ADMINAREA_OUTPUT;
        }
        $data["whmcs"]["isVersion6"] = $this->app->whmcs->isVersion6();
        $data["whmcs"]["isVersion78"] = $this->app->whmcs->isVersion78();
        $data["whmcs"]["version"] = $this->app->whmcs->getVersion();
        $admin = \mgCRM2\Models\Whmcs\Admin::find($_SESSION["adminid"]);
        $data["whmcs"]["isLaraTemplate"] = $admin->template == "lara" ? 1 : 0;
        array_set($data["settings"], "templates.renderStandalone", $this->app->config("templates.renderStandalone"));
        array_set($data["settings"], "templates.template", $configFileContainer->get("app.templates.template"));
        array_set($data["settings"], "templates", array_merge($data["settings"]["templates"], $configFileContainer->get("app.templates")));
        array_set($data["settings"], "templates.appFilename", $this->app->config("appFilename"));
        array_set($data["settings"], "templates.apiURL", $this->app->config("appAdminUrl") . "/api");
        array_set($data["settings"], "templates.appAdminDir", $this->app->config("appAdminDir"));
        array_set($data["settings"], "templates.appAdminUrl", $this->app->config("appAdminUrl"));
        array_set($data["settings"], "templates.appDir", $this->app->config("appDir"));
        array_set($data["settings"], "templates.whmcsDir", $this->app->config("whmcsDir"));
        array_set($data["settings"], "url_scheme", $this->app->environment["slim.url_scheme"]);
        array_set($data["settings"], "isSecured", $this->app->environment["slim.url_scheme"] === "https");
        array_set($data["settings"], "dynamicTypes", \mgCRM2\Repositories\ResourceTypes::getForNavigation());
        $migratorHelper = new \mgCRM2\Helpers\MigrationHelper();
        array_set($data["settings"], "isMigrationAvailable", $migratorHelper->isOldCrmCompatibleToMigrate());
        array_set($data["settings"], "templates.app", \mgCRM2\Repositories\Settings::getGlobalsForTwig());
        array_set($data["settings"], "templates.integrations", \mgCRM2\Services\Monitor::getInstance()->checkIntegrations());
        $data["lang"] = $this->app->lang;
        $data["acl"] = $this->app->acl;
        $data["currentAdmin"] = $this->app->currentAdmin->id;
        return $data;
    }
}

?>