<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Middleware;

/**
 * Pretty Exceptions
 *
 * This middleware catches any Exception thrown by the surrounded
 * application and displays a developer-friendly diagnostic screen.
 *
 * Improved standard Slim PrettyExceptions by our modifications for our needs
 *
 * @author      Josh Lockhart
 * @modified    Piotr Sarzyński <piotr.sa@modulesgarden.com> 
 */
class PrettyExceptions extends \Slim\Middleware
{
    /**
     * @var array
     */
    protected $settings;
    public function __construct($settings = [])
    {
        $this->settings = $settings;
    }
    public function call()
    {
        try {
            if(array_get($this->settings, "cron", false) === false) {
                if($this->app->acl->isAdminLoggedIn() === false) {
                    throw new \Exception("Log in to system first", 1);
                }
                if($this->app->acl->isAdminHassAccessToModule() === false) {
                    throw new \Exception("Access Denied. Access has not been given for your admin role group to access this addon module. You can grant access in Setup > Addon Modules", 2);
                }
            }
            $this->next->call();
        } catch (\Exception $ex) {
            self::handleError($e);
        }
    }
    public static function handleError($e)
    {
        $app = \mgCRM2\Integration\Slim\SlimApp::getInstance();
        if($app->config("debug") || $app->config("log.enabled")) {
            $app->log->error($e);
        }
        $requestedResponse = explode("/", $app->request->getPath());
        $requestedResponse = strtolower(last($requestedResponse));
        if($requestedResponse == "json" || $app->request->isAjax()) {
            $return = ["status" => "error", "msg" => $e->getMessage()];
            if($app->config("debug")) {
                $return["_debug"] = ["code" => $e->getCode(), "message" => $e->getMessage(), "file" => $e->getFile(), "line" => $e->getLine(), "trace" => $e->getTrace()];
            }
            $app->response->header("Content-Type", "application/json");
            $app->response()->status(500);
            $app->response()->body(json_encode($return));
        } else {
            $app->contentType("text/html");
            $app->response()->status(500);
            $app->response()->body(self::renderExceptionBody($app->config("debug"), $e));
        }
    }
    public static function renderExceptionBody($debug, $exception)
    {
        $title = "";
        $html = sprintf("<h1>Error</h1>", $title);
        $html .= sprintf("<h2>%s</h2>", $exception->getMessage());
        if($debug) {
            $code = $exception->getCode();
            $message = $exception->getMessage();
            $file = $exception->getFile();
            $line = $exception->getLine();
            $trace = str_replace(["#", "\n"], ["<div>#", "</div>"], $exception->getTraceAsString());
            if($code) {
                $html .= sprintf("<div><strong>Code:</strong> %s</div>", $code);
            }
            if($message) {
                $html .= sprintf("<div><strong>Message:</strong> %s</div>", $message);
            }
            if($file) {
                $html .= sprintf("<div><strong>File:</strong> %s</div>", $file);
            }
            if($line) {
                $html .= sprintf("<div><strong>Line:</strong> %s</div>", $line);
            }
            if($trace) {
                $html .= "<h2>Trace</h2>";
                $html .= sprintf("<pre>%s</pre>", $trace);
            }
        }
        return sprintf("<html><head><title>%s</title><style>body{margin:0;padding:30px;font:12px/1.5 Helvetica,Arial,Verdana,sans-serif;}h1{margin:0;font-size:48px;font-weight:normal;line-height:48px;}strong{display:inline-block;width:65px;}</style></head><body>%s</body></html>", $title, $html);
    }
}

?>