<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Middleware;

class DebugBar extends \Slim\Middleware
{
    /**
     * Slim Application instance
     *
     * @var \Slim\Slim
     */
    protected $app;
    /**
     * Debugbar instance
     *
     * @var \DebugBar\SlimDebugBar
     */
    protected $debugbar;
    /**
     * keep reference to instance of this class
     *
     * @var mgCRM2\Middleware\DebugBar
     */
    private static $instance;
    /**
     * @var HttpDriverInterface
     */
    protected $httpDriver;
    public static function getInstance()
    {
        if(!is_object(self::$instance)) {
            $c = "mgCRM2\\Middleware\\DebugBar";
            self::$instance = new $c();
        }
        return self::$instance;
    }
    public function __construct(\mgCRM2\Integration\DebugBar\HttpDriverInterface $HttpDriver = NULL)
    {
        $this->httpDriver = $HttpDriver;
        $this->debugbar = \mgCRM2\Integration\DebugBar\SlimDebugBar::getInstance();
    }
    public function addCollector(\mgCRM2\Integration\DebugBar\DataCollector\DataCollectorInterface $collector)
    {
        $this->debugbar->addCollector($collector);
    }
    public function getDebugBar()
    {
        return $this->debugbar;
    }
    public function getApp()
    {
        return $this->app;
    }
    public function setDebugBar(\DebugBar\DebugBar $debugbar)
    {
        $this->debugbar = $debugbar;
    }
    public function call()
    {
        $this->prepareDebugBar();
        $httpDriver = $this->httpDriver ?: new \mgCRM2\Integration\DebugBar\SlimHttpDriver($this->app);
        $this->debugbar->setHttpDriver($httpDriver);
        $this->setAssetsRoute();
        $this->next->call();
        if($this->isAssetsRoute()) {
            return NULL;
        }
        if($this->app->request->isAjax()) {
            if($this->debugbar->getStorage()) {
                $this->debugbar->sendDataInHeaders($useOpenHandler = true);
            }
        } else {
            if(!$this->isModifiable()) {
                return NULL;
            }
            if($this->app->config("turnOffDebugBar")) {
                return NULL;
            }
            $html = $this->app->response->body();
            $this->app->response->body($this->modifyResponse($html));
        }
    }
    public function isModifiable()
    {
        if($this->app->response->isRedirect()) {
            if($this->debugbar->getHttpDriver()->isSessionStarted()) {
                $this->debugbar->stackData();
            }
            return false;
        }
        if(!$this->isHtmlResponse()) {
            return false;
        }
        return true;
    }
    public function isHtmlResponse()
    {
        $content_type = $this->app->response->header("Content-Type");
        return stripos($content_type, "html") !== false;
    }
    public function modifyResponse($html)
    {
        $debug_html = $this->getDebugHtml();
        $pos = mb_strripos($html, "</body>");
        if($pos === false) {
            $html .= $debug_html;
        } else {
            $html = mb_substr($html, 0, $pos) . $debug_html . mb_substr($html, $pos);
        }
        return $html;
    }
    public function getDebugHtml()
    {
        $renderer = $this->debugbar->getJavascriptRenderer();
        if($this->debugbar->getStorage()) {
            $renderer->setOpenHandlerUrl($this->app->router->urlFor("debugbar.openhandler"));
        }
        $html = $this->getAssetsHtml();
        if($renderer->isJqueryNoConflictEnabled()) {
            $html .= "\n<script type=\"text/javascript\">jQuery.noConflict(true);</script>";
        }
        return $html . "\n" . $renderer->render();
    }
    public function getAssetsHtml()
    {
        return "<script type=\"text/javascript\" src=\"" . $_SERVER["SCRIPT_NAME"] . "/_debugbar/resources/dump.js\"></script>" . "<link rel=\"stylesheet\" type=\"text/css\" href=\"" . $_SERVER["SCRIPT_NAME"] . "/_debugbar/resources/dump.css\">";
    }
    protected function prepareDebugBar()
    {
        if($this->debugbar instanceof \mgCRM2\Integration\DebugBar\SlimDebugBar) {
            $this->debugbar->initCollectors($this->app);
        }
        $storage = $this->app->config("debugbar.storage");
        if($storage instanceof \mgCRM2\Integration\DebugBar\Storage\StorageInterface) {
            $this->debugbar->setStorage($storage);
        }
        $this->app->container->set("debugbar", $this->debugbar);
    }
    protected function setAssetsRoute()
    {
        $renderer = $this->debugbar->getJavascriptRenderer();
        $this->app->get("/_debugbar/fonts/:file", function ($file) use($file) {
            $thisInstance = \mgCRM2\Integration\Slim\SlimApp::getInstance();
            $files = explode("?", $file);
            $file = reset($files);
            $path = $renderer->getBasePath() . "/vendor/font-awesome/fonts/" . $file;
            if(file_exists($path)) {
                $thisInstance->response->header("Content-Type", mime_content_type($path));
                echo file_get_contents($path);
            } else {
                $thisInstance->notFound();
            }
        })->name("debugbar.fonts");
        $this->app->get("/_debugbar/resources/:file", function ($file) use($file) {
            $thisInstance = \mgCRM2\Integration\Slim\SlimApp::getInstance();
            $files = explode(".", $file);
            $ext = end($files);
            if($ext === "css") {
                $thisInstance->response->header("Content-Type", "text/css");
                $renderer->dumpCssAssets();
            } elseif($ext === "js") {
                $thisInstance->response->header("Content-Type", "text/javascript");
                $renderer->dumpJsAssets();
            }
        })->name("debugbar.resources");
        $this->app->get("/_debugbar/openhandler", function () {
            $thisDebugBarInstance = DebugBar::getInstance();
            $thisInstance = \mgCRM2\Integration\Slim\SlimApp::getInstance();
            $openHandler = new \mgCRM2\Integration\DebugBar\OpenHandler($thisDebugBarInstance->getDebugBar());
            $data = $openHandler->handle($request = NULL, $echo = false, $sendHeader = false);
            $thisInstance->response->header("Content-Type", "application/json");
            $thisInstance->response->setBody($data);
        })->name("debugbar.openhandler");
    }
    protected function isAssetsRoute()
    {
        $route = $this->app->router->getCurrentRoute();
        if($route) {
            $name = $route->getName();
            $return = explode(".", $name);
            return $return[0] === "debugbar";
        }
        return false;
    }
}

?>